<?php
// cron_auto_checkout.php
// Is file ko schedule karein: 59 23 * * * /usr/bin/php /path/to/cron_auto_checkout.php

include("../includes/cpt.inc.php"); 

$current_date = date('Y-m-d');
$current_time = date('23:59:00'); // 11:59 PM
$log_file = "auto_checkout_log.txt";

// Function to log messages
function writeLog($message) {
    global $log_file;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($log_file, "[$timestamp] $message\n", FILE_APPEND);
}

writeLog("===== Auto Checkout Scheduler Started =====");

// Get all employees who checked in today but haven't checked out
$table_name = DB."attendance";
$where = "att_check_in_date = :today AND att_check_out_date IS NULL";
$bind = array(":today" => $current_date);

$pending_checkouts = $objDatabaseModel->select($table_name, $where, $bind, "*");

if (empty($pending_checkouts)) {
    writeLog("No pending checkouts found for today.");
    echo "No pending checkouts found.\n";
    exit;
}

$count = 0;
foreach ($pending_checkouts as $row) {
    $id = $row['id'];
    $emp_id = $row['emp_id'];
    $emp_name = $row['emp_name'];
    $check_in_time = $row['att_check_in_time'];
    
    // Prepare update data for auto checkout
    $update_table_name = DB."attendance";
    $update = array(
        'att_check_out_date' => $current_date,
        'att_check_out_time' => $current_time,
        'check_out_latitude' => 0.00000000,
        'check_out_longitude' => 0.00000000,
        'check_out_accuracy' => 0.00,
        'check_out_ip_address' => 'System Auto',
        'check_out_city' => 'System',
        'check_out_region' => 'System',
        'check_out_country' => 'System',
        'check_out_isp' => 'System',
        'check_out_user_agent' => 'Scheduler Auto Checkout',
        'check_out_browser' => 'System',
        'check_out_device_type' => 'System',
        'check_out_type' => 'Scheduler Check Out'
    );
    
    $update_where = "id = :id";
    $update_bind = array(":id" => $id);
    
    $result = $objDatabaseModel->update($update_table_name, $update, $update_where, $update_bind);
    
    if ($result) {
        $count++;
        writeLog("Auto checkout successful for Employee: $emp_name (ID: $emp_id) - Check In: $check_in_time");
    } else {
        writeLog("ERROR: Auto checkout failed for Employee: $emp_name (ID: $emp_id)");
    }
}

writeLog("Total $count employees auto checked out successfully.");
writeLog("===== Auto Checkout Scheduler Completed =====\n");

//echo "Auto checkout completed. $count employees processed.\n";
?>