<div class="row">
    <div class="col-sm-12">
        <h3>Attendance Calendar</h3>
        
        <?php
        // Current month/year ya selected month/year
        $currentMonth = isset($_POST['cal_month']) ? (int)$_POST['cal_month'] : (int)date('m');
        $currentYear = isset($_POST['cal_year']) ? (int)$_POST['cal_year'] : (int)date('Y');
        
        // Month navigation
        $prevMonth = $currentMonth == 1 ? 12 : $currentMonth - 1;
        $prevYear = $currentMonth == 1 ? $currentYear - 1 : $currentYear;
        $nextMonth = $currentMonth == 12 ? 1 : $currentMonth + 1;
        $nextYear = $currentMonth == 12 ? $currentYear + 1 : $currentYear;
        
        // Month name
        $monthName = date('F', mktime(0, 0, 0, $currentMonth, 10, $currentYear));
        
        // Get first day of month and total days
        $firstDay = mktime(0, 0, 0, $currentMonth, 1, $currentYear);
        $totalDays = date('t', $firstDay);
        $startDay = date('w', $firstDay); // 0 = Sunday, 1 = Monday, etc.
        
        // ========== CONFIGURABLE WEEKLY OFFS ==========
        $weeklyOffDays = array(0); // Weekly Off for ALL months
        
        $satOFON = $objDatabaseModel->fununiversal('emp_posting_info','sat_off_yes_no','emp_id',$_SESSION['idEMP']);
        
        if($satOFON==0){
            // Default: 2nd और 4th Saturday off
            $specificSaturdays = array(); //////////////////2,4
        }else{
            // Get comma-separated values from database
            $sat = $objDatabaseModel->fununiversal('emp_posting_info','no_sat','emp_id',$_SESSION['idEMP']);
            
            // Trim and clean the values
            $sat = trim($sat);
            if(!empty($sat)) {
                $offSaturdays = explode(',', $sat);
                // Remove any whitespace and convert to integers
                $offSaturdays = array_map('trim', $offSaturdays);
                $offSaturdays = array_map('intval', $offSaturdays);
                // Remove empty values
                $offSaturdays = array_filter($offSaturdays);
                // Sort the array
                sort($offSaturdays);
                $specificSaturdays = $offSaturdays;
            } else {
                $specificSaturdays = array(); // No specific Saturdays off
            }
        }
        
        // Debug - Check specificSaturdays array
        // echo "<pre>Specific Saturdays: "; print_r($specificSaturdays); echo "</pre>";
        
        // Current date for comparison
        $today = date('Y-m-d');
        
        // ========== FETCH HOLIDAYS FROM DATABASE ==========
        $holiday_table = DB."emp_holidays";
        $holiday_where = "status = 1 AND YEAR(holidays_date) = $currentYear AND MONTH(holidays_date) = $currentMonth";
        $holidays = $objDatabaseModel->select($holiday_table, $holiday_where, '', "*");
        
        $holidayArray = array();
        foreach($holidays as $h) {
            $date = date('j', strtotime($h['holidays_date']));
            $holidayArray[$date] = $h['holidays_title'];
        }
        
        // ========== FETCH LEAVES FOR CURRENT MONTH ONLY ==========
        $tAL = DB."apply_leave";
        $wh = "leave_Approved=1 
               AND emp_id='".$_SESSION['idEMP']."'               
               AND startDate BETWEEN '".$_SESSION['contractStartdate']."' AND '".$_SESSION['contractEnddate']."' 
               AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL)
               AND MONTH(startDate) = $currentMonth
               AND YEAR(startDate) = $currentYear";
        
        $rAL = $objDatabaseModel->select($tAL, $wh, '', "startDate AS leaveTakenDate");
        
        // Create leave dates array for current month
        $leaveDates = array();
        foreach($rAL as $leave) {
            $leaveDate = date('j', strtotime($leave['leaveTakenDate']));
            $leaveDates[$leaveDate] = 'Leave';
        }
        
        // ========== FETCH ATTENDANCE DATA ==========
        $att_table = DB."attendance";
        $att_where = "emp_id = '".$_SESSION['idEMP']."' 
                      AND MONTH(att_check_in_date) = $currentMonth 
                      AND YEAR(att_check_in_date) = $currentYear";
        $attendance = $objDatabaseModel->select($att_table, $att_where, '', "att_check_in_date, att_check_in_time, att_check_out_time");
        
        // Group attendance by date
        $attendanceByDate = array();
        foreach($attendance as $att) {
            $day = date('j', strtotime($att['att_check_in_date']));
            if(!isset($attendanceByDate[$day])) {
                $attendanceByDate[$day] = array(
                    'present' => false,
                    'incomplete' => false
                );
            }
            
            if(!empty($att['att_check_out_time'])) {
                $attendanceByDate[$day]['present'] = true;
            } else {
                $attendanceByDate[$day]['incomplete'] = true;
            }
        }
        
        // ========== PRE-CALCULATE SATURDAY OFF POSITIONS ==========
        // Find all Saturdays in the current month with their position numbers
        $saturdayPositions = array();
        $saturdayCount = 0;
        
        for($d = 1; $d <= $totalDays; $d++) {
            $dow = date('w', mktime(0, 0, 0, $currentMonth, $d, $currentYear));
            if($dow == 6) { // Saturday
                $saturdayCount++;
                $saturdayPositions[$d] = $saturdayCount; // Day => Position (1st, 2nd, 3rd, etc.)
            }
        }
        
        // Debug - See all Saturdays with their positions
        // echo "<pre>Saturday Positions: "; print_r($saturdayPositions); echo "</pre>";
        ?>
        
        <!-- Month Navigation -->
        <div class="row" style="margin-bottom: 20px;">
            <div class="col-sm-2">
                <button type="button" id="prevMonthBtn" class="btn btn-sm btn-outline-primary">
                    &larr; Previous
                </button>
            </div>
            <div class="col-sm-2">
                <select id="cal_month" class="form-control form-control-sm">
                    <?php for($m=1; $m<=12; $m++): 
                        $mName = date('F', mktime(0,0,0,$m,10,$currentYear));
                    ?>
                    <option value="<?=$m?>" <?=($currentMonth == $m ? 'selected' : '')?>><?=$mName?></option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-sm-2">
                <select id="cal_year" class="form-control form-control-sm">
                    <?php for($y=2025; $y<=2030; $y++): ?>
                    <option value="<?=$y?>" <?=($currentYear == $y ? 'selected' : '')?>><?=$y?></option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-sm-2">
                <button type="button" id="nextMonthBtn" class="btn btn-sm btn-outline-primary">
                    Next &rarr;
                </button>
            </div>
            <div class="col-sm-4 text-right">
                <h4 id="currentMonthDisplay"><?=$monthName?> <?=$currentYear?></h4>
            </div>
        </div>
        
        <!-- Calendar Container -->
        <div id="calendarContainer">
            <!-- Calendar Grid -->
            <div class="calendar-container" style="margin-top: 20px;">
                <table class="calendar-table" width="100%" cellpadding="8" cellspacing="0" style="border-collapse: collapse; border: 1px solid #ddd; table-layout: fixed;">
                    <thead>
                        <tr style="background: #f2f2f2;">
                            <th style="padding: 10px; border: 1px solid #ddd; text-align: center; width: 14.28%;">Sun</th>
                            <th style="padding: 10px; border: 1px solid #ddd; text-align: center; width: 14.28%;">Mon</th>
                            <th style="padding: 10px; border: 1px solid #ddd; text-align: center; width: 14.28%;">Tue</th>
                            <th style="padding: 10px; border: 1px solid #ddd; text-align: center; width: 14.28%;">Wed</th>
                            <th style="padding: 10px; border: 1px solid #ddd; text-align: center; width: 14.28%;">Thu</th>
                            <th style="padding: 10px; border: 1px solid #ddd; text-align: center; width: 14.28%;">Fri</th>
                            <th style="padding: 10px; border: 1px solid #ddd; text-align: center; width: 14.28%;">Sat</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $cellCount = 0;
                        
                        echo '<tr>';
                        
                        // Empty cells before first day
                        for($i = 0; $i < $startDay; $i++) {
                            echo '<td style="padding: 8px; border: 1px solid #ddd; background: #f9f9f9; vertical-align: top; height: 90px;">&nbsp;</td>';
                            $cellCount++;
                        }
                        
                        // Fill the days
                        for($day = 1; $day <= $totalDays; $day++) {
                            $currentDate = $currentYear . '-' . str_pad($currentMonth, 2, '0', STR_PAD_LEFT) . '-' . str_pad($day, 2, '0', STR_PAD_LEFT);
                            $isToday = ($currentDate == $today);
                            $isPastDate = ($currentDate < $today);
                            $isFutureDate = ($currentDate > $today);
                            
                            // Day of week
                            $dayOfWeek = date('w', mktime(0, 0, 0, $currentMonth, $day, $currentYear));
                            
                            // ========== Weekly Off Logic ==========
                            $isWeeklyOff = false;
                            $offType = '';
                            
                            // 1. Check regular weekly off (Sunday)
                            if(in_array($dayOfWeek, $weeklyOffDays)) {
                                $isWeeklyOff = true;
                                $offType = 'Weekly Off';
                            }
                            
                            // 2. Check specific Saturdays - IMPROVED LOGIC
                            if($dayOfWeek == 6) { // Saturday
                                // Get which Saturday of the month this is (1st, 2nd, 3rd, 4th, 5th)
                                $saturdayPosition = isset($saturdayPositions[$day]) ? $saturdayPositions[$day] : 0;
                                
                                // Check if this Saturday's position is in the specificSaturdays array
                                if(in_array($saturdayPosition, $specificSaturdays)) {
                                    $isWeeklyOff = true;
                                    
                                    // Get suffix for display
                                    $suffix = 'th';
                                    if($saturdayPosition == 1) $suffix = 'st';
                                    elseif($saturdayPosition == 2) $suffix = 'nd';
                                    elseif($saturdayPosition == 3) $suffix = 'rd';
                                    
                                    $offType = $saturdayPosition . $suffix . ' Saturday Off';
                                }
                            }
                            
                            // Check if it's a Holiday
                            $isHoliday = isset($holidayArray[$day]);
                            
                            // Check if it's a Leave
                            $isLeave = isset($leaveDates[$day]);
                            
                            // Check attendance
                            $hasAttendance = isset($attendanceByDate[$day]);
                            $isPresent = $hasAttendance && $attendanceByDate[$day]['present'];
                            $isIncomplete = $hasAttendance && $attendanceByDate[$day]['incomplete'] && !$isPresent;
                            
                            // Determine cell class and content
                            $cellClass = '';
                            $statusText = '';
                            
                            // TODAY highlight
                            $todayStyle = $isToday ? ' style="background: #e8f4f8; border: 2px solid #007bff;"' : '';
                            
                            // ========== Status Priority ==========
                            
                            // 1. LEAVE - Show on ALL dates when leave is approved
                            if($isLeave) {
                                $cellClass = 'leave';
                                $statusText = 'App. Leave';
                            }
                            // 2. HOLIDAY - Show on ALL dates
                            elseif($isHoliday) {
                                $cellClass = 'holiday';
                                $statusText = $holidayArray[$day];
                            }
                            // 3. WEEKLY OFF - Show on ALL dates
                            elseif($isWeeklyOff) {
                                $cellClass = 'weekly-off';
                                $statusText = $offType ?: 'Weekly Off';
                            }
                            // 4. ATTENDANCE - Only for past/present dates
                            elseif($isPresent && !$isFutureDate) {
                                $cellClass = 'present';
                                $statusText = '✓ Present';
                            }
                            elseif($isIncomplete && !$isFutureDate) {
                                $cellClass = 'incomplete';
                                $statusText = 'Incomplete';
                            }
                            // 5. ABSENT - Only for past dates with no attendance, no leave, no holiday, no weekly off
                            elseif($isPastDate && !$isHoliday && !$isWeeklyOff && !$isLeave) {
                                $cellClass = 'absent';
                                $statusText = 'Absent';
                            }
                            // 6. FUTURE DATES - No status
                            else {
                                $cellClass = 'future';
                                $statusText = '';
                            }
                            
                            echo '<td style="padding: 8px; border: 1px solid #ddd; vertical-align: top; height: 90px;" class="' . $cellClass . '"' . $todayStyle . '>';
                            echo '<div style="font-weight: bold; margin-bottom: 5px; font-size: 16px;">' . $day . '</div>';
                            
                            if(!empty($statusText)) {
                                $bgColor = '#f8f9fa';
                                $textColor = '#333';
                                
                                if($cellClass == 'weekly-off') {
                                    $bgColor = '#e9ecef';
                                } elseif($cellClass == 'holiday') {
                                    $bgColor = '#ffc107';
                                    $textColor = '#000';
                                } elseif($cellClass == 'present') {
                                    $bgColor = '#d4edda';
                                    $textColor = '#155724';
                                } elseif($cellClass == 'absent') {
                                    $bgColor = '#f8d7da';
                                    $textColor = '#721c24';
                                } elseif($cellClass == 'incomplete') {
                                    $bgColor = '#fff3cd';
                                    $textColor = '#856404';
                                } elseif($cellClass == 'leave') {
                                    $bgColor = '#cce5ff';
                                    $textColor = '#004085';
                                }
                                
                                echo '<div style="font-size: 10px; background: ' . $bgColor . '; color: ' . $textColor . '; padding: 3px 5px; border-radius: 3px; margin-top: 5px;">' . $statusText . '</div>';
                            }
                            
                            echo '</td>';
                            
                            $cellCount++;
                            
                            // Start new row after Saturday
                            if($cellCount % 7 == 0 && $day < $totalDays) {
                                echo '</tr><tr>';
                            }
                        }
                        
                        // Empty cells after last day
                        while($cellCount % 7 != 0) {
                            echo '<td style="padding: 8px; border: 1px solid #ddd; background: #f9f9f9;">&nbsp;</td>';
                            $cellCount++;
                        }
                        
                        echo '</tr>';
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Legend -->
        <div class="row mt-3">
            <div class="col-sm-12">
                <div style="display: flex; gap: 15px; flex-wrap: wrap; padding: 10px; background: #f8f9fa; border-radius: 5px; margin-top: 15px;">
                    <div><span style="display: inline-block; width: 16px; height: 16px; background: #d4edda; border-radius: 3px;"></span> Present</div>
                    <div><span style="display: inline-block; width: 16px; height: 16px; background: #f8d7da; border-radius: 3px;"></span> Absent</div>
                    <div><span style="display: inline-block; width: 16px; height: 16px; background: #fff3cd; border-radius: 3px;"></span> Incomplete</div>
                    <div><span style="display: inline-block; width: 16px; height: 16px; background: #cce5ff; border-radius: 3px;"></span> Leave</div>
                    <div><span style="display: inline-block; width: 16px; height: 16px; background: #ffc107; border-radius: 3px;"></span> Holiday</div>
                    <div><span style="display: inline-block; width: 16px; height: 16px; background: #e9ecef; border-radius: 3px;"></span> Weekly Off</div>
                    <div><span style="display: inline-block; width: 16px; height: 16px; background: #e8f4f8; border-radius: 3px; border: 2px solid #007bff;"></span> Today</div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.calendar-table {
    width: 100%;
    border-collapse: collapse;
}

.calendar-table td {
    transition: all 0.2s;
    cursor: pointer;
    vertical-align: top;
}

.calendar-table td:hover {
    background: #f0f0f0 !important;
}
</style>

<!-- AJAX Script -->
<script>
$(document).ready(function() {
    function loadCalendar(month, year) {
        $.ajax({
            url: window.location.href,
            type: 'POST',
            data: {
                cal_month: month,
                cal_year: year
            },
            success: function(response) {
                var tempDiv = $('<div>').html(response);
                var newCalendar = tempDiv.find('#calendarContainer').html();
                var newMonthDisplay = tempDiv.find('#currentMonthDisplay').text();
                var newMonthSelect = tempDiv.find('#cal_month').html();
                var newYearSelect = tempDiv.find('#cal_year').html();
                
                $('#calendarContainer').html(newCalendar);
                $('#currentMonthDisplay').text(newMonthDisplay);
                $('#cal_month').html(newMonthSelect);
                $('#cal_year').html(newYearSelect);
            },
            error: function() {
                location.reload();
            }
        });
    }
    
    $('#prevMonthBtn').on('click', function() {
        var currentMonth = $('#cal_month').val();
        var currentYear = $('#cal_year').val();
        
        var prevMonth = currentMonth == 1 ? 12 : parseInt(currentMonth) - 1;
        var prevYear = currentMonth == 1 ? parseInt(currentYear) - 1 : parseInt(currentYear);
        
        loadCalendar(prevMonth, prevYear);
    });
    
    $('#nextMonthBtn').on('click', function() {
        var currentMonth = $('#cal_month').val();
        var currentYear = $('#cal_year').val();
        
        var nextMonth = currentMonth == 12 ? 1 : parseInt(currentMonth) + 1;
        var nextYear = currentMonth == 12 ? parseInt(currentYear) + 1 : parseInt(currentYear);
        
        loadCalendar(nextMonth, nextYear);
    });
    
    $('#cal_month, #cal_year').on('change', function() {
        var month = $('#cal_month').val();
        var year = $('#cal_year').val();
        loadCalendar(month, year);
    });
});
</script>