<?php 
include 'header.php';
include 'mid.php';
?>	


<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Attendance Tracker</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
    <div class="container-fluid">        
        <div class="card p-2">
            <em style="color:#999">Track your daily attendance and working hours</em><br />
            
            <?php include 'att_year_month.php';?>
        </div>        
    </div>
</section>

<section class="content">
    <div class="container-fluid">        
        <div class="card p-2">
            <div class="table-responsive" id="attendanceTable">
                <?php
                // Fetch attendance data
                $table_name = DB."attendance";
                $where = "emp_id = :emp_id AND att_month = :month AND att_year = :year ORDER BY att_check_in_date DESC, att_check_in_time ASC";
                $bind = array(
                    ":emp_id" => $_SESSION['idEMP'],
                    ":month" => $monthNumber,
                    ":year" => $selYear
                );
                
                $attendanceData = $objDatabaseModel->select($table_name, $where, $bind, "*");
                
                // Group by date
                $groupedData = array();
                foreach($attendanceData as $row) {
                    $date = $row['att_check_in_date'];
                    $groupedData[$date][] = $row;
                }
                ?>
                
                <table width="100%" border="1" cellpadding="8" cellspacing="0" style="border-collapse: collapse; border: 1px solid #ddd;">
                    <thead style="background: #f2f2f2;">
                        <tr>
                            <th style="padding: 12px; text-align: left; border: 1px solid #ddd;">Attendance Date</th>
                            <th style="padding: 12px; text-align: left; border: 1px solid #ddd;">Log In</th>
                            <th style="padding: 12px; text-align: left; border: 1px solid #ddd;">Log Out</th>
                            <th style="padding: 12px; text-align: left; border: 1px solid #ddd;">Working Hours</th>
                            <th style="padding: 12px; text-align: left; border: 1px solid #ddd;">Log In Location</th>
                            <th style="padding: 12px; text-align: left; border: 1px solid #ddd;">Log Out Location</th>
                            <th style="padding: 12px; text-align: left; border: 1px solid #ddd;">Log Out Type</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(empty($groupedData)): ?>
                        <tr>
                            <td colspan="7" style="padding: 20px; text-align: center; color: #999;">
                                No attendance records found for <?=ucfirst($selMonth)?> <?=$selYear?>
                            </td>
                        </tr>
                        <?php else: ?>
                            <?php 
                            $grandTotalSeconds = 0;
                            foreach($groupedData as $date => $dayRecords): 
                                $dateObj = DateTime::createFromFormat('Y-m-d', $date);
                                $displayDate = $dateObj->format('d M Y (l)');
                                $rowCount = count($dayRecords);
                                $dailyTotalSeconds = 0;
                                $breakSeconds = 0;
                            ?>
                            <!-- Date Row - Shows only once for multiple entries -->
                            <tr style="background: #e8f4f8;">
                                <td style="padding: 10px; border: 1px solid #ddd; font-weight: bold; vertical-align: top;" rowspan="<?=$rowCount?>">
                                    <?=$displayDate?><br>
                                    <small style="color: #666;">Total Entries: <?=$rowCount?></small>
                                </td>
                                
                                <?php 
                                $firstRecord = true;
                                foreach($dayRecords as $index => $record): 
                                    
                                    // ========== FIXED: Working hours calculation with NULL check ==========
                                    if(!empty($record['att_check_out_time']) && $record['att_check_out_time'] != '00:00:00') {
                                        $checkIn = strtotime($record['att_check_in_date'] . ' ' . $record['att_check_in_time']);
                                        $checkOut = strtotime($record['att_check_out_date'] . ' ' . $record['att_check_out_time']);
                                        $sessionSeconds = $checkOut - $checkIn;
                                        if($sessionSeconds < 0) $sessionSeconds = 0; // Negative time ko zero karo
                                    } else {
                                        $sessionSeconds = 0; // Agar check-out nahi hua to 0
                                    }
                                    
                                    $dailyTotalSeconds += $sessionSeconds;
                                    
                                    // Calculate break (time between previous check-out and current check-in)
                                    if($index > 0 && !empty($dayRecords[$index-1]['att_check_out_time'])) {
                                        $prevCheckOut = strtotime($dayRecords[$index-1]['att_check_out_date'] . ' ' . $dayRecords[$index-1]['att_check_out_time']);
                                        $currentCheckIn = strtotime($record['att_check_in_date'] . ' ' . $record['att_check_in_time']);
                                        if($currentCheckIn > $prevCheckOut) {
                                            $breakSeconds += ($currentCheckIn - $prevCheckOut);
                                        }
                                    }
                                    
                                    // Format working hours
                                    if($sessionSeconds > 0) {
                                        $hours = floor($sessionSeconds / 3600);
                                        $minutes = floor(($sessionSeconds % 3600) / 60);
                                        $workingTime = sprintf("%02d:%02d", $hours, $minutes);
                                    } else {
                                        $workingTime = '--:--';
                                    }
                                    
                                    if(!$firstRecord): ?>
                                    <tr>
                                <?php endif; ?>
                                
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <?=date('H:i', strtotime($record['att_check_in_time']))?>
                                </td>
                                
                                <!-- ========== FIXED: Check Out Time Display ========== -->
                                <td style="padding: 10px; border: 1px solid #ddd;">                                    
                                    <?php 
                                    if(!empty($record['att_check_out_time']) && $record['att_check_out_time'] != '00:00:00') {
                                        // FIXED: Echo karna bhool rahe the
                                        echo date('H:i', strtotime($record['att_check_out_time']));
                                    } else {
                                        echo '<span style="color: #999; font-style: italic;">Not checked out</span>';
                                    }
                                    ?>
                                </td>
                                
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <?=$workingTime?> hrs
                                </td>
                                
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <?php 
                                    $city = $record['check_in_city'] ?? 'Unknown';
                                    $region = $record['check_in_region'] ?? '';
                                    $location = $city . ($region ? ', ' . $region : '');
                                    
                                    if($record['check_in_latitude'] != 0 && $record['check_in_longitude'] != 0):
                                    ?>
                                    <a href="https://www.google.com/maps?q=<?=$record['check_in_latitude']?>,<?=$record['check_in_longitude']?>" 
                                       target="_blank" 
                                       class="map-link" 
                                       style="color: #007bff; text-decoration: none;"
                                       title="Click to view on Google Maps">
                                        📍 <?=$location?>
                                    </a>
                                    <?php else: ?>
                                        <span style="color: #999;">Location not available</span>
                                    <?php endif; ?>
                                </td>
                                
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <?php 
                                    if(!empty($record['att_check_out_time']) && $record['check_out_latitude'] != 0 && $record['check_out_longitude'] != 0):
                                        $outCity = $record['check_out_city'] ?? 'Unknown';
                                        $outRegion = $record['check_out_region'] ?? '';
                                        $outLocation = $outCity . ($outRegion ? ', ' . $outRegion : '');
                                    ?>
                                    <a href="https://www.google.com/maps?q=<?=$record['check_out_latitude']?>,<?=$record['check_out_longitude']?>" 
                                       target="_blank" 
                                       class="map-link"
                                       style="color: #007bff; text-decoration: none;"
                                       title="Click to view on Google Maps">
                                        📍 <?=$outLocation?>
                                    </a>
                                    <?php else: ?>
                                        <span style="color: #999;">Not available</span>
                                    <?php endif; ?>
                                </td>
                                
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <?php 
                                    if(!empty($record['att_check_out_time'])) {
                                        $checkOutType = $record['check_out_type'] ?? 'Manual Check Out';
                                        if($checkOutType == 'Scheduler Check Out') {
                                            echo '<span style="background: #ffc107; padding: 3px 8px; border-radius: 12px; font-size: 11px;">⏰ Auto</span>';
                                        } else {
                                            echo '<span style="background: #28a745; color: white; padding: 3px 8px; border-radius: 12px; font-size: 11px;">✓ Manual</span>';
                                        }
                                    } else {
                                        echo '<span style="color: #999;">Pending</span>';
                                    }
                                    ?>
                                </td>
                                
                                <?php 
                                $firstRecord = false;
                                endforeach; 
                                
                                // Calculate daily total hours
                                if($dailyTotalSeconds > 0) {
                                    $totalHours = floor($dailyTotalSeconds / 3600);
                                    $totalMinutes = floor(($dailyTotalSeconds % 3600) / 60);
                                    $totalFormatted = sprintf("%02d:%02d", $totalHours, $totalMinutes);
                                } else {
                                    $totalFormatted = '00:00';
                                }
                                
                                // Calculate break hours
                                if($breakSeconds > 0) {
                                    $breakHours = floor($breakSeconds / 3600);
                                    $breakMinutes = floor(($breakSeconds % 3600) / 60);
                                    $breakFormatted = sprintf("%02d:%02d", $breakHours, $breakMinutes);
                                } else {
                                    $breakFormatted = '00:00';
                                }
                                
                                $grandTotalSeconds += $dailyTotalSeconds;
                                ?>
                                </tr>
                                
                                <!-- Daily Summary Row -->
                                <tr style="background: #f9f9f9;">
                                    <td colspan="7" style="padding: 8px; border: 1px solid #ddd; text-align: right;">
                                        <strong>Daily Total:</strong> <?=$totalFormatted?> hrs 
                                        <?php if($breakSeconds > 0): ?>
                                            | <strong>Break:</strong> <?=$breakFormatted?> hrs
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            
                            <!-- Grand Total Row -->
                            <?php 
                            if($grandTotalSeconds > 0) {
                                $grandHours = floor($grandTotalSeconds / 3600);
                                $grandMinutes = floor(($grandTotalSeconds % 3600) / 60);
                                $grandFormatted = sprintf("%02d:%02d", $grandHours, $grandMinutes);
                            } else {
                                $grandFormatted = '00:00';
                            }
                            ?>
                            <tr style="background: #d4edda; font-weight: bold;">
                                <td colspan="7" style="padding: 12px; border: 1px solid #ddd; text-align: right;">
                                    🏆 <strong>Total Working Hours for <?=ucfirst($selMonth)?> <?=$selYear?>:</strong> <?=$grandFormatted?> hrs
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>        
    </div>
</section>

<!-- AJAX Script for dynamic loading -->
<script>
$(document).ready(function() {
    $('#ymFRM').on('submit', function(e) {
        e.preventDefault(); // Prevent normal form submission
        
        // Show loader
        $('#submitBtn').hide();
        $('#loader').show();
        
        // Get form data
        var formData = $(this).serialize();
        
        // Make AJAX request
        $.ajax({
            url: window.location.href,
            type: 'POST',
            data: formData,
            success: function(response) {
                // Extract only the table content from response
                var tempDiv = $('<div>').html(response);
                var newTable = tempDiv.find('#attendanceTable').html();
                
                // Update table content
                $('#attendanceTable').html(newTable);
                
                // Hide loader, show button
                $('#loader').hide();
                $('#submitBtn').show();
            },
            error: function() {
                alert('Error loading data. Please try again.');
                $('#loader').hide();
                $('#submitBtn').show();
            }
        });
    });
    
    // Auto-submit when month or year changes (optional)
    $('#mName, #yName').on('change', function() {
        if($('#mName').val() && $('#yName').val()) {
            $('#ymFRM').submit();
        }
    });
});
</script>

    
    
    
  </div>

<?php
include 'footer.php';
?>