<!-- Button - यह सही है -->
<button class="btn btn-primary" onclick="checkLocationAndMark()">
    📝 Click My Attendance
</button>

<!-- Result Container - यह होना चाहिए -->
<div id="result" class="result-card" style="display: none;">
    <div id="resultContent"></div>
</div>

<script>
// नया फंक्शन - पहले location check करेगा
function checkLocationAndMark() {
    const resultDiv = document.getElementById('result');
    const resultContent = document.getElementById('resultContent');
    
    if (!resultDiv || !resultContent) {
        alert('Error: Result container not found');
        return;
    }
    
    resultDiv.style.display = 'block';
    
    // Check if geolocation is supported
    if (!navigator.geolocation) {
        resultContent.innerHTML = `
            <div class="error-message">
                ❌ Your browser does not support location services
            </div>
        `;
        return;
    }
    
    // Show checking message
    resultContent.innerHTML = `
        <div class="loading">
            <div class="spinner"></div>
            <h3>🔍 Checking location access...</h3>
            <p>Please wait...</p>
        </div>
    `;
    
    // Get location directly
    navigator.geolocation.getCurrentPosition(
        // Success
        function(position) {
            markAttendance(position);
        },
        // Error
        function(error) {
            let message = '';
            
            switch(error.code) {
                case error.PERMISSION_DENIED:
                    message = `
                        <div class="error-message">
                            ❌ Location permission denied
                            <br><br>
                            <div style="background: #f8d7da; color: #721c24; padding: 20px; border-radius: 8px; text-align: left;">
                                <strong>📍 Location अनब्लॉक कैसे करें:</strong>
                                <br><br>
                                
                                <div style="margin-bottom: 15px;">
                                    <strong>🔴 Chrome में:</strong><br>
                                    1. Address bar के दाईं ओर 🔒 लॉक icon पर क्लिक करें<br>
                                    2. "Site settings" पर क्लिक करें<br>
                                    3. "Location" को "Allow" करें<br>
                                    4. पेज refresh करें
                                </div>
                                
                                <div style="margin-bottom: 15px;">
                                    <strong>🔴 Firefox में:</strong><br>
                                    1. Address bar में ℹ️ info icon पर क्लिक करें<br>
                                    2. "Clear permissions" पर क्लिक करें<br>
                                    3. पेज refresh करें
                                </div>
                                
                                <div>
                                    <strong>🔴 Edge में:</strong><br>
                                    1. Address bar में 🔒 लॉक icon पर क्लिक करें<br>
                                    2. "Permissions" पर क्लिक करें<br>
                                    3. "Location" को "Allow" करें<br>
                                    4. पेज refresh करें
                                </div>
                                
                                <br>
                                <strong>⚠️ Settings बदलने के बाद पेज refresh करें</strong>
                            </div>
                            <br>
                            <button onclick="refreshPage()" class="btn-map" style="background: #4CAF50; padding: 12px 25px;">
                                🔄 Refresh Page
                            </button>
                            <button onclick="checkLocationAndMark()" class="btn-map" style="background: #ff9800; margin-left: 10px; padding: 12px 25px;">
                                🔄 Try Again
                            </button>
                        </div>
                    `;
                    break;
                    
                case error.POSITION_UNAVAILABLE:
                    message = `
                        <div class="error-message">
                            ❌ Location is turned off
                            <br><br>
                            <div style="background: #fff3cd; color: #856404; padding: 20px; border-radius: 8px; text-align: left;">
                                <strong>📱 Device की location ऑन करें:</strong>
                                <br><br>
                                <strong>Windows 10/11:</strong><br>
                                Settings → Privacy & Security → Location → Turn On
                                <br><br>
                                <strong>Android:</strong><br>
                                Settings → Location → Turn On
                                <br><br>
                                <strong>iPhone:</strong><br>
                                Settings → Privacy → Location Services → Turn On
                                <br><br>
                                <strong>⚠️ Location ऑन करने के बाद Try Again करें</strong>
                            </div>
                            <br>
                            <button onclick="checkLocationAndMark()" class="btn-map" style="background: #4CAF50; padding: 12px 25px;">
                                🔄 Try Again
                            </button>
                        </div>
                    `;
                    break;
                    
                case error.TIMEOUT:
                    message = `
                        <div class="error-message">
                            ❌ Location request timeout
                            <br><br>
                            <button onclick="checkLocationAndMark()" class="btn-map" style="background: #4CAF50; padding: 12px 25px;">
                                🔄 Try Again
                            </button>
                        </div>
                    `;
                    break;
                    
                default:
                    message = `
                        <div class="error-message">
                            ❌ Unknown error
                            <br><br>
                            <button onclick="checkLocationAndMark()" class="btn-map" style="background: #4CAF50; padding: 12px 25px;">
                                🔄 Try Again
                            </button>
                        </div>
                    `;
            }
            
            resultContent.innerHTML = message;
        },
        // Options
        {
            enableHighAccuracy: true,
            timeout: 10000,
            maximumAge: 0
        }
    );
}

// Refresh page function
function refreshPage() {
    location.reload();
}

// Mark attendance function
function markAttendance(position) {
    const resultContent = document.getElementById('resultContent');
    const testIdElement = document.getElementById('testId');
    
    if (!testIdElement) {
        resultContent.innerHTML = '<div class="error-message">❌ Test ID not found</div>';
        return;
    }
    
    const testId = testIdElement.innerText;
    const lat = position.coords.latitude;
    const lng = position.coords.longitude;
    const accuracy = position.coords.accuracy;
    
    // Get current time
    const now = new Date();
    const timestamp = now.toLocaleString('en-IN', { timeZone: 'Asia/Kolkata' });
    
    // Show processing message
    resultContent.innerHTML = `
        <div class="loading">
            <div class="spinner"></div>
            <h3>Saving your attendance...</h3>
            <p>Location accuracy: ${Math.round(accuracy)} meters</p>
        </div>
    `;
    
    // Send to server
    fetch('save_attendance.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            test_id: testId,
            test_name: 'IBPS Attendance',
            latitude: lat,
            longitude: lng,
            accuracy: accuracy,
            timestamp: timestamp
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            resultContent.innerHTML = `
                <div class="success-message">✅ Attendance Marked Successfully!</div>
                <div class="detail-box">
                    <div class="detail-item">
                        <span class="label">📍 Location:</span>
                        <span class="value">${lat.toFixed(6)}, ${lng.toFixed(6)}</span>
                    </div>
                    <div class="detail-item">
                        <span class="label">🎯 Accuracy:</span>
                        <span class="value">${Math.round(accuracy)} meters</span>
                    </div>
                    <div class="detail-item">
                        <span class="label">🌆 City:</span>
                        <span class="value">${data.city || 'Detecting...'}</span>
                    </div>
                    <div class="detail-item">
                        <span class="label">⏰ Time:</span>
                        <span class="value">${timestamp}</span>
                    </div>
                </div>
                <div style="text-align: center; margin-top: 15px;">
                    <a href="https://www.google.com/maps?q=${lat},${lng}" target="_blank" class="btn-map">
                        🗺️ Open in Google Maps
                    </a>
                    <button onclick="location.reload()" class="btn-map" style="background: #4CAF50; margin-left: 10px;">
                        🔄 Refresh List
                    </button>
                </div>
            `;
        } else {
            throw new Error(data.message || 'Error saving attendance');
        }
    })
    .catch(error => {
        resultContent.innerHTML = `
            <div class="error-message">
                ❌ Error: ${error.message}
                <br><br>
                <button onclick="checkLocationAndMark()" class="btn-map" style="background: #4CAF50;">Try Again</button>
            </div>
        `;
    });
}
</script>

