<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Leave Application Template</title>

  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="../plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
  <link rel="stylesheet" href="../plugins/summernote/summernote-bs4.min.css">
  <link rel="stylesheet" href="../dist/css/adminlte.css">
  <link rel="stylesheet" href="../dist/css/style.css">
  <link rel="stylesheet" href="../dist/css/croppie.min.css" /> 
  <link href="../fdir/css/sweetalert2.min.css" rel="stylesheet" type="text/css" />

  <?php /*?><script src="../plugins/jquery/jquery.min.js"></script><?php */?>
  <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
  <script src="../fdir/js/sweetalert2.all.min.js"></script>

  <style>
    .swal2-container.swal2-backdrop-show,
    .swal2-container.swal2-noanimation {
      background-color: #c9f2e96e!important;
    }
  </style>
  <style>
  
    .card { border-radius: 12px; }
    .sunday-row { background-color: #ffecec !important; } /* 🔴 Highlight Sundays */
  </style>
</head>

<body class="bg-light py-4">
  <div class="container">
    <div class="card shadow-sm p-4">
      <h3 class="mb-3">Leave Application Template</h3>
      <p class="text-muted">Select your leave start and end date. </p>

      <form id="leaveForm">
	  <div class="row">
        <div class="col-md-6">
          <label class="form-label">Start Date <span class="text-danger">*</span></label>
          <input type="date" id="startDate" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">End Date <span class="text-danger">*</span></label>
          <input type="date" id="endDate" class="form-control" required>
        </div>
      

      
        <div class="col-md-12 mt-3" id="daysContainer"></div>

        <div class="col-md-12 mt-3">
          <label class="form-label">Leave Description <span class="text-danger">*</span></label>
          <textarea id="leaveDesc" name="leave_description" class="form-control" required></textarea>
        </div>

        <div class="text-end mt-3">
          <button type="submit" class="btn btn-success px-4">Submit Leave</button>
        </div>
      </form>

      <div id="msgBox" class="col-md-12 mt-3"></div>
    </div>
	</div>
  </div>
  
  
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- overlayScrollbars -->
<script src="../plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
<!-- AdminLTE App -->
<script src="../dist/js/adminlte.js"></script>

<!-- PAGE ../plugins -->
<!-- jQuery Mapael -->
<script src="../plugins/jquery-mousewheel/jquery.mousewheel.js"></script>
<script src="../plugins/raphael/raphael.min.js"></script>
<script src="../plugins/jquery-mapael/jquery.mapael.min.js"></script>
<script src="../plugins/jquery-mapael/maps/usa_states.min.js"></script>
<!-- ChartJS -->
<script src="../plugins/chart.js/Chart.min.js"></script>

<script src="../plugins/summernote/summernote-bs4.min.js"></script>


<!-- AdminLTE for demo purposes -->
<script src="../dist/js/demo.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="../dist/js/pages/dashboard2.js"></script> 
  
  

  <script>
  $(function () { 
    $('#leaveDesc').summernote({ height: 200, focus: true }); 
  });

  // 🟢 1. Define your holidays & off Saturdays here
  var holidays = [    
    '2025-10-02',
    '2025-10-20'
  ];

  var offSaturdays = [
    '2025-10-04',
    '2025-10-11',
    '2025-10-18'
  ];

  function getDateRange(start, end) {
    var arr = [];
    var dt = new Date(start);
    var endDate = new Date(end);
    while (dt <= endDate) {
      arr.push(new Date(dt));
      dt.setDate(dt.getDate() + 1);
    }
    return arr;
  }

  function formatDate(d) {
    var month = String(d.getMonth() + 1).padStart(2, '0');
    var day = String(d.getDate()).padStart(2, '0');
    return d.getFullYear() + '-' + month + '-' + day;
  }

  function generateLeaveDays() {
    var start = $('#startDate').val();
    var end = $('#endDate').val();
    var container = $('#daysContainer');
    container.empty();

    if (!start || !end) {
      container.html('<div class="alert alert-warning">Please select both start and end dates.</div>');
      return;
    }
    if (start > end) {
      container.html('<div class="alert alert-danger">Start date cannot be after end date.</div>');
      return;
    }

    var dates = getDateRange(start, end);
    var table = $('<table class="table table-bordered align-middle mt-3">');
    table.append('<thead class="table-light"><tr><th style="width:20%">Date</th><th style="width:20%">Day</th><th style="width:20%">Leave Type <span class="text-danger">*</span></th><th>Half Day Type</th></tr></thead>');
    var tbody = $('<tbody>');

    $.each(dates, function(i, d) {
      var dateStr = formatDate(d);
      var dayName = d.toLocaleDateString('en-IN', { weekday: 'long' });

      var isSunday = (dayName === 'Sunday');
      var isHoliday = holidays.includes(dateStr);
      var isOffSaturday = offSaturdays.includes(dateStr);

      var row = $('<tr>');
      if (isSunday || isHoliday || isOffSaturday) row.addClass('sunday-row');

      var leaveSelect = '<select class="form-select form-control leaveType" name="leaveType[' + dateStr + ']" required data-date="' + dateStr + '"';
      if (isSunday || isHoliday || isOffSaturday) leaveSelect += ' disabled';
      leaveSelect += '>';

      // 🟥 Default label for special days
      if (isSunday) {
        leaveSelect += '<option value="none" selected>No Leave (Sunday)</option>';
      } 
      else if (isHoliday) {
        leaveSelect += '<option value="none" selected>Holiday</option>';
      }
      else if (isOffSaturday) {
        leaveSelect += '<option value="none" selected>Your Off Saturday</option>';
      } 
      else {
        //##leaveSelect += '<option value="">Select</option>';
        leaveSelect += '<option value="full">Full Day</option>';
        leaveSelect += '<option value="half">Half Day</option>';
        leaveSelect += '<option value="none">No Leave</option>';
      }
      leaveSelect += '</select>';

      row.append('<td>' + dateStr + '</td>');
      row.append('<td>' + dayName + '</td>');
      row.append('<td>' + leaveSelect + '</td>');

      var halfCol = 
        '<td>' +
        '<div class="halfOptions" data-date="' + dateStr + '" style="display:none">' +
        '<div class="form-check form-check-inline">' +
        '<input class="form-check-input" type="radio" name="half[' + dateStr + ']" value="first" checked>' +
        '<label class="form-check-label">First Half</label>' +
        '</div>' +
        '<div class="form-check form-check-inline">' +
        '<input class="form-check-input" type="radio" name="half[' + dateStr + ']" value="second">' +
        '<label class="form-check-label">Second Half</label>' +
        '</div>' +
        '</div>' +
        '</td>';

      row.append(halfCol);
      tbody.append(row);
    });

    table.append(tbody);
    container.append(table);

    $('.leaveType').on('change', function() {
      var date = $(this).data('date');
      if ($(this).val() === 'half') {
        $('.halfOptions[data-date="' + date + '"]').slideDown();
      } else {
        $('.halfOptions[data-date="' + date + '"]').slideUp();
      }
    });
  }

  $('#startDate, #endDate').on('change', generateLeaveDays);

  
  
  
  
  $('#leaveForm').on('submit', function(e) {
    e.preventDefault();
	
	
	alert('sss');

    if (!$('#startDate').val() || !$('#endDate').val()) {
      $('#msgBox').html('<div class="alert alert-danger">Please select start and end date first.</div>');
      return;
    }

    var empty = false;
    $('.leaveType').each(function() {
      if (!$(this).is(':disabled') && !$(this).val()) empty = true;
    });
    if (empty) {
      $('#msgBox').html('<div class="alert alert-danger">All leave types are required!</div>');
      return;
    }

    if (!$('#leaveDesc').val().trim()) {
      $('#msgBox').html('<div class="alert alert-danger">Leave description is required!</div>');
      return;
    }

    var formData = $(this).serialize();
    $.ajax({
      url: 'submit_leave.php',
      method: 'POST',
      data: formData,
      success: function(response) {
        $('#msgBox').html('<div class="alert alert-success">Leave submitted successfully!</div>');
        console.log(response);
      },
      error: function() {
        $('#msgBox').html('<div class="alert alert-danger">Error submitting leave.</div>');
      }
    });
  });
</script>

</body>
</html>
