<style>
.session-box {
    width: 300px;
    background: #c0d0f738;
    padding: 20px;
    border-radius: 20px;
    text-align: center;
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.status-btn {
    background: #27c45a;
    color: white;
    padding: 8px 20px;
    border-radius: 20px;
    display: inline-block;
    font-weight: bold;
    margin-bottom: 15px;
}

.timer {
    font-size: 36px;
    color: #1e7f45;
    font-weight: bold;
    margin-bottom: 5px;
}

.started {
    background: #f3f3f3;
    padding: 8px;
    border-radius: 15px;
    color: #777;
    font-size: 14px;
}

.location-message {
    background: #fff3cd;
    color: #856404;
    padding: 20px;
    border-radius: 8px;
    margin-top: 15px;
    text-align: left;
    border-left: 4px solid #ffc107;
    display: none;
    max-width: 500px;
}

.location-message strong {
    display: block;
    margin-bottom: 15px;
    font-size: 18px;
    color: #333;
}

.instruction-box {
    background: white;
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 15px;
    border: 1px solid #ffe69c;
}

.instruction-box strong {
    color: #d32f2f;
    margin-bottom: 8px;
}

.instruction-box ul {
    margin: 5px 0 0 0;
    padding-left: 20px;
}

.instruction-box li {
    margin-bottom: 5px;
    color: #555;
}

.btn-map {
    background: #4CAF50;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
    text-decoration: none;
    display: inline-block;
    margin-top: 10px;
    font-weight: bold;
}

.btn-map:hover {
    background: #45a049;
}
.checkin{ width:100%;}
#btnText{ font-size:16px;}
#statusMessage{font-size:14px;}
.active-btn {
  background: linear-gradient(135deg, #34d399, #22c55e);
  color: white;
  border: none;
  padding: 10px 22px 10px 18px;
  border-radius: 30px;
  font-size: 16px;
  font-weight: 600;
  display: inline-flex;
  align-items: center;
  gap: 10px;
  box-shadow: 0 4px 10px rgba(34,197,94,0.4);
  cursor: pointer;
}

/* Solar glowing dot */
.active-btn .dot {
  width: 10px;
  height: 10px;
  background: #7CFFB2;
  border-radius: 50%;
  box-shadow: 0 0 6px #7CFFB2, 0 0 12px #7CFFB2;
  animation: pulse 1.5s infinite;
}

/* Pulse animation */
@keyframes pulse {
  0% {
    transform: scale(1);
    opacity: 1;
  }
  50% {
    transform: scale(1.5);
    opacity: 0.5;
  }
  100% {
    transform: scale(1);
    opacity: 1;
  }
}
.ready{ 
    padding:15px 5px; 
    background:#4A474714; 
    width:70%; 
    margin:0 auto; 
    border-radius:5px;
}

</style>




<!-- Update your existing HTML button section -->

<div class="row bdr">
    <!-- Session Box -->
    <div class="session-box" id="sessionBox">
        <div class="col-sm-12 mb-2">
        
          <?=$objDatabaseModel->checkEmployeeAttendance($_SESSION['idEMP'])?>
        
        
            <button class="btn btn-danger checkin" id="attendanceBtn" onclick="checkLocationAndMark()">
                <i class="fas fa-clock nav-icon"></i>&nbsp;&nbsp;
                <span id="btnText"> Log-In</span>
                <span id="btnLoader" style="display: none;"> Loading... <img src="../dist/images/lo.gif" /></span>
            </button>
            <div id="timeDisplay" style="margin-top:15px; font-size: 18px; font-weight: bold;">
            
            
            </div>
        </div>
        
        <div id="statusMessage"></div>
            
        
    </div>
    
    <!-- Location Message - Browser specific instructions -->
    <div id="locationMessage" class="location-message">
        <strong>📍 Location is required for attendance</strong>
        
        <div class="instruction-box">
            <strong>🔴 In Chrome:</strong>
            <ul>
                <li>1. Click the 🔒 lock icon in address bar</li>
                <li>2. Click "Site settings"</li>
                <li>3. Change "Location" to "Allow"</li>
                <li>4. Refresh the page</li>
            </ul>
        </div>
        
        <div class="instruction-box">
            <strong>🔴 In Firefox:</strong>
            <ul>
                <li>1. Click the ℹ️ info icon in address bar</li>
                <li>2. Click "Clear permissions"</li>
                <li>3. Refresh the page</li>
            </ul>
        </div>
        
        <div class="instruction-box">
            <strong>🔴 In Edge:</strong>
            <ul>
                <li>1. Click the 🔒 lock icon in address bar</li>
                <li>2. Click "Permissions"</li>
                <li>3. Change "Location" to "Allow"</li>
                <li>4. Refresh the page</li>
            </ul>
        </div>
        
        <div style="background: #f8d7da; padding: 10px; border-radius: 5px; margin-top: 10px;">
            <strong style="color: #721c24;">📱 Device location must be ON:</strong>
            <ul style="margin-top: 5px;">
                <li><strong>Windows:</strong> Settings → Privacy & Security → Location → On</li>
                <li><strong>Android:</strong> Settings → Location → On</li>
                <li><strong>iPhone:</strong> Settings → Privacy → Location Services → On</li>
            </ul>
        </div>
        
        <button onclick="refreshPage()" class="btn-map">🔄 Refresh Page After Enabling Location</button>
    </div>
</div>

<script>

function formatTimeToAMPM(time24) {
    // time24 format: "14:30:25" ya "14:30" ya "2:30:25"
    
    // Time ko split karo
    let [hours, minutes, seconds] = time24.split(':');
    
    // Parse hours as number
    hours = parseInt(hours);
    
    // AM/PM decide karo
    const ampm = hours >= 12 ? 'PM' : 'AM';
    
    // 12-hour format mein convert karo
    hours = hours % 12;
    hours = hours ? hours : 12; // 0 hour ko 12 banana (12 AM)
    
    // Minutes ko 2-digit mein rakho
    minutes = minutes.padStart(2, '0');
    
    // Agar seconds hain to include karo
    if (seconds) {
        seconds = seconds.padStart(2, '0');
        return `${hours}:${minutes}:${seconds} ${ampm}`;
    }
    
    return `${hours}:${minutes} ${ampm}`;
}



// Global variable for timer interval
let timerInterval = null;

// Check login status on page load
document.addEventListener('DOMContentLoaded', function() {
    // Pehle session box show karo, location check baad mein
    const sessionBox = document.getElementById('sessionBox');
    const locationMessage = document.getElementById('locationMessage');
    
    sessionBox.style.display = 'block';
    locationMessage.style.display = 'none';
    
    // Ab attendance status check karo
    checkAttendanceStatus();
    
    // Location check alag se - bina session box hide kiye
    checkLocationSilently();
});

// Check current attendance status
function checkAttendanceStatus() {
    const emp_id = '<?=$_SESSION['idEMP']?>';
    
    fetch('save_attendance.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            emp_id: emp_id,
            action: 'check_status'
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            if (data.status === 'checked_in') {
                document.getElementById('btnText').textContent = 'Log-Out';
                document.getElementById('statusMessage').innerHTML = 
                    'Log-In Time: ' + formatTimeToAMPM(data.check_in_time);
                
                // Database se mila check-in time - timer start karo
                startTimer(data.check_in_time);
            } else {
                document.getElementById('btnText').textContent = 'Log-In';
                document.getElementById('statusMessage').innerHTML = '<div class="ready"><h5>Ready to start</h5><strong>your workday</strong><div>';
                document.getElementById('timeDisplay').innerHTML = '';
                
                // Stop timer if running
                stopTimer();
            }
        }
    })
    .catch(error => console.log('Status check error:', error));
}

// Start timer function - Database time se
// Start timer function - Database time se
function startTimer(checkInTime) {
    // Stop any existing timer
    stopTimer();
    
    // Parse check-in time from database (format: HH:MM:SS)
    const timeParts = checkInTime.split(':');
    const checkInDate = new Date();
    
    // Today's date with check-in time from database
    checkInDate.setHours(parseInt(timeParts[0]), parseInt(timeParts[1]), parseInt(timeParts[2]), 0);
    
    // Agar check-in time aj ka hai to theek hai, nahi to kal ka time consider karo
    const now = new Date();
    if (checkInDate > now) {
        // Agar time aaj se bada hai (like 23:59:59), to kal ka date set karo
        checkInDate.setDate(checkInDate.getDate() - 1);
    }
    
    // Clear timeDisplay first to remove any existing content
    document.getElementById('timeDisplay').innerHTML = '';
    
    // Update timer every second
    timerInterval = setInterval(function() {
        const now = new Date();
        const diffMs = now - checkInDate; // Difference in milliseconds
        
        // Calculate hours, minutes, seconds
        const diffHrs = Math.floor(diffMs / 3600000);
        const diffMins = Math.floor((diffMs % 3600000) / 60000);
        const diffSecs = Math.floor((diffMs % 60000) / 1000);
        
        // Format time with leading zeros
        const hours = diffHrs.toString().padStart(2, '0');
        const minutes = diffMins.toString().padStart(2, '0');
        const seconds = diffSecs.toString().padStart(2, '0');
        
        // Display timer with Active Session button
        document.getElementById('timeDisplay').innerHTML = 
            '<button class="active-btn mb-3"><span class="dot"></span>Active Session</button><p style="color: #1e7f45;">⏱️ Session Duration: ' + hours + ':' + minutes + ':' + seconds + '</p>';
    }, 1000);
}

// Stop timer function - FIXED: Properly clears everything
function stopTimer() {
    if (timerInterval) {
        clearInterval(timerInterval);
        timerInterval = null;
    }
    // FIXED: Clear the timeDisplay completely
    document.getElementById('timeDisplay').innerHTML = '';
}

// Mark attendance function - UPDATED
function markAttendance(position) {
    const emp_id = '<?=$_SESSION['idEMP']?>';
    const emp_name = '<?=$_SESSION['nameEMP']?>';
    const lat = position.coords.latitude;
    const lng = position.coords.longitude;
    const accuracy = position.coords.accuracy;
    
    // Get current button text to determine action
    const btnText = document.getElementById('btnText').textContent.trim();
    const action = btnText === 'Log-In' ? 'check_in' : 'check_out';
    
    fetch('save_attendance.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            emp_id: emp_id,
            emp_name: emp_name,
            latitude: lat,
            longitude: lng,
            accuracy: accuracy,
            action: action
        })
    })
    .then(response => response.json())
    .then(data => {
        // Hide loader
        document.getElementById('attendanceBtn').disabled = false;
        document.getElementById('btnText').style.display = 'inline';
        document.getElementById('btnLoader').style.display = 'none';
        
        if (data.success) {
            let successMsg = '✅ ' + data.message;
            
            if (data.remaining !== undefined) {
                if (data.action === 'checked_in') {
                    successMsg += `\n\nRemaining Log-In today: ${data.remaining}`;
                } else if (data.action === 'checked_out') {
                    successMsg += `\n\nYou have ${data.remaining} Log-In(s) left today.`;
                }
            }
            
            if (data.action === 'checked_out' && data.working_hours) {
                successMsg += `\nWorking hours: ${data.working_hours} hours`;
            }
            
            alert(successMsg);
            
            if (data.action === 'checked_in') {
                document.getElementById('btnText').textContent = 'Log-Out';
                document.getElementById('statusMessage').innerHTML = 
                    'Log-In Time: ' + formatTimeToAMPM(data.check_in_time);
                
                // Database se mila check-in time - timer start karo
                startTimer(data.check_in_time);
            } else {
                document.getElementById('btnText').textContent = 'Log-In';
                document.getElementById('statusMessage').innerHTML = 
                    '<div class="ready"><h5>Ready to start</h5><strong>your workday</strong></div>';
                
                // FIXED: Clear timeDisplay first
                document.getElementById('timeDisplay').innerHTML = '';
                
                // Stop timer
                stopTimer();
            }
        } else {
            alert('❌ ' + data.message);
            if (data.action === 'check_out_needed') {
                document.getElementById('btnText').textContent = 'Log-Out';
            }
        }
    })
    .catch(error => {
        document.getElementById('attendanceBtn').disabled = false;
        document.getElementById('btnText').style.display = 'inline';
        document.getElementById('btnLoader').style.display = 'none';
        alert('Error: ' + error.message);
    });
}

// Stop timer function
function stopTimer() {
    if (timerInterval) {
        clearInterval(timerInterval);
        timerInterval = null;
    }
    // FIXED: Clear the timeDisplay completely
    document.getElementById('timeDisplay').innerHTML = '';
}
// NEW: Silently check location without hiding session box
function checkLocationSilently() {
    if (!navigator.geolocation) {
        return;
    }
    
    // Just check permission, don't get position yet
    if (navigator.permissions && navigator.permissions.query) {
        navigator.permissions.query({ name: 'geolocation' }).then(function(permissionStatus) {
            if (permissionStatus.state === 'denied') {
                // Permission denied, show message
                document.getElementById('sessionBox').style.display = 'none';
                document.getElementById('locationMessage').style.display = 'block';
            }
        }).catch(function() {
            // Permissions API not supported, ignore
        });
    }
}

// FIXED: Check and mark attendance with better timeout handling
function checkLocationAndMark() {
    const locationMessage = document.getElementById('locationMessage');
    const btn = document.getElementById('attendanceBtn');
    const btnText = document.getElementById('btnText');
    const btnLoader = document.getElementById('btnLoader');
    
    if (!navigator.geolocation) {
        alert('Your browser does not support location services');
        return;
    }
    
    // Check if HTTPS (warning but don't block)
    if (window.location.protocol !== 'https:' && 
        window.location.hostname !== 'localhost' && 
        !window.location.hostname.includes('127.0.0.1') &&
        !window.location.hostname.includes('test')) {
        
        if (!confirm('⚠️ Your connection is not HTTPS. Location may not work. Try anyway?')) {
            return;
        }
    }
    
    // Show loading
    btn.disabled = true;
    btnText.style.display = 'none';
    btnLoader.style.display = 'inline';
    locationMessage.style.display = 'none';
    
    // Try with both high accuracy and low accuracy options
    tryLocationWithFallback(btn, btnText, btnLoader, locationMessage);
}

// NEW: Try location with multiple attempts and fallback
function tryLocationWithFallback(btn, btnText, btnLoader, locationMessage, attempt = 1) {
    const options = {
        enableHighAccuracy: attempt === 1 ? true : false, // First attempt high accuracy, then low
        timeout: attempt === 1 ? 8000 : 5000, // First attempt 8 sec, then 5 sec
        maximumAge: 0
    };
    
    console.log(`Location attempt ${attempt} with highAccuracy: ${options.enableHighAccuracy}`);
    
    navigator.geolocation.getCurrentPosition(
        function(position) {
            // Success - location mil gaya
            console.log(`Location success on attempt ${attempt}`);
            markAttendance(position);
        },
        function(error) {
            console.log(`Attempt ${attempt} failed:`, error.code, error.message);
            
            if (attempt < 3) {
                // Try next attempt with different settings
                setTimeout(() => {
                    tryLocationWithFallback(btn, btnText, btnLoader, locationMessage, attempt + 1);
                }, 1000);
            } else {
                // All attempts failed
                btn.disabled = false;
                btnText.style.display = 'inline';
                btnLoader.style.display = 'none';
                
                let errorMsg = '⚠️ Could not get your location.\n\n';
                
                if (error.code === 1) {
                    errorMsg += 'Please allow location access:\n';
                    errorMsg += '1. Click 🔒 icon in address bar\n';
                    errorMsg += '2. Set Location to "Allow"\n';
                    errorMsg += '3. Refresh page';
                    locationMessage.style.display = 'block';
                } else if (error.code === 2) {
                    errorMsg += 'Location unavailable. Please:\n';
                    errorMsg += '1. Turn ON device location\n';
                    errorMsg += '2. Enable WiFi/GPS\n';
                    errorMsg += '3. Try again';
                } else if (error.code === 3) {
                    errorMsg += 'Location request timeout.\n';
                    errorMsg += 'Please try these fixes:\n';
                    errorMsg += '1. Move to open area\n';
                    errorMsg += '2. Turn WiFi ON (helps GPS)\n';
                    errorMsg += '3. Disable any VPN\n';
                    errorMsg += '4. Try again';
                    
                    // Firefox specific
                    if (navigator.userAgent.indexOf('Firefox') !== -1) {
                        errorMsg += '\n\nFirefox users: about:config → geo.enabled = true';
                    }
                } else {
                    errorMsg += 'Unknown error. Please refresh and try again.';
                }
                
                alert(errorMsg);
            }
        },
        options
    );
}

// FIXED: Use IP-based location as last resort
function getLocationByIP() {
    return fetch('https://ipapi.co/json/')
        .then(response => response.json())
        .then(data => {
            return {
                coords: {
                    latitude: data.latitude,
                    longitude: data.longitude,
                    accuracy: 5000 // Low accuracy
                }
            };
        });
}

// Mark attendance function
// Mark attendance function - 


// Refresh page function
function refreshPage() {     
	 window.location.reload(true);
}

// Debug function - browser console mein run karein
function debugLocation() {
    console.log('=== Location Debug Info ===');
    console.log('Protocol:', window.location.protocol);
    console.log('Hostname:', window.location.hostname);
    console.log('Geolocation available:', !!navigator.geolocation);
    
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            function(pos) {
                console.log('✅ Location success:', pos.coords);
            },
            function(err) {
                console.log('❌ Location error:', err.code, err.message);
                
                if (err.code === 1) console.log('Permission denied - allow location');
                if (err.code === 2) console.log('Position unavailable - turn on GPS');
                if (err.code === 3) console.log('Timeout - try with better signal');
            },
            { timeout: 10000 }
        );
    }
}
</script>

<!-- Add debug button temporarily -->
<button onclick="debugLocation()" style="display:none;">Debug Location</button>









<?php /*?><script>
// Check location on page load
function checkLocationOnLoad() {
    const sessionBox = document.getElementById('sessionBox');
    const locationMessage = document.getElementById('locationMessage');
    
    if (!navigator.geolocation) {
        sessionBox.style.display = 'none';
        locationMessage.style.display = 'block';
        return;
    }
    
    // Check if location is enabled
    navigator.geolocation.getCurrentPosition(
        function(position) {
            // Location is on - show session box
            sessionBox.style.display = 'block';
            locationMessage.style.display = 'none';
        },
        function(error) {
            // Location is off - hide session box, show message
            sessionBox.style.display = 'none';
            locationMessage.style.display = 'block';
        },
        {
            timeout: 5000,
            maximumAge: 0
        }
    );
}

// Check and mark attendance
function checkLocationAndMark() {
    const locationMessage = document.getElementById('locationMessage');
    
    if (!navigator.geolocation) {
        alert('Your browser does not support location services');
        return;
    }
    
    navigator.geolocation.getCurrentPosition(
        function(position) {
            // Location is on - proceed with attendance
            markAttendance(position);
            locationMessage.style.display = 'none';
        },
        function(error) {
            // Location is off - show message
            locationMessage.style.display = 'block';
        },
        {
            enableHighAccuracy: true,
            timeout: 10000,
            maximumAge: 0
        }
    );
}

// Mark attendance function
function markAttendance(position) {
    const testIdElement = document.getElementById('testId');
    
    if (!testIdElement) {
        alert('Test ID not found');
        return;
    }
    
    const testId = testIdElement.innerText;
    const lat = position.coords.latitude;
    const lng = position.coords.longitude;
    const accuracy = position.coords.accuracy;
    
    // Get current time
    const now = new Date();
    const timestamp = now.toLocaleString('en-IN', { timeZone: 'Asia/Kolkata' });
    
    // Send to server
    fetch('save_attendance.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            test_id: <?=$_SESSION['idEMP']?>,
            test_name: '<?=$_SESSION['nameEMP']?>',
            latitude: lat,
            longitude: lng,
            accuracy: accuracy,
            timestamp: timestamp
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('✅ Attendance Marked Successfully!');
            location.reload();
        } else {
            throw new Error(data.message || 'Error saving attendance');
        }
    })
    .catch(error => {
        alert('Error: ' + error.message);
    });
}

// Refresh page function
function refreshPage() {
        window.location.href = '<?=SITE_WS_PATH?>/em/dashboard';
}

// Check location when page loads
document.addEventListener('DOMContentLoaded', function() {
    checkLocationOnLoad();
});
</script><?php */?>

