<?php 
include 'header.php';
include 'mid.php';
?>	

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Monthly Attendance List</h1>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
    <div class="container-fluid">        
        <div class="card p-3">
            <div class="row">
            
            <div class="col-sm-12 mb-4"><?php include 'att_year_month.php';?></div>
            
                <div class="col-md-12">
                    <?php
                    // Get current month and year
                    $currentMonth = date('F');
                    $currentYear = date('Y');
                    
                    // Get selected values
                    $selMonth = $_POST['mName'] ?? strtolower($currentMonth);
                    $selYear = $_POST['yName'] ?? $currentYear;
                    
                    // Convert month name to number
                    $monthNumber = date('m', strtotime($selMonth));
                    
                    // Get employee ID
                    $emp_id = $_SESSION['idEMP'];
                    
                    // ========== FETCH ATTENDANCE DATA ==========
                    $table_name = DB."attendance";
                    $where = "emp_id = :emp_id AND att_month = :month AND att_year = :year ORDER BY att_check_in_date DESC";
                    $bind = array(
                        ":emp_id" => $emp_id,
                        ":month" => $monthNumber,
                        ":year" => $selYear
                    );
                    $attendanceData = $objDatabaseModel->select($table_name, $where, $bind, "DISTINCT att_check_in_date");
                    
                    // Create array of dates with attendance
                    $presentDates = array();
                    foreach($attendanceData as $row) {
                        $date = $row['att_check_in_date'];
                        $presentDates[$date] = true;
                    }
                    
                    // ========== FETCH LEAVE DATA ==========
                    $tAL = DB."apply_leave";
                    $wh = "leave_Approved = 1 
                           AND emp_id = '".$emp_id."'                
                           AND startDate BETWEEN '".$_SESSION['contractStartdate']."' AND '".$_SESSION['contractEnddate']."' 
                           AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL)";
                    $rAL = $objDatabaseModel->select($tAL, $wh, '', "startDate, endDate, leaveSubject");
                    
                    $leaveDates = array();
                    foreach($rAL as $leave) {
                        $start = strtotime($leave['startDate']);
                        $end = strtotime($leave['endDate']);
                        
                        // Loop through each day of leave
                        for($current = $start; $current <= $end; $current += (86400)) {
                            $leaveDate = date('Y-m-d', $current);
                            $leaveMonth = date('m', $current);
                            $leaveYear = date('Y', $current);
                            
                            // Only add if it's in selected month/year
                            if($leaveMonth == $monthNumber && $leaveYear == $selYear) {
                                $leaveDates[$leaveDate] = array(
                                    'subject' => $leave['leaveSubject'],
                                    'start' => $leave['startDate'],
                                    'end' => $leave['endDate']
                                );
                            }
                        }
                    }
                    
                    // ========== FETCH HOLIDAYS ==========
                    $holiday_table = DB."emp_holidays";
                    $holiday_where = "status = 1 AND YEAR(holidays_date) = ".$selYear." AND MONTH(holidays_date) = ".$monthNumber;
                    $holidays = $objDatabaseModel->select($holiday_table, $holiday_where, '', "*");
                    
                    $holidayArray = array();
                    foreach($holidays as $h) {
                        $date = $h['holidays_date'];
                        $holidayArray[$date] = $h['holidays_title'];
                    }
                    
                    // ========== GET SATURDAY OFF CONFIGURATION ==========
                    $satOFON = $objDatabaseModel->fununiversal('emp_posting_info','sat_off_yes_no','emp_id',$emp_id);
                    $specificSaturdays = array();
                    
                    if($satOFON == 0) {
                        // Default: 2nd and 4th Saturday off
                        $specificSaturdays = array();//2,4
                    } else {
                        // Get comma-separated values from database
                        $sat = $objDatabaseModel->fununiversal('emp_posting_info','no_sat','emp_id',$emp_id);
                        if(!empty($sat)) {
                            $specificSaturdays = explode(',', $sat);
                        }
                    }
                    
                    // Function to get Saturday number in month
                    function getSaturdayNumber($day) {
                        return ceil($day / 7);
                    }
                    
                    // Generate all dates of the month
                    $allDates = array();
                    $daysInMonth = cal_days_in_month(CAL_GREGORIAN, $monthNumber, $selYear);
                    
                    for($d = 1; $d <= $daysInMonth; $d++) {
                        $date = sprintf("%04d-%02d-%02d", $selYear, $monthNumber, $d);
                        $allDates[] = $date;
                    }
                    
                    // Month and Year selection form
                    ?>
                    
                    
                    
                    <!-- Legend -->
                    
                    
                    <!-- Attendance List -->
                    <div class="card">
                        <div class="card-header text-white" style="background:#212884">
                            <h4 class="m-0"><?=ucfirst($selMonth)?> <?=$selYear?> - Attendance List</h4>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-bordered table-hover mb-0">
                                <thead class="bg-light" >
                                    <tr>
                                        <th width="20%"><strong>Date</strong></th>
                                        <th width="15%"><strong>Day</strong></th>
                                        <th width="20%"><strong>Status</strong></th>
                                        <th width="45%"><strong>Details / Remarks</strong></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $totalPresent = 0;
                                    $totalAbsent = 0;
                                    $totalHolidays = 0;
                                    $totalLeaves = 0;
                                    $totalWeekends = 0;
                                    
                                    foreach($allDates as $date) {
                                        $dayNum = date('j', strtotime($date));
                                        $dayName = date('l', strtotime($date));
                                        $displayDate = date('d M Y', strtotime($date));
                                        $dayOfWeek = date('w', strtotime($date)); // 0 = Sunday
                                        
                                        // Check status in priority order
                                        $isHoliday = isset($holidayArray[$date]);
                                        $isLeave = isset($leaveDates[$date]);
                                        $isSunday = ($dayOfWeek == 0);
                                        
                                        // Check if Saturday off
                                        $isSaturday = ($dayOfWeek == 6);
                                        $saturdayNumber = getSaturdayNumber($dayNum);
                                        $isSaturdayOff = ($isSaturday && in_array($saturdayNumber, $specificSaturdays));
                                        
                                        $isPresent = isset($presentDates[$date]);
                                        
                                        // Determine status class and text
                                        $statusClass = '';
                                        $statusText = '';
                                        $details = '';
                                        $bgColor = '';
                                        $hoverColor = '';
                                        
                                        if($isHoliday) {
                                            $statusClass = 'holiday-row';
                                            $statusText = 'Holiday';
                                            $details = $holidayArray[$date];
                                            $bgColor = '#d1ecf1';
                                            $hoverColor = '#a8d8ea';
                                            $totalHolidays++;
                                        } elseif($isLeave) {
                                            $statusClass = 'leave-row';
                                            $statusText = 'Leave';
                                            $details = $leaveDates[$date]['subject'];
                                            $bgColor = '';
                                            $hoverColor = '#ffe69c';
                                            $totalLeaves++;
                                        } elseif($isSunday) {
                                            $statusClass = 'sunday-row';
                                            $statusText = 'Weekly Off';
                                            $details = 'Weekly Off';
                                            $bgColor = '#e2e3e5';
                                            $hoverColor = '#c6c8ca';
                                            $totalWeekends++;
                                        } elseif($isSaturdayOff) {
                                            $statusClass = 'saturday-row';
                                            $statusText = 'Saturday Off';
                                            $details = 'Scheduled Off';
                                            $bgColor = '#d6d8d9';
                                            $hoverColor = '#b9bbbe';
                                            $totalWeekends++;
                                        } elseif($isPresent) {
                                            $statusClass = 'present-row';
                                            $statusText = 'Present';
                                            $details = 'Attendance marked';
                                            $bgColor = '';
                                            $hoverColor = '#a9d6b5';
                                            $totalPresent++;
                                        } else {
                                            $statusClass = 'absent-row';
                                            $statusText = 'Absent';
                                            $details = 'No Log-in Recorded';
                                            $bgColor = '';
                                            $hoverColor = '#f0b3b9';
                                            $totalAbsent++;
                                        }
                                    ?>
                                    <tr class="<?=$statusClass?>" style="background-color: <?=$bgColor?>; color: #000000;">
                                        <td><?=$displayDate?></td>
                                        <td><?=$dayName?></td>
                                        <td style="font-weight: 500;"><?=$statusText?></td>
                                        <td><?=$details?></td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <!-- Summary Statistics -->
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header text-white" style="background:#212884">
                                    <h5 class="m-0">Monthly Summary - <?=ucfirst($selMonth)?> <?=$selYear?></h5>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-md-2 col-6 mb-2">
                                            <div class="border p-3">
                                                <h3><?=$daysInMonth?></h3>
                                                <span>Total Days</span>
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-6 mb-2">
                                            <div class="border p-3" style="background-color: #d4edda; color: #000000;">
                                                <h3><?=$totalPresent?></h3>
                                                <span>Present</span>
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-6 mb-2">
                                            <div class="border p-3" style="background-color: #f8d7da; color: #000000;">
                                                <h3><?=$totalAbsent?></h3>
                                                <span>Absent</span>
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-6 mb-2">
                                            <div class="border p-3" style="background-color: #d1ecf1; color: #000000;">
                                                <h3><?=$totalHolidays?></h3>
                                                <span>Holidays</span>
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-6 mb-2">
                                            <div class="border p-3" style="background-color: #fff3cd; color: #000000;">
                                                <h3><?=$totalLeaves?></h3>
                                                <span>Leaves</span>
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-6 mb-2">
                                            <div class="border p-3" style="background-color: #e2e3e5; color: #000000;">
                                                <h3><?=$totalWeekends?></h3>
                                                <span>Weekends</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>        
    </div>
    </section>
</div>

<style>
/* Base table styles */
.table {
    background-color: white;
}

.table-bordered {
    border: 1px solid #dee2e6;
}

.table thead th {
    border-bottom: 2px solid #dee2e6;
    background-color: #f8f9fa;
}

/* Row styles - all text black by default */
.present-row,
.absent-row,
.holiday-row,
.leave-row,
.sunday-row,
.saturday-row {
    color: #000000!important;
}

/* Hover effects - darker shade of same color */
.present-row:hover {
    background-color: #a9d6b5 !important;
    color: #000000 !important;
}

.absent-row:hover {
    background-color: #f0b3b9 !important;
    color: #000000 !important;
}

.holiday-row:hover {
    background-color: #a8d8ea !important;
    color: #000000 !important;
}

.leave-row:hover {
    background-color: #ffe69c !important;
    color: #000000 !important;
}

.sunday-row:hover {
    background-color: #c6c8ca !important;
    color: #000000 !important;
}

.saturday-row:hover {
    background-color: #b9bbbe !important;
    color: #000000 !important;
}

/* Table cell padding */
.table td, .table th {
    padding: 12px;
    vertical-align: middle;
}

/* Responsive */
@media (max-width: 768px) {
    .table td, .table th {
        font-size: 13px;
        padding: 8px 5px;
    }
}

/* Card styles */
.card {
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    border: none;
    margin-bottom: 20px;
}

.card-header {
    border-bottom: none;
    padding: 15px 20px;
}

/* Badge styles */
.badge {
    padding: 8px 12px;
    font-size: 13px;
    font-weight: normal;
}
</style>

<script>
$(document).ready(function() {
    // Auto-submit when month or year changes
    $('#mName, #yName').on('change', function() {
        if($('#mName').val() && $('#yName').val()) {
            $('#ymFRM').submit();
        }
    });
});
</script>

<?php
include 'footer.php';
?>