<?php
// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ========== SABSE IMPORTANT: INDIA TIME ZONE SET KARO ==========
date_default_timezone_set('Asia/Kolkata');

header('Content-Type: application/json');
include("session_check.php");
include("../includes/cpt.inc.php");

// Get POST data
$data = json_decode(file_get_contents('php://input'), true);

if (!$data) {
    echo json_encode(['success' => false, 'message' => 'No data received']);
    exit;
}

// Get values
$emp_id = $data['emp_id'] ?? $_SESSION['idEMP'];
$emp_name = $data['emp_name'] ?? $_SESSION['nameEMP'];
$latitude = $data['latitude'] ?? 0;
$longitude = $data['longitude'] ?? 0;
$accuracy = $data['accuracy'] ?? 0;
$action = $data['action'] ?? 'check_in';

// Get real IP address
function getRealIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } else {
        return $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
    }
}

$ip_address = getRealIP();

// ========== Reverse Geocoding Function with better error handling ==========
function getLocationFromCoordinates($lat, $lon) {
    // Agar coordinates 0 hain to return default
    if($lat == 0 || $lon == 0 || $lat == '' || $lon == '') {
        return [
            'city' => 'Unknown',
            'region' => 'Unknown',
            'country' => 'Unknown',
            'isp' => 'GPS Location'
        ];
    }
    
    $city = 'Unknown';
    $region = 'Unknown';
    $country = 'Unknown';
    
    // API 1: OpenStreetMap Nominatim (Free, no key required)
    try {
        $url = "https://nominatim.openstreetmap.org/reverse?format=json&lat={$lat}&lon={$lon}&zoom=18&addressdetails=1";
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'AttendanceSystem/1.0'); // Required by Nominatim
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($response && $httpCode == 200) {
            $data = json_decode($response, true);
            
            if ($data && isset($data['address'])) {
                $address = $data['address'];
                
                // Try different city/area fields
                $city = $address['city'] ?? 
                        $address['town'] ?? 
                        $address['village'] ?? 
                        $address['hamlet'] ?? 
                        $address['suburb'] ?? 
                        $address['county'] ?? 
                        'Unknown';
                
                $region = $address['state'] ?? 
                          $address['region'] ?? 
                          $address['county'] ?? 
                          'Unknown';
                
                $country = $address['country'] ?? 'Unknown';
                
                return [
                    'city' => $city,
                    'region' => $region,
                    'country' => $country,
                    'isp' => 'GPS Location'
                ];
            }
        }
    } catch (Exception $e) {
        error_log("OpenStreetMap API error: " . $e->getMessage());
    }
    
    // API 2: BigDataCloud (Free, no key required for limited usage)
    try {
        $url = "https://api.bigdatacloud.net/data/reverse-geocode-client?latitude={$lat}&longitude={$lon}&localityLanguage=en";
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($response && $httpCode == 200) {
            $data = json_decode($response, true);
            
            if ($data) {
                $city = $data['city'] ?? 
                        $data['locality'] ?? 
                        $data['principalLocality'] ?? 
                        $data['localityInfo']['administrative'][count($data['localityInfo']['administrative'])-2]['name'] ?? 
                        'Unknown';
                
                $region = $data['principalSubdivision'] ?? 
                          $data['isoPrincipalSubdivision'] ?? 
                          'Unknown';
                
                $country = $data['countryName'] ?? 'Unknown';
                
                return [
                    'city' => $city,
                    'region' => $region,
                    'country' => $country,
                    'isp' => 'GPS Location'
                ];
            }
        }
    } catch (Exception $e) {
        error_log("BigDataCloud API error: " . $e->getMessage());
    }
    
    // API 3: LocationIQ (if you have a free token - sign up at locationiq.com)
    // Uncomment and add your token if you want to use this
 
    try {
        $token = 'pk.0cec96d229788cfbe7ab322dd4de1665'; // Get from https://locationiq.com/
        $url = "https://us1.locationiq.com/v1/reverse.php?key={$token}&lat={$lat}&lon={$lon}&format=json";
		
				
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($response && $httpCode == 200) {
            $data = json_decode($response, true);
            
            if ($data && isset($data['address'])) {
                $address = $data['address'];
                
                $city = $address['city'] ?? 
                        $address['town'] ?? 
                        $address['village'] ?? 
                        $address['county'] ?? 
                        'Unknown';
                
                $region = $address['state'] ?? 'Unknown';
                $country = $address['country'] ?? 'Unknown';
                
                return [
                    'city' => $city,
                    'region' => $region,
                    'country' => $country,
                    'isp' => 'GPS Location'
                ];
            }
        }
    } catch (Exception $e) {
        error_log("LocationIQ API error: " . $e->getMessage());
    }
     
    
    // API 4: IP-based fallback with geoplugin (last resort)
    try {
        // Get approximate location from IP
        $ip = $_SERVER['REMOTE_ADDR'];
        if ($ip != '127.0.0.1' && $ip != '::1') {
            $url = "http://www.geoplugin.net/json.gp?ip=" . $ip;
            
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 3);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            $response = curl_exec($ch);
            curl_close($ch);
            
            if ($response) {
                $data = json_decode($response, true);
                if ($data && isset($data['geoplugin_city'])) {
                    return [
                        'city' => $data['geoplugin_city'] ?? 'Unknown',
                        'region' => $data['geoplugin_region'] ?? 'Unknown',
                        'country' => $data['geoplugin_countryName'] ?? 'Unknown',
                        'isp' => 'IP Location (Approximate)'
                    ];
                }
            }
        }
    } catch (Exception $e) {
        error_log("GeoPlugin API error: " . $e->getMessage());
    }
    
    // Final fallback: Return formatted coordinates
    return [
        'city' => "Loc: " . round($lat, 4) . ", " . round($lon, 4),
        'region' => 'GPS Location',
        'country' => 'Unknown',
        'isp' => 'GPS Location'
    ];
}

// ========== Get location from coordinates ==========
$location = getLocationFromCoordinates($latitude, $longitude);

// Browser detection
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

function getBrowser($ua) {
    if (strpos($ua, 'Chrome') !== false) return 'Chrome';
    if (strpos($ua, 'Firefox') !== false) return 'Firefox';
    if (strpos($ua, 'Safari') !== false) return 'Safari';
    if (strpos($ua, 'Edge') !== false) return 'Edge';
    return 'Other';
}

function getDevice($ua) {
    if (strpos($ua, 'Mobile') !== false) return 'Mobile';
    if (strpos($ua, 'Tablet') !== false) return 'Tablet';
    if (strpos($ua, 'iPad') !== false) return 'Tablet';
    if (strpos($ua, 'iPhone') !== false) return 'Mobile';
    if (strpos($ua, 'Android') !== false) return 'Mobile';
    return 'Desktop';
}

$browser = getBrowser($user_agent);
$device = getDevice($user_agent);

// Current date and time (India time - set above)
$current_date = date('Y-m-d');
$current_time = date('H:i:s');
$current_hour = (int)date('H'); // 24-hour format mein hour
$current_minute = (int)date('i'); // Minutes
$current_month = date('m');
$current_year = date('Y');

// Initialize response array
$response = ['success' => false, 'message' => 'Unknown error'];

try {
    if ($action == 'check_in') {
        
        // ========== 📍 9 AM CHECK - EXACT 9:00 AM KE BAAD HI ALLOW ==========
        // Check karo ki current time 9:00 AM se kam to nahi
        if ($current_hour < 9) {
            // Agar 9 AM se pehle hai to error message bhejo
            
            // Format time for display (e.g., 08:30 AM)
            $current_time_display = date('h:i A');
            
            $response = [
                'success' => false,
                'message' => "⏰ Check-in is only possible after 9:00 AM. Your current time: $current_time_display (India Time)"
            ];
            
            echo json_encode($response);
            exit; // Yahan se exit - aage kuch nahi hoga
        }
        // ========== 9 AM CHECK END ==========
        
        // Check for maximum 3 check-ins per day
        $table_name = DB."attendance";
        
        // Count total check-ins today
        $where_count = "emp_id = :emp_id AND att_check_in_date = :today";
        $bind_count = array(
            ":emp_id" => $emp_id,
            ":today" => $current_date
        );
        
        $total_today = $objDatabaseModel->selectCount($table_name, $where_count, $bind_count);
        $total_count = isset($total_today[0]['count(*)']) ? (int)$total_today[0]['count(*)'] : 0;
        
        if ($total_count >= 3) {
            $response = [
                'success' => false, 
                'message' => 'You have reached maximum 3 check-ins for today!',
                'action' => 'limit_reached'
            ];
            echo json_encode($response);
            exit;
        }
        
        // Check if already checked in today (active session)
        $where_active = "emp_id = :emp_id AND att_check_in_date = :today AND att_check_out_date IS NULL";
        $bind_active = array(
            ":emp_id" => $emp_id,
            ":today" => $current_date
        );
        
        $active_count = $objDatabaseModel->selectCount($table_name, $where_active, $bind_active);
        $active_count_val = isset($active_count[0]['count(*)']) ? (int)$active_count[0]['count(*)'] : 0;
        
        if ($active_count_val > 0) {
            $response = [
                'success' => false, 
                'message' => 'You have already checked in today! Please check out first.',
                'action' => 'check_out_needed'
            ];
            echo json_encode($response);
            exit;
        }
        
        // CHECK-IN: Insert new record
        $insert_table_name = DB."attendance";
        $insert = array(
            'emp_id' => $emp_id,
            'emp_name' => $emp_name,
            'att_month' => $current_month,
            'att_year' => $current_year,
            'att_check_in_date' => $current_date,
            'att_check_in_time' => $current_time,
            'check_in_latitude' => $latitude,
            'check_in_longitude' => $longitude,
            'check_in_accuracy' => $accuracy,
            'check_in_ip_address' => $ip_address,
            'check_in_city' => $location['city'],
            'check_in_region' => $location['region'],
            'check_in_country' => $location['country'],
            'check_in_isp' => $location['isp'],
            'check_in_user_agent' => $user_agent,
            'check_in_browser' => $browser,
            'check_in_device_type' => $device,
            'leaveApplicable' => 0,
            'leaveDay' => 0.0,
            'rm_approvel' => 0,
            'rm_id' => 0
        );
        
        $result = $objDatabaseModel->insert($insert_table_name, $insert);
        
        if ($result) {
            $remaining = 3 - ($total_count + 1);
            $remaining_msg = $remaining > 0 ? " You have $remaining Log-In(s) left today." : " This was your last check-in for today.";
            
            $response = [
                'success' => true, 
                'message' => 'Log-In Successful!' . $remaining_msg,
                'action' => 'checked_in',
                'check_in_time' => $current_time,
                'remaining' => $remaining
            ];
        } else {
            $response = ['success' => false, 'message' => 'Error saving check-in'];
        }
    } 
    else if ($action == 'check_out') {
        // CHECK-OUT: Update existing record
        $table_name = DB."attendance";
        $where = "emp_id = :emp_id AND att_check_in_date = :today AND att_check_out_date IS NULL";
        $bind = array(
            ":emp_id" => $emp_id,
            ":today" => $current_date
        );
        
        // Get the record
        $rowData = $objDatabaseModel->select($table_name, $where, $bind, "id, att_check_in_time");
        
        if (empty($rowData)) {
            $response = [
                'success' => false, 
                'message' => 'No active check-in found for today!'
            ];
            echo json_encode($response);
            exit;
        }
        
        $attendance_id = $rowData[0]['id'];
        $check_in_time = $rowData[0]['att_check_in_time'];
        
        // Calculate working hours
        $check_in_datetime = strtotime($current_date . ' ' . $check_in_time);
        $check_out_datetime = strtotime($current_date . ' ' . $current_time);
        $working_seconds = max(0, $check_out_datetime - $check_in_datetime); // Ensure non-negative
        $working_hours = round($working_seconds / 3600, 2);
        
        // Update with checkout details
        $update_table_name = DB."attendance";
        $update = array(
            'att_check_out_date' => $current_date,
            'att_check_out_time' => $current_time,
            'check_out_latitude' => $latitude,
            'check_out_longitude' => $longitude,
            'check_out_accuracy' => $accuracy,
            'check_out_ip_address' => $ip_address,
            'check_out_city' => $location['city'],
            'check_out_region' => $location['region'],
            'check_out_country' => $location['country'],
            'check_out_isp' => $location['isp'],
            'check_out_user_agent' => $user_agent,
            'check_out_browser' => $browser,
            'check_out_device_type' => $device,
            'check_out_type' => 'Manual Check Out'
        );
        
        $update_where = "id = :id";
        $update_bind = array(":id" => $attendance_id);
        
        $result = $objDatabaseModel->update($update_table_name, $update, $update_where, $update_bind);
        
        if ($result) {
            // Count remaining check-ins
            $where_count = "emp_id = :emp_id AND att_check_in_date = :today";
            $bind_count = array(
                ":emp_id" => $emp_id,
                ":today" => $current_date
            );
            
            $total_today = $objDatabaseModel->selectCount($table_name, $where_count, $bind_count);
            $total_count = isset($total_today[0]['count(*)']) ? (int)$total_today[0]['count(*)'] : 0;
            $remaining = 3 - $total_count;
            
            $response = [
                'success' => true, 
                'message' => 'Log-Out Successful!',
                'action' => 'checked_out',
                'check_out_time' => $current_time,
                'working_hours' => $working_hours,
                'remaining' => $remaining
            ];
        } else {
            $response = ['success' => false, 'message' => 'Error saving check-out'];
        }
    }
    else if ($action == 'check_status') {
        // CHECK CURRENT STATUS
        $table_name = DB."attendance";
        
        // Check active session
        $where_active = "emp_id = :emp_id AND att_check_in_date = :today AND att_check_out_date IS NULL";
        $bind_active = array(
            ":emp_id" => $emp_id,
            ":today" => $current_date
        );
        
        $activeData = $objDatabaseModel->select($table_name, $where_active, $bind_active, "*");
        
        // Get remaining check-ins count
        $where_count = "emp_id = :emp_id AND att_check_in_date = :today";
        $bind_count = array(
            ":emp_id" => $emp_id,
            ":today" => $current_date
        );
        
        $total_today = $objDatabaseModel->selectCount($table_name, $where_count, $bind_count);
        $total_count = isset($total_today[0]['count(*)']) ? (int)$total_today[0]['count(*)'] : 0;
        $remaining = 3 - $total_count;
        
        if (!empty($activeData)) {
            $response = [
                'success' => true,
                'status' => 'checked_in',
                'check_in_time' => $activeData[0]['att_check_in_time'],
                'message' => 'You are checked in',
                'remaining' => $remaining,
                'total_today' => $total_count
            ];
        } else {
            $response = [
                'success' => true,
                'status' => 'checked_out',
                'message' => 'You are checked out',
                'remaining' => $remaining,
                'total_today' => $total_count
            ];
        }
    }
    
    // Send JSON response
    echo json_encode($response);
    
} catch (Exception $e) {
    // Log error
    error_log("Attendance error: " . $e->getMessage());
    
    // Send error response
    echo json_encode([
        'success' => false, 
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}
?>