<?php
include("session_check.php");
include("../includes/cpt.inc.php");
include("../phpmailer/class.phpmailer.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $leaveType = $_POST['leaveType'] ?? [];
    $half = $_POST['half'] ?? [];
    $description = trim($_POST['leave_description'] ?? '');
    
    $result = [];
    $fullDaysCount = 0;
    $halfDaysCount = 0;

    foreach ($leaveType as $date => $type) {
        // Skip if leave type is "none" or empty
        if ($type === 'none' || $type === '') {
            continue;
        }

        $result[] = [
            'date' => $date,
            'leave_type' => $type,
            'half_day' => $half[$date] ?? null
        ];
    }
    
    // Determine the leave subject full form
    if($_POST['leaveSubject'] == 'CL') {
        if($_POST['clslTitle'] == 'Casual Leave') {            
            $subNew = 'Casual Leave';            
        } else {
            $subNew = 'Sick Leave';
        }    
    } else {
        $subNew = 'Earned Leave';
    }
    
    // Handle medical document for Sick Leave
    if($subNew == 'Sick Leave') {
        $med_doc = $objDatabaseModel->uploadFiles(
            $_FILES["sickleaveDoc"]["name"],
            $_FILES["sickleaveDoc"]["size"],
            $_FILES['sickleaveDoc']['tmp_name'],
            'medical_document'
        );
    } else {
        $med_doc = NULL;
    }
    
    // Check if leave already exists for these dates
    $table_name55 = DB."apply_leave";    
    $where55 = "emp_id='".$_SESSION['idEMP']."' 
                AND (startDate BETWEEN '".$_REQUEST['startDate']."' AND '".$_REQUEST['endDate']."' 
                OR endDate BETWEEN '".$_REQUEST['startDate']."' AND '".$_REQUEST['endDate']."') 
                AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL)";
    
    $rowDataLD55 = $objDatabaseModel->selectCount($table_name55, $where55, '');
    
    if($rowDataLD55[0]['count(*)'] == 0) {    
        $tblID = [];
        
        foreach($result as $key => $resVal) {
            if($resVal['leave_type'] == 'full') {
                $day = 1;
                $half_day = '';
                $half_date = '0000-00-00';
                $fullDaysCount += 1;
            } else {
                $day = 0.5;
                $half_day = $resVal['half_day'];
                $half_date = $resVal['date'];
                $halfDaysCount += 0.5;
            }
            
            $insert_table_name = DB."apply_leave";
            $insert['emp_id'] = $_SESSION['idEMP'];    
            $insert['emp_name'] = $_SESSION['nameEMP'];                            
            $insert['leaveSubject'] = $subNew; // This will store full form like "Casual Leave", "Sick Leave", or "Earned Leave"
            $insert['startDate'] = $resVal['date'];
            $insert['endDate'] = $resVal['date'];
            $insert['leaveDays'] = $day;
            $insert['leave_description'] = addslashes($description);
            $insert['designation'] = NULL;
            $insert['theme'] = NULL;    
            $insert['dist'] = NULL;
            $insert['block'] = NULL;
            $insert['leave_applydate'] = date('Y-m-d H:i:s');    
            $insert['linkOfficer'] = $_SESSION['emp_RM_id'];
            $insert['recommending_officer'] = NULL;    
            $insert['approve_officer'] = NULL;    
            $insert['leaveDoc'] = $med_doc;
            $insert['halfDayDate'] = date('Y-m-d', strtotime($half_date));
            $insert['halfType'] = $half_day;
            
            $objDatabaseModel->insert($insert_table_name, $insert);
            $tblID[] = $objDatabaseModel->lastInsertId();       
        }

        // Send email notification to reporting manager
        $implodeTablIds = implode(',', $tblID);
        $leaveDaysCount = $fullDaysCount + $halfDaysCount;
        $reportingManagerEmail = $objDatabaseModel->fununiversal('emp_login', 'emp_email', 'id', $_SESSION['emp_RM_id']);
        
        $appAovedURL = 'https:' . SITE_WS_PATH . '/leaveMGT/leave.php?a=' . base64_encode($_SESSION['idEMP']) . 
                       '&b=' . base64_encode($_SESSION['emp_RM_id']) . '&c=' . base64_encode($implodeTablIds) . '&d=' . base64_encode(1);  
        $unAovedURL = 'https:' . SITE_WS_PATH . '/leaveMGT/leave.php?a=' . base64_encode($_SESSION['idEMP']) . 
                      '&b=' . base64_encode($_SESSION['emp_RM_id']) . '&c=' . base64_encode($implodeTablIds) . '&d=' . base64_encode(2);          
        
        $templateContents_userMail = getMailTemplate('leaveEmail_DIST.php');    
        $rep_array = array('__NAME__', '__SDATE__', '__EDATE__', '__LEVDIS__', '__EID__', '__APPURL__', '__UNURL__', '__NOLEVDAYS__');    
        $rep_with = array(
            $_SESSION['nameEMP'],
            $_REQUEST['startDate'],
            $_REQUEST['endDate'],
            strip_tags($_REQUEST['leave_description']),
            $_SESSION['emp_loginID'],
            $appAovedURL,
            $unAovedURL,
            $leaveDaysCount
        );
        $message = replaceTextMessage($rep_array, $rep_with, $templateContents_userMail);         
        $subject = "Leave Days request " . $_SESSION['nameEMP'];
        $arrccmail = '';
        $arraybccmail = '';        
        
        // Uncomment to send email
        // $objDatabaseModel->spMail($subject, $message, $reportingManagerEmail, $arrccmail, $arraybccmail, $_SESSION['nameEMP']);
        echo 1;
    } else {
        echo 0;
    }
}
?>