<?php
function sundayCountInMonth($month, $year, $contractStartDate, $contractEndDate) {
    $startOfMonth = strtotime("$year-$month-01");
    $endOfMonth = strtotime(date('Y-m-t', $startOfMonth)); // Last day of month

    $contractStart = strtotime($contractStartDate);
    $contractEnd = strtotime($contractEndDate);

    // Set start date (maximum of month start or contract start)
    if ($contractStart < $startOfMonth) {
        $currentDate = $startOfMonth;
    } else {
        $currentDate = $contractStart;
    }

    // Set end date (minimum of month end or contract end)
    if ($contractEnd > $endOfMonth) {
        $endDate = $endOfMonth;
    } else {
        $endDate = $contractEnd;
    }

    $sundayCount = 0;

    while ($currentDate <= $endDate) {
        if (date('w', $currentDate) == 0) { // Sunday
            $sundayCount++;
        }
        $currentDate = strtotime('+1 day', $currentDate); // Add 1 day
    }

    return $sundayCount;
}

// Example usage:
$month = '04'; // April
$year = '2025';
$contractStartDate = '2025-04-10';
$contractEndDate = '2025-04-25';

echo "Total Sundays between contract dates: " . sundayCountInMonth($month, $year, $contractStartDate, $contractEndDate);
?>
