<?php
function createThumbnail1($srcFile, $destFile, $quality = 75)
{
    $thumbnail = '';
    
    if (file_exists($srcFile)  && isset($destFile))
    {
        $size        = getimagesize($srcFile);
        //$w           = number_format($width, 0, ',', '');
        //$h           = number_format(($size[1] / $size[0]) * $width, 0, ',', '');
        $w			= $width;
		$h			= $height;
        $thumbnail =  imageCompression($srcFile, 150, $destFile);
    }
    
    // return the thumbnail file name on sucess or blank on fail
    return basename($thumbnail);
}


function createThumbnail3($srcFile, $destFile, $quality = 75)
{
    $thumbnail = '';
    
    if (file_exists($srcFile)  && isset($destFile))
    {
        $size        = getimagesize($srcFile);
        //$w           = number_format($width, 0, ',', '');
        //$h           = number_format(($size[1] / $size[0]) * $width, 0, ',', '');
        $w			= $width;
		$h			= $height;
        $thumbnail =  imageCompression($srcFile, 300, $destFile);
    }
    
    // return the thumbnail file name on sucess or blank on fail
    return basename($thumbnail);
}


function createThumbnail2($srcFile, $destFile, $quality = 75)
{
    $thumbnail = '';
    
    if (file_exists($srcFile)  && isset($destFile))
    {
        $size        = getimagesize($srcFile);
        //$w           = number_format($width, 0, ',', '');
        //$h           = number_format(($size[1] / $size[0]) * $width, 0, ',', '');
        $w			= $width;
		$h			= $height;
        $thumbnail =  imageCompression($srcFile, 157, $destFile);
    }
    
    // return the thumbnail file name on sucess or blank on fail
    return basename($thumbnail);
}
function imageCompression($imgfile="",$thumbsize=0,$savePath=NULL) { 
    if($savePath==NULL) { 
        header('Content-type: image/jpeg'); 
    } 
    list($width,$height)=getimagesize($imgfile); 
    /* The width and the height of the image also the getimagesize retrieve other information as well   */ 

    $imgratio=$width/$height;  
    
    if($imgratio>1) { 
        $newwidth=$thumbsize; 
        $newheight=$thumbsize/$imgratio; 
    } else { 
        $newheight=$thumbsize;        
        $newwidth=$thumbsize*$imgratio; 
    } 
    
    $thumb=imagecreatetruecolor($newwidth,$newheight); // Making a new true color image 
    $source=imagecreatefromjpeg($imgfile); // Now it will create a new image from the source 
    imagecopyresampled($thumb,$source,0,0,0,0,$newwidth,$newheight,$width,$height);  // Copy and resize the image 
    imagejpeg($thumb,$savePath,100); 
    imagedestroy($thumb); 
} 
/*
    Copy an image to a destination file. The destination
    image size will be $w X $h pixels
*/
function copyImage($srcFile, $destFile, $w, $h, $quality = 75)
{
    $tmpSrc     = pathinfo(strtolower($srcFile));
    $tmpDest    = pathinfo(strtolower($destFile));
    $size       = getimagesize($srcFile);

    if ($tmpDest['extension'] == "gif" || $tmpDest['extension'] == "jpg" || $tmpDest['extension'] == "JPG")
    {
       $destFile  = substr_replace($destFile, 'jpg', -3);
       $dest      = imagecreatetruecolor($w, $h);
       imageantialias($dest, TRUE);
    } elseif ($tmpDest['extension'] == "png") {
       $dest = imagecreatetruecolor($w, $h);
       imageantialias($dest, TRUE);
    } else {
      return false;
    }

    switch($size[2])
    {
       case 1:       //GIF
           $src = imagecreatefromgif($srcFile);
           break;
       case 2:       //JPEG
           $src = imagecreatefromjpeg($srcFile);
           break;
       case 3:       //PNG
           $src = imagecreatefrompng($srcFile);
           break;
       default:
           return false;
           break;
    }

    imagecopyresampled($dest, $src, 0, 0, 0, 0, $w, $h, $size[0], $size[1]);

    switch($size[2])
    {
       case 1:
       case 2:
           imagejpeg($dest,$destFile, $quality);
           break;
       case 3:
           imagepng($dest,$destFile);
    }
    return $destFile;

}
?>