<?php
class DataBaseModel extends PDO {	
	private $error = 'Test error';
	private $sql;
	private $bind;
	private $errorCallbackFunction;
	private $errorMsgFormat;
		
	public function DataBaseModel_2($dsn, $user, $passwd, $driver_options) {
		$options = array(
			PDO::ATTR_PERSISTENT => true, 
			PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
			
		);
 
		try {
			parent::__construct($dsn, $user, $passwd, $driver_options);
		} catch (PDOException $e) {
			$this->error = $e->getMessage();
		}
	}
 
 
	private function debug() {
		if(!empty($this->errorCallbackFunction)) {
			$error = array("Error" => $this->error);
			if(!empty($this->sql))
				$error["SQL Statement"] = $this->sql;
			if(!empty($this->bind))
				$error["Bind Parameters"] = trim(print_r($this->bind, true));
 
			$backtrace = debug_backtrace();
			if(!empty($backtrace)) {
				foreach($backtrace as $info) {
					if($info["file"] != __FILE__)
						$error["Backtrace"] = $info["file"] . " at line " . $info["line"];	
				}		
			}
 
			$msg = "";
			if($this->errorMsgFormat == "html") {
				if(!empty($error["Bind Parameters"]))
					$error["Bind Parameters"] = "<pre>" . $error["Bind Parameters"] . "</pre>";
				$css = trim(file_get_contents(dirname(__FILE__) . "/error.css"));
				$msg .= '<style type="text/css">' . "\n" . $css . "\n</style>";
				$msg .= "\n" . '<div class="db-error">' . "\n\t<h3>SQL Error</h3>";
				foreach($error as $key => $val)
					$msg .= "\n\t<label>" . $key . ":</label>" . $val;
				$msg .= "\n\t</div>\n</div>";
			}
			elseif($this->errorMsgFormat == "text") {
				$msg .= "SQL Error\n" . str_repeat("-", 50);
				foreach($error as $key => $val)
					$msg .= "\n\n$key:\n$val";
			}
 
			$func = $this->errorCallbackFunction;
			$func($msg);
		}
	}
 
	public function delete($table, $where, $bind="") {
		 $sql = "DELETE FROM " . $table . " WHERE " . $where . ";";		 
		 $this->run($sql, $bind);
	}
 
// "TRUNCATE `jdk08_nltlbk_product_temp`"?
 	public function truncate($table) {
		 $sql = "TRUNCATE " . $table;		 
		 $this->run($sql, $bind='');
	}
 
 
	private function filter($table, $info) {
		$driver = $this->getAttribute(PDO::ATTR_DRIVER_NAME);
		if($driver == 'sqlite') {
			$sql = "PRAGMA table_info('" . $table . "');";
			$key = "name";
		}
		elseif($driver == 'mysql') {
			$sql = "DESCRIBE " . $table . ";";
			$key = "Field";
		}
		else {	
			$sql = "SELECT column_name FROM information_schema.columns WHERE table_name = '" . $table . "';";
			$key = "column_name";
		}	
		
		
 
		if(false!=($list = $this->run($sql))) {
			$fields = array();
			foreach($list as $record)
				$fields[] = $record[$key];
			return array_values(array_intersect($fields, array_keys($info)));
		}
		return array();
	}
 
	private function cleanup($bind) {
		if(!is_array($bind)) {
			if(!empty($bind))
				$bind = array($bind);
			else
				$bind = array();
		}
		return $bind;
	}
 
	public function insert($table, $info) {
		//if($table=="v_par_users_members_events_invitations"){
			//print_r($_REQUEST);
		//}
				
		$fields = $this->filter($table, $info);
		//print_r($info);
		//echo  $sql1 = "INSERT INTO " . $table . " (" . implode($fields, ", ") . ") VALUES (" . implode($fields, ", :") . ");";
		//$sql = "INSERT INTO " . $table . " (" . implode($fields, ", ") . ") VALUES (:" . implode($fields, ", :") . ");";
		
		$sql = "INSERT INTO " . $table . " (" . implode(", ",$fields) . ") VALUES (:" . implode(", :",$fields ) . ");";
		
		//echo $sql;exit; 
		$bind = array();
		foreach($fields as $field)
		$bind[":$field"] = $info[$field];
		$this->run($sql, $bind);
		return $this->lastInsertId();
	}
 
	public function run($sql, $bind="") {
		$this->sql = trim($sql);
		$this->bind = $this->cleanup($bind);
		$this->error = "";
		
		
		/*echo '<pre>';
		print_r($bind);
		echo $sql;
       echo '</pre>';*/
	   
		try { 
			$pdostmt = $this->prepare($this->sql);
			if(@$pdostmt->execute($this->bind)!== false) {
				if(preg_match("/^(" . implode("|", array("select", "describe", "pragma")) . ") /i", $this->sql))
					return $pdostmt->fetchAll(PDO::FETCH_ASSOC);
				elseif(preg_match("/^(" . implode("|", array("delete", "insert", "update", "show")) . ") /i", $this->sql))
					return $pdostmt->rowCount();
			}	
		} catch (PDOException $e) {
			$this->error = $e->getMessage();	
			$this->debug();
			return false;
		}
	}
 
	public function select($table, $where="", $bind="", $fields="*", $aad_sql="") {
		$sql = "SELECT " . $fields . " FROM " . $table;
		if(!empty($where))
			$sql .= " WHERE " . $where ." ";
		    $sql .= $aad_sql.";";
			
	       //echo $sql; 		  
		    return $this->run($sql, $bind);
	}
	
	public function select2($sql, $bind = "") {
    // यह function raw SQL accept करेगा
    return $this->run($sql, $bind);
}
 
 	public function selectCount($table,$where,$bind="",$getR="*") {
		    $sql = "SELECT count(".$getR.") FROM " . $table;
			if(!empty($where)){
				$sql .= " WHERE " . $where ." ";				
			}			
	    //echo $sql; 
		    return $this->run($sql, $bind);
	}
	
	
	
	
	
  public function showTable($table,$bind="") {	  
		    $sql = "SHOW TABLES LIKE '" .$table."'";					
	        //echo $sql; 
		    return $this->run($sql, $bind);
	}
  
  
  public function selectCountOrder($table,$where,$bind,$getR) {
		    $sql = "SELECT count(".$getR.") FROM " . $table;
			if(!empty($where)){
				$sql .= " WHERE " . $where ." ";				
			}			
	        //echo $sql; 
		    return $this->run($sql, $bind);
	}
  
  
   	public function selectRatingCount($table,$where,$bind="",$getR="id") {
		    $sql = "SELECT count(".$getR.") as n, SUM(rating) as t FROM " . $table;
			if(!empty($where)){
				$sql .= " WHERE " . $where ." ";				
			}			
	        //echo $sql; 
		    return $this->run($sql, $bind);
	}
  
  
  public function bestSellingProdcutCount($table,$where,$bind="",$getR="id") {
		    $sql = "SELECT productid,count(".$getR.")c FROM " . $table ." group by `productid` order by c desc";
			if(!empty($where)){
				$sql .= " WHERE " . $where ." ";				
			}			
	      //  echo $sql; 
		    return $this->run($sql, $bind);
	}


  
  
  
  
 
	public function setErrorCallbackFunction($errorCallbackFunction, $errorMsgFormat="html") {
		//Variable functions for won't work with language constructs such as echo and print, so these are replaced with print_r.
		if(in_array(strtolower($errorCallbackFunction), array("echo", "print")))
			$errorCallbackFunction = "print_r";
 
		if(function_exists($errorCallbackFunction)) {
			$this->errorCallbackFunction = $errorCallbackFunction;	
			if(!in_array(strtolower($errorMsgFormat), array("html", "text")))
				$errorMsgFormat = "html";
			$this->errorMsgFormat = $errorMsgFormat;	
		}	
	}
 
	public function update($table, $info, $where, $bind="") {
		
		//print_r($info);
		
		$fields = $this->filter($table, $info);
		$fieldSize = sizeof($fields);
 
		$sql = "UPDATE " . $table . " SET ";
		for($f = 0; $f < $fieldSize; ++$f) {
			if($f > 0)
				$sql .= ", ";
			$sql .= $fields[$f] . " = :update_" . $fields[$f]; 
		}
		 $sql .= " WHERE " . $where . ";";  
		 
		  //echo  $sql; 
		   //exit;
		 
		$bind = $this->cleanup($bind);
		foreach($fields as $field)
			$bind[":update_$field"] = $info[$field];
		
		return $this->run($sql, $bind);
	}
	
	


/*function db_query($sql,  $execute=array())
{
	if($dbcon2==''){
		if(!isset($GLOBALS['dbcon'])) {
			connect_db();
		}
		$dbcon2	= $GLOBALS['dbcon'];
	}	
//echo $sql;
print_r($execute);
	$prepare_sql = $GLOBALS['dbcon']->prepare($sql);
	$prepare_sql->execute($execute);
	$result = $prepare_sql->fetchALL(PDO::FETCH_ASSOC);	
	return $result;
}*/








// db_query: Updated 10 oct 2006
/*function db_query($sql, $dbcon2 = null)
{
	if($dbcon2==''){
		if(!isset($GLOBALS['dbcon'])) {
			connect_db();
		}
		$dbcon2	= $GLOBALS['dbcon'];
	}
	$time_before_sql = checkpoint();
	$result	= mysqli_query($dbcon2,$sql) or	die(db_error($sql));
	
	return $result;
}*/


// db_scalar: Updated 31 may 2006



/*function db_scalar($sql, $dbcon2 = null)
{
	if($dbcon2==''){
		if(!isset($GLOBALS['dbcon'])) {
			connect_db();
		}
		$dbcon2	= $GLOBALS['dbcon'];
	}
	$result	= mysqli_query($dbcon2,$sql) or	die(db_error($sql));
	if ($line =	mysqli_fetch_array($result))	{
		$response =	$line[0];
	}
	return $response;
}*/









// db_error: Updated 2 sep 2006
// Now it redirects to a file to show sql error.
function db_error($sql)
{
	echo "<div style='font-family: tahoma; font-size: 11px; color: #333333'><br>".mysqli_error()."<br>";
	print_error();
	if(LOCAL_MODE) {
		echo "<br>sql: $sql";
	}
	echo "</div>";
	/*
	$_SESSION['sess_sql_error'] = mysqli_error();
	header("location: ".SITE_WS_PATH."/sql_error.php");
	exit;
	*/
}

function print_error() {
	$debug_backtrace = debug_backtrace();
	for ($i = 1; $i < count($debug_backtrace); $i++) {
		$error = $debug_backtrace[$i];
		echo "<br>";
		echo "<div>";
		echo "<b>File:</b> ".$error['file']."<br>";
		echo "<b>Line:</b> ".$error['line']."<br>";
		echo "<b>Function:</b> ".$error['function']."<br>";
		//echo "<b>Args:</b> ";
		//foreach($error['args'] as $arg) {
		//	echo "$arg <br>";
		//}
		echo "</div>";
	}
}

// mysql_time: Updated 31 may 2006
function mysql_time($hour, $minute,	$ampm)
{
	if ($ampm == 'PM' && $hour != '12')	{
		$hour += 12;
	}
	if ($ampm == 'AM' && $hour == '12')	{
		$hour =	'00';
	}
	$mysql_time	= $hour	. ':' .	$minute	. ':00';
	return $mysql_time;
}

// price_format: Updated 31 may 2006
function price_format($price)
{
	if ($price != '' &&	$price != '0') {
		$price = number_format($price, 2);
		return '$'.$price;
	}
}

// date_format: Updated 31 may 2006
function date_format3($date)
{
	if (strlen($date) >= 10) {
		if ($date == '0000-00-00 00:00:00' || $date	== '0000-00-00') {
			return '';
		}
		$mktime	= mktime(0,	0, 0, substr($date,	5, 2), substr($date, 8,	2),	substr($date, 0, 4));
		return date("d/m/Y", $mktime);
	} else {
		return $s;
	}
}

// datetime_format: Updated 31 may 2006
function datetime_format($date)
{
	global $arr_month_short;
	if (strlen($date) >= 10) {
		if ($date == '0000-00-00 00:00:00' || $date	== '0000-00-00') {
			return '';
		}
		$mktime	= mktime(substr($date, 11, 2), substr($date, 14, 2), substr($date, 17, 2),substr($date,	5, 2), substr($date, 8,	2),	substr($date, 0, 4));
		return date("M j, Y h:i A ", $mktime);
	} else {
		return $s;
	}
}

// time_format: Updated 31 may 2006
function time_format($time)
{
	if (strlen($time) >= 5)	{
		$hour =	substr($time, 0, 2);
		$hour =	str_pad($hour, 2, "0", STR_PAD_LEFT);

		return $hour . ':' . substr($time, 3, 2) . ' ' . $ampm;
	} else {
		return $s;
	}
}

// ms_print_r: Updated 31 may 2006
function ms_print_r($var)
{
	//if(LOCAL_MODE || $_SESSION['debug']){
		echo "<textarea rows='10' cols='148' style='font-size: 11px; font-family: tahoma'>";
		print_r($var);
		echo "</textarea>";
	//}
}

// ms_form_value: Updated 31 may 2006

function ms_form_value($var)
{
	return is_array($var) ? array_map('ms_form_value', $var) : htmlspecialchars(stripslashes(trim($var)));
}

// ms_display_value: Updated 31 may 2006
function ms_display_value($var)
{
	return is_array($var) ? array_map('ms_display_value', $var) : nl2br(htmlspecialchars(stripslashes(trim($var))));
}

// ms_stripslashes: Updated 31 may 2006
function ms_stripslashes($var)
{
	return is_array($var) ? array_map('ms_stripslashes', $var) : stripslashes(trim($var));
}

// ms_addslashes: Updated 31 may 2006
function ms_addslashes($var)
{
	return is_array($var) ? array_map('ms_addslashes', $var) : addslashes(trim($var));
}

// ms_trim: Updated 31 may 2006
function ms_trim($var)
{
	return is_array($var) ? array_map('ms_trim', $var) : trim($var);
}

// is_image_valid: Updated 31 may 2006
function is_image_valid($file_name)
{
	global $ARR_VALID_IMG_EXTS;
	$ext = file_ext($file_name);
	if (in_array($ext, $ARR_VALID_IMG_EXTS))	{
		return true;
	} else {
		return false;
	}
}

// getmicrotime: Updated 31 may 2006
function getmicrotime()
{
	list($usec,	$sec) =	explode(" ", microtime());
	return ((float)$usec + (float)$sec);
}

// file_ext: Updated 31 may 2006
function file_ext($file_name)
{
	$path_parts = pathinfo($file_name);
	$ext = strtolower($path_parts["extension"]);
	return $ext;
}

// blank_filter: Updated 31 may 2006
function blank_filter($var)
{
	$var = trim($var);
	return ($var != '' && $var != '&nbsp;');
}

// apply_filter: Updated 25 sep 2006
function apply_filter($sql,	$field,	$field_filter, $column)
{
	if (!empty($field))	{
		if ($field_filter == "=" || $field_filter == "") {
			$sql = $sql	. "	and	$column	= '$field' ";
		} else if ($field_filter == "like")	{
			$sql = $sql	. "	and	$column	like '%$field%'	";
		} else if ($field_filter ==	"starts_with") {
			$sql = $sql	. "	and	$column	like '$field%' ";
		} else if ($field_filter ==	"ends_with") {
			$sql = $sql	. "	and	$column	like '%$field' ";
		} else if ($field_filter ==	"not_contains")	{
			$sql = $sql	. "	and	$column	not	like '%$field%'	";
		} else if ($field_filter == ">") {
			$sql = $sql . " and $column > '$field' ";
		} else if ($field_filter == "<") {
			$sql = $sql . " and $column < '$field' ";
		} else if ($field_filter ==	"!=") {
			$sql = $sql	. "	and	$column	!= '$field'	";
		}
	}
	return $sql;
}

// filter_dropdown: Updated 17 July 2006
// Should replace older version function
function filter_dropdown($name,	$sel_value)
{
    $name	= "filter";
	$arr = array( "like" => 'Contains', '=' => 'Is', "starts_with" => 'Starts with', "ends_with"	=> 'Ends with', "!=" => 'Is not' , "not_contains" => 'Not contains');
	return array_dropdown($arr, $sel_value, $name);
}

// move_up: Updated 31 may 2006
function move_up($table_name, $where_clause_all, $where_clause_item, $sort_order, $move_by)
{
	$dest_order	= $sort_order -	$move_by;
	// $arr_ids_to_move=Array();
	// echo	"<br>$movie_artist_id, $movie_id, $artistcate_id, $sort_order, $move_by, $dest_order<br>";
	for($i = $sort_order-1;	$i > $dest_order-1;	$i--) {
		$sql = " update	$table_name	set	sort_order=sort_order+1	where $where_clause_all	and	sort_order='$i'";
		// echo	"<br>$sql<br>";
		mysqli_query($sql) or die(db_error($sql));
	}
	$sql = " update	$table_name	set	sort_order=sort_order-$move_by where $where_clause_item";
	// echo	"<br>$sql<br>";
	mysqli_query($sql) or die(db_error($sql));
}

// move_down: Updated 31 may 2006
function move_down($table_name,	$where_clause_all, $where_clause_item, $sort_order,	$move_by)
{
	$dest_order	= $sort_order +	$move_by;
	// $arr_ids_to_move=Array();
	// echo	"<br>$movie_artist_id, $movie_id, $artistcate_id, $sort_order, $move_by, $dest_order<br>";
	for($i = $sort_order + 1; $i < $dest_order + 1;	$i++) {
		$sql = " update	$table_name	set	sort_order=sort_order-1	where $where_clause_all	and	sort_order='$i'	";
		// echo	"<br>$sql<br>";
		mysqli_query($sql) or die(db_error($sql));
	}
	$sql = " update	$table_name	set	sort_order=sort_order+$move_by where $where_clause_item";
	// echo	"<br>$sql<br>";
	mysqli_query($sql) or die(db_error($sql));
}

// refine_list: Updated 31 may 2006
function refine_list($id_column, $table_name, $where_clause)
{
	$sql = " select	$id_column,	sort_order from	$table_name	where $where_clause	order by sort_order";
	// echo	"<br>$sql<br>";
	$result	= mysqli_query($sql) or die(db_error($sql));
	$i = 1;
	while ($line = mysqli_fetch_array($result)) {
		$sql = " update	$table_name	set	sort_order='$i'	where $id_column='$line[0]'";
		// echo	"<br>$sql<br>";
		mysqli_query($sql) or die(db_error($sql));
		$i++;
	}
}

// make_url: Updated 31 may 2006
function make_url($url)
{
	$parsed_url	= parse_url($url);
	if ($parsed_url['scheme'] == '') {
		return 'http://' . $url;
	} else {
		return $url;
	}
}

// ms_mail: Updated 31 may 2006
function ms_mail($to, $subject, $message, $arr_headers= array())
{
	$str_headers = '';
	foreach($arr_headers as $name=>$value){
		$str_headers .= "$name: $value\r\n";
	}
	@mail($to, $subject, $message, $str_headers);
	return true;
}

// make_thumb_im: Updated 31 may 2006
function make_thumb_im($file_path, $arr_options)
{
	$width		= $arr_options['width'];
	$height		= $arr_options['height'];
	$prefix		= $arr_options['prefix'];
	$target_dir	= $arr_options['target_dir'];
	$quality	= $arr_options['quality'];
	
	$path_parts = pathinfo($file_path);

	if($width==''){
		$width = '120';
	}
	
	if($prefix=='') {
		$prefix = 'thumb_';
	}
	if($target_dir=='') {
		$target_dir = $path_parts["dirname"];
	}

	if($quality=='') {
		$quality = '70';
	}
	
	$size = @getimagesize($file_path);
	if($size=='') {
		return false;
	}
	
	/*
	$ratio = round($width/$height, 2);
	$img_width = $size[0];
	$img_height = $size[1];
	*/

	$path_parts = pathinfo($file_path);
		
	$thumb_path="$target_dir/".$prefix.$path_parts["basename"];

	$cmd ="convert -resize ".$width.'x'." -quality $quality \"$file_path\" \"$thumb_path\" ";
	system($cmd);
	//echo("<br>$cmd");
	return $prefix.$path_parts["basename"];
}

// date_to_mysql: Updated 31 may 2006
function date_to_mysql($date)
{
	list($month, $day, $year) = explode('/', $date);
	return "$year-$month-$day";
}

// export_delimited_file: Updated 31 may 2006
function export_delimited_file($sql, $arr_columns, $file_name='', $arr_substitutes='', $arr_tpls='' ){
	//session_cache_limiter('public');
	//header("Cache-Control: must-revalidate, post-check=0, pre-check=0"); 
	//header("Content-Type: application/force-download");
	if($file_name=='') {
		$file_name = time().'.txt';
	}
	header("Content-type: application/txt");
	header("Content-Disposition: attachment; filename=$file_name");
	$arr_db_cols= array_keys($arr_columns);
	$arr_headers= array_values($arr_columns);
	//ms_print_r($arr_columns);
	//ms_print_r($arr_db_cols);
	//ms_print_r($arr_headers);
	//ms_print_r($arr_headers);
	//ms_print_r($arr_headers);
	$str_columns = implode(',', $arr_db_cols);
	$sql= "select ".$str_columns." $sql" ;
	
	$result= mysqli_query($sql) or die(db_error($sql));
	$num_cols = count($arr_columns);
	//$i=0;

	foreach($arr_headers as $header){
		//$i++;
		echo $header."\t";
		//if($i!=$num_cols){
		//	echo "\t";
		//}
	}
	while($line=mysqli_fetch_array($result, MYSQL_ASSOC))
	{
		echo "\r\n";
		//echo("<br> ");
		foreach($line as $key => $value){
			$value=str_replace("\n","",$value);
			$value=str_replace("\r","",$value);
			$value=str_replace("\t","",$value);
			if(is_array($arr_substitutes[$key])){
				$value = $arr_substitutes[$key][$value];
			}
			if(isset($arr_tpls[$key])){
				$code = str_replace('{1}', $value, $arr_tpls[$key]);
				//echo ("\$value = $code;");
				//echo("<br>");
				eval ("\$value = $code;");
			}
			echo $value."\t";
		}
	}
}

// checkpoint: Updated 2 sep 2006
// to check how much time is lapsed before first call of this function
function checkpoint($from_start = false)
{
	global $PREV_CHECKPOINT;
	if($PREV_CHECKPOINT==''){
		$PREV_CHECKPOINT = SCRIPT_START_TIME;
	}
	$cur_microtime = getmicrotime();
	
	if($from_start) {
		return $cur_microtime - SCRIPT_START_TIME;
	} else {
		$time_taken = $cur_microtime - $PREV_CHECKPOINT;
		$PREV_CHECKPOINT = $cur_microtime;
		return $time_taken;
	}
}

// readable_col_name: Updated 31 may 2006
function readable_col_name($str) 
{
	return ucwords( str_replace('_', ' ', strtolower($str) ) );
}

// ms_echo: Updated 31 may 2006
function ms_echo($str) {
	if(LOCAL_MODE){
		echo($str);
	}
}

// make_dropdown: Updated 1 aug 2006
function make_dropdown($sql, $combo_name, $sel_value =	'',	$extra = '', $choose_one = '')
{
	$result	= db_query($sql) or die(db_error($sql));
 	if (mysqli_num_rows($result)	> 0) {
		$str_dropdown = "<select name='$combo_name' id='$combo_name' $extra>";
		if(is_array($choose_one)) {
			foreach($choose_one as $key => $value) {
				$str_dropdown .= "<option value='$key '>$value</option>";
			}
		} else if ($choose_one	!= '') {
			$str_dropdown .= "<option value=''>$choose_one</option>";
		}
 		while	($line = mysqli_fetch_array($result)) {
			// if($css== "opt1"){ $css='opt2';}else{$css='opt1';};
			$str_dropdown .= "<option value=\"" . ms_form_value($line[0]) . "\"";
			if(is_array($sel_value)) {
				if (in_array($line[0], $sel_value )) {
					$str_dropdown .= "	selected ";
				}
			} else {
			if ($sel_value == $line[0])	{
				$str_dropdown .= "	selected ";
			}
			}
			$str_dropdown .= ">" .	$line[1] . "</option>";
		}
		$str_dropdown .= "</select>";
 	}
	return $str_dropdown;
}

// array_dropdown: Updated 31 may 2006
function array_dropdown( $arr, $sel_value='', $name='', $extra='class=Arila-12-black', $choose_one='', $arr_skip= array())
{
	$combo="<select name='$name' id='$name' $extra >";
	if($choose_one!=''){
		$combo.="<option value=\"\">$choose_one</option>";
	}
	foreach($arr as $key => $value)
	{
		if(is_array($arr_skip) && in_array($key, $arr_skip)) {
			continue;
		}
		$combo.='<option value="'.htmlspecialchars($key).'"';
		if(is_array($sel_value)) {
			if(in_array($key, $sel_value) || in_array(htmlspecialchars($key), $sel_value)) {
				$combo.=" selected ";
			}
		} else {
			if($sel_value==$key || $sel_value==htmlspecialchars($key)) {
				$combo.=" selected ";
			}
		}
		$combo.=" >$value</option>";
	}
	$combo.=" </select>";
	return $combo;
}

// make_checkboxes: Updated 31 may 2006
function make_checkboxes($manutmp, $checkname, $checksel , $cols,	$missit, $style	, $tableattr )
{
	if ($style != "") {
		$style = "class='" . $style	. "'";
	}

	$colwidth =	100	/ $cols;
	$colwidth =	round($colwidth, 2);
	$j = 0;
	/*
	$manutmp['Any']="Any";
	if($checksel==''){
		$checksel=Array("Any");
	}
	*/
	foreach($manutmp as	$key =>	$value)	{
		$tochecked = "";
		if (is_array($checksel)	&& in_array($key, $checksel)) {
			$tochecked = "checked";
		}
		if ($key !=	$missit) {
			if ($value != "") {
				if ($j == 0) {
					$checkstr .= "<table $tableattr><tr>\n";
				} else if (($j % $cols)	== 0) {
					$checkstr .= "</tr><tr>\n";
				}
				$checkstr .= "<td valign=top><INPUT TYPE='checkbox' $javascript	 NAME='$checkname" . '[]' .	"' value='$key'	$tochecked ></td><td $style nowrap> $value	</td>\n";
				$j++;
			}
		}
	}
	$j--;
	// echo	"$cols-($j%$cols)=".$cols-($j%$cols);
	// echo	"<BR>($j%$cols)=".($j%$cols);
	for($x = $j	% $cols;$x < 4;$x++) {
		if ($x != 3) {
			$checkstr .= "<td>&nbsp;</td>\n";
		} else {
			$checkstr .= "<td>&nbsp;</td></tr>\n";
		}
	}
	$checkstr .= "</table>";
	return $checkstr;
}

// make_radios: Updated 31 may 2006
function make_radios($manutmp, $checkname, $checksel , $cols,	$missit, $style	, $tableattr )
{
	if ($style != "") {
		$style = "class='" . $style	. "'";
	}

	$colwidth =	100	/ $cols;
	$colwidth =	round($colwidth, 2);
	$j = 1;
	/*
	$manutmp['Any']="Any";
	if($checksel==''){
		$checksel=Array("Any");
	}
	*/
	foreach($manutmp as	$key =>	$value)	{
		$tochecked = "";
		if ($checksel == $key) {
			$tochecked = "checked";
		}
		if ($key !=	$missit) {
			if ($value != "") {
				if ($j == 1) {
					$checkstr .= "<table $tableattr><tr>\n";
				} else if (($j % $cols)	== 1) {
					$checkstr .= "</tr><tr>\n";
				}
				$checkstr .= "<td width='" . $colwidth . "%' $style	valign=top><INPUT TYPE='radio' $javascript	 NAME='$checkname' value='$key'	$tochecked	   > $value	</td>\n";
				$j++;
			}
		}
	}
	$j--;
	// echo	"$cols-($j%$cols)=".$cols-($j%$cols);
	// echo	"<BR>($j%$cols)=".($j%$cols);
	for($x = $j	% $cols;$x < 4;$x++) {
		if ($x != 3) {
			$checkstr .= "<td>&nbsp;</td>\n";
		} else {
			$checkstr .= "<td>&nbsp;</td></tr>\n";
		}
	}
	$checkstr .= "</table>";
	return $checkstr;
}

// date_dropdown: Updated 31 may 2006
function date_dropdown($pre, $selected_date = '', $start_year='', $end_year = '', $sort = 'asc')
{
	$cur_date =	date("Y-m-d");
	$cur_date_day =	substr($cur_date, 8, 2);
	$cur_date_month	= substr($cur_date,	5, 2);
	$cur_date_year = substr($cur_date, 0, 4);

	if ($selected_date != '') {
		$selected_date_day = substr($selected_date,	8, 2);
		$selected_date_month = substr($selected_date, 5, 2);
		$selected_date_year	= substr($selected_date, 0,	4);
	}
	$date_dropdown	.= month_dropdown($pre	. "month", $selected_date_month);
	$date_dropdown	.= day_dropdown($pre .	"day", $selected_date_day);
	// echo($pre . "year: ". $selected_date_year);
	$date_dropdown	.= year_dropdown($pre . "year", $selected_date_year, $start_year,	$end_year,	$sort);
	return $date_dropdown;
}

// month_dropdown: Updated 31 may 2006
function month_dropdown($name,	$selected_date_month = '', $extra='')
{
	global $ARR_MONTHS;

	$date_dropdown	= "	<select	name='$name' $extra> <option value='0'>Month</option>";
	$i = 0;
	foreach ($ARR_MONTHS as $key => $value) {
		$date_dropdown	.= " <option ";
		if ($key == $selected_date_month)	{
			$date_dropdown	.= " selected ";
		}
		$date_dropdown	.= " value='" .	str_pad($key, 2, "0",	STR_PAD_LEFT) .	"'>$value</option>";
	}
	$date_dropdown	.= "</select>";
	return $date_dropdown;
}

// day_dropdown: Updated 31 may 2006
function day_dropdown($name, $selected_date_day = '', $extra='')
{
	$date_dropdown	.= "<select	name='$name' $extra>";
	$date_dropdown	.= "<option	value='0'>Date</option>";
	for($i = 1;$i <= 31;$i++) {
		//$s = date('S', mktime(1, 0,	0, 3, $i, 1970));
		$date_dropdown	.= " <option ";
		if ($i == $selected_date_day) {
			$date_dropdown	.= " selected ";
		}
		$date_dropdown	.= " value='" .	str_pad($i,	2, "0",	STR_PAD_LEFT) .	"'>" . $i .	$s . "</option>";
	}
	$date_dropdown	.= "</select>";
	return $date_dropdown;
}

// year_dropdown: Updated 31 may 2006
function year_dropdown($name, $selected_date_year = '', $start_year =	'',	$end_year = '', $extra='')
{
	if ($start_year	== '') {
		$start_year	= DEFAULT_START_YEAR;
	}
	
	if ($end_year == '') {
		$end_year =	DEFAULT_END_YEAR;
	}

	$date_dropdown	.= "<select	name='$name' $extra>";
	$date_dropdown	.= "<option	value='0'>Year</option>";

	for($i = $start_year; $i <= $end_year; $i++) {
		$date_dropdown	.= " <option ";
		if ($i == $selected_date_year) {
			$date_dropdown	.= " selected ";
		}
		$date_dropdown	.= " value='" .	str_pad($i,	2, "0",	STR_PAD_LEFT) .	"'>" . str_pad($i, 2, "0", STR_PAD_LEFT) .	"</option>";
	}
	$date_dropdown	.= "</select>";
	return $date_dropdown;
}

// time_dropdown: Updated 31 may 2006
function time_dropdown($pre, $selected_time = '')
{
	// echo("<br>selected_time:$selected_time");
	if ($selected_time != '' &&	$selected_time != ':') {
		$selected_hour = substr($selected_time,	0, 2);
		$selected_minute = substr($selected_time, 3, 2);
		/*
		if($selected_hour >11){
			$selected_ampm = "PM";
			$selected_hour -= 12;
		}else{
			$selected_ampm = "AM";
		}
		if($selected_hour==0){
			$selected_hour = 12;
		}
		*/
	}
	$str .= hour_dropdown($pre, $selected_hour);
	$str .= '<b>:</b>';
	$str .= minute_dropdown($pre, $selected_minute);
	return $str;
	// echo	"<br>$selected_hour, $selected_minute $selected_ampm <br>";
}

// hour_dropdown: Updated 31 may 2006
function hour_dropdown($pre, $selected_hour )
{
	$str .= "<select	name='"	. $pre . "hour'>";
	$str .= "<option	value=''>Hour</option>";
	for($i = 0;	$i <= 23; $i++)	{
		$str .= " <option ";
		if ($i == $selected_hour &&	$selected_hour != '') {
			$str .= " selected ";
		}
		$str .= " value='" .	str_pad($i,	2, "0",	STR_PAD_LEFT) .	"'>" . str_pad($i, 2, "0", STR_PAD_LEFT) .	"</option>";
	}
	$str .= "</select>";
	return $str;
}

// minute_dropdown: Updated 31 may 2006
function minute_dropdown($pre, $selected_minute )
{
	$str .= "<select	name='"	. $pre . "minute'>";
	$str .= "<option	value=''>Minute</option>";
	for($i = 0;	$i <= 59; $i = $i +	15)	{
		$str .= " <option ";
		if (str_pad($i,	2, "0",	STR_PAD_LEFT) === strval($selected_minute))	{
			$str .= " selected ";
		}
		$str	.= " value='" .	str_pad($i,	2, "0",	STR_PAD_LEFT) .	"'>" . str_pad($i, 2, "0", STR_PAD_LEFT) .	"</option>";
	}
	$str .= "</select>";
	return $str;
}

// ampm_dropdown: Updated 31 may 2006
function ampm_dropdown($pre, $selected_ampm)
{
	$str .= "<select name='" . $pre . "ampm'>";
	$str .= " <option ";
	if ($selected_ampm=='AM') {
		$str .= " selected ";
	}
	$str .= " value='AM'>AM</option>";
	$str .= " <option ";
	if ($selected_ampm=='PM') {
		$str	.= " selected ";
	}
	$str .= " value='PM'>PM</option>";
	$str .= "</select>";
	return $str;
}

// get_qry_str: Updated 31 may 2006
function get_qry_str($over_write_key = array(),	$over_write_value =	array())
{
	global $_GET;
	$m = $_GET;
	if (is_array($over_write_key)) {
		$i = 0;
		foreach($over_write_key	as $key) {
			$m[$key] = $over_write_value[$i];
			$i++;
		}
	} else {
		$m[$over_write_key]	= $over_write_value;
	}
	$qry_str = self::qry_str($m);
	return $qry_str;
}

// qry_str: Updated 31 may 2006
function qry_str($arr, $skip = '')
{
	$s = "?";
	$i = 0;
	foreach($arr as	$key =>	$value)	{
		if ($key !=	$skip) {
			if (is_array($value)) {
				foreach($value as $value2) {
					if ($i == 0) {
						$s .= $key . '[]=' . $value2;
						$i = 1;
					} else {
						$s .= '&' .	$key . '[]=' . $value2;
					}
				}
			} else {
				if ($i == 0) {
					$s .= "$key=$value";
					$i = 1;
				} else {
					$s .= "&$key=$value";
				}
			}
		}
	}
	return $s;
}






// check_radio: Updated 31 may 2006
function check_radio($s, $s2)
{
	if (is_array($s2)) {
		// echo("<br>$s");
		// print_r($s2);
		if (in_array($s, $s2)) {
			return " checked ";
		}
	} else if ($s == $s2) {
		return " checked ";
	}
}

// sort_arrows: Updated 31 may 2006
function sort_arrows($column)
{
	//return '<A HREF="' . $_SERVER['PHP_SELF'] .	get_qry_str(array('order_by', 'order_by2'),	array($column, 'asc')) . '"><img src="'.SITE_WS_PATH.'/images/up_arrow.gif" border="0"></a>	<a href="'	. $_SERVER['PHP_SELF'] . get_qry_str(array('order_by', 'order_by2'), array($column,	'desc')) . '"><img src="'.SITE_WS_PATH.'/images/down_arrow.gif" border="0"></a>';
	return '<A HREF="' . $_SERVER['PHP_SELF'] .	get_qry_str(array('order_by', 'order_by2'),	array($column, 'asc')) . '"><img src="images/icons/up_arrow.gif" border="0"></a>	<a href="'	. $_SERVER['PHP_SELF'] . get_qry_str(array('order_by', 'order_by2'), array($column,	'desc')) . '"><img src="images/icons/down_arrow.gif" border="0"></a>';
}

// select_option: Updated 31 may 2006
function select_option($s, $s1)
{
	if ($s == $s1) {
		echo " selected	";
	}
}

// -----------------------------------------------------


/* Sample
function cuisine_checkbox($checkname = 'cuisines', $checksel = '', $cols = '4',	$missit	= '', $style = '',	$tableattr = '')
{
	$manutmp = Array();
	$sql = " select	cuisine_name, cuisine_name from	grabit_cuisine order by	cuisine_name";
	$result	= mysqli_query($sql) or die(db_error($sql));
	while ($line = mysqli_fetch_array($result)) {
		$ms_tmp[$line['cuisine_name']] = $line['cuisine_name'];
	}
	return make_checkbox($ms_tmp, $checkname, $checksel, $cols,	$missit, $style, $tableattr);
}
*/

// is_post_back: Updated 31 may 2006
function is_post_back(){
	if(count($_POST)>0) {
		return true;
	} else {
		return false;
	}
	/*
	$cur_page = $_SERVER['REQUEST_URI'];
	$q_pos = strpos($cur_page, '?');
	if($q_pos!==false) {
		$cur_page = substr($cur_page, 0 , $q_pos);
	}

	$parsed_url = parse_url($_SERVER['HTTP_REFERER']);
	$referer = $parsed_url['path'];
//echo "<br>referer: ".$referer;
//echo "<br>cur_page: ".$cur_page;
	if(strtolower($_SERVER['REQUEST_METHOD'])=='post' && $referer == $cur_page) {
		return true;	
	} else {
		return false;	
	}
	*/
}

// request_to_hidden: Updated 31 may 2006
function request_to_hidden($arr_skip='') 
{
	foreach($_REQUEST as $name => $value) {
		$s .= '<input type="hidden" name="'.$name.'" value="'.htmlspecialchars(stripslashes($value)).'">'."\n";
	}
	return $s;
}

// sql_to_array_file: Updated 31 may 2006
function sql_to_array_file($arr_name, $sql, $file, $full_table=false)
{
	$str = "<?\n";
	$result = mysqli_query($sql) or die(db_error($sql));
	while ($line = mysqli_fetch_array($result)) {
		$line = ms_addslashes($line);
		if($full_table) {
			$key = $line[0];
			foreach($line as $name=>$value) {
				if(!is_numeric($name)) {
					$str .= '$'.$arr_name."['".$key."']['".$name."'] = '".$value."';\n";
				}
			}
			$str .= "\n";
		} else {
			$str .= '$'.$arr_name."['".$line[0]."'] = '".$line[1]."';\n";
		}
	}
	$str .= "\n?>";

	$fh = fopen($file, 'w');
	fwrite($fh, $str);
	fclose($fh);
	return true;
}

// array_radios: Updated 31 may 2006
function array_radios($arr, $sel_value = '', $name = '', $cols = 3, $extra = '')
{
	if ($style != "") {
		$style = "class='" . $style . "'";
	} 

	$colwidth = 100 / $cols;
	$colwidth = round($colwidth, 2);
	$j = 1;
	/*
	$manutmp['Any']="Any";
	if($checksel==''){
		$checksel=Array("Any");
	}
	*/
	foreach($arr as $key => $value) {
		$tochecked = "";
		if (is_array($sel_value) && in_array($key, $sel_value)) {
			$tochecked = "checked";
		} 
		if ($key != $missit) {
			if ($value != "") {
				if ($j == 1) {
					$checkstr .= "<table $tableattr><tr>\n";
				} else if (($j % $cols) == 1 || $cols==1) {
					$checkstr .= "</tr><tr>\n";
				} 

				$checkstr .= "<td width='" . $colwidth . "%' $style valign=top><INPUT TYPE='radio' $javascript  NAME='$name' value='$key' $tochecked     > $value </td>\n";
				$j++;
			} 
		} 
	} 
	$j--; 
	// echo "$cols-($j%$cols)=".$cols-($j%$cols);
	// echo "<BR>($j%$cols)=".($j%$cols);
	for($x = $j % $cols;$x < 4;$x++) {
		if ($x != 3) {
			$checkstr .= "<td>&nbsp;</td>\n";
		} else {
			$checkstr .= "<td>&nbsp;</td></tr>\n";
		} 
	} 
	$checkstr .= "</table>";
	return $checkstr;
} 

// Updated 24 aug 2006
function make_thumb_gd($imgPath, $destPath, $newWidth, $newHeight, $ratio_type = 'width', $quality = 70, $verbose = false)
{ 
	// options for ratio type = width|height|width_height|distort|crop

	// get image info (0 width and 1 height, 2 is (1 = GIF, 2 = JPG, 3 = PNG)
	$size = getimagesize($imgPath); 
	// break and return false if failed to read image infos
	if (!$size) {
		if ($verbose) {
			echo "Unable to read image info.";
		}
		return false;
	} 
	$curWidth	= $size[0];
	$curHeight	= $size[1];
	$fileType	= $size[2];
	
	// width/height ratio
	$ratio =  $curWidth / $curHeight;
	$thumbRatio = $newWidth / $newHeight;

	$srcX = 0;
	$srcY = 0;
	$srcWidth = $curWidth;
	$srcHeight = $curHeight;

	if($ratio_type=='width_height') {
		$tmpWidth	= $newHeight * $ratio;
		if($tmpWidth > $newWidth) {
			$ratio_type='width';
		} else {
			$ratio_type='height';
		}
	}


	if($ratio_type=='width') {
		// If the dimensions for thumbnails are greater than original image do not enlarge
		if($newWidth > $curWidth) {
			$newWidth = $curWidth;
		}
		$newHeight	= $newWidth / $ratio;
	} else if($ratio_type=='height') {
		// If the dimensions for thumbnails are greater than original image do not enlarge
		if($newHeight > $curHeight) {
			$newHeight = $curHeight;
		}
		$newWidth	= $newHeight * $ratio;
	} else if($ratio_type=='crop') {
		if($ratio < $thumbRatio) {
			$srcHeight = round($curHeight*$ratio/$thumbRatio);
			$srcY = round(($curHeight-$srcHeight)/2);
		} else {
			$srcWidth = round($curWidth*$thumbRatio/$ratio);
			$srcX = round(($curWidth-$srcWidth)/2);
		}
		/*echo "<br>curWidth: $curWidth";
		echo "<br>curHeight: $curHeight";
		echo "<br>newWidth: $newWidth";
		echo "<br>newHeight: $newHeight";
		echo "<br>ratio: $ratio";
		echo "<br>thumbRatio: $thumbRatio";
		echo "<br>srcWidth: $srcWidth";
		echo "<br>srcX: $srcX";
		echo "<br>srcHeight: $srcHeight";
		echo "<br>srcY: $srcY";*/
	} else if($ratio_type=='distort') {
	}
	
	// create image
	switch ($fileType) {
		case 1:
			if (function_exists("imagecreatefromgif")) {
				$originalImage = imagecreatefromgif($imgPath);
			} else {
				if ($verbose) {
					echo "GIF images are not support in this php installation.";
					return false;
				}
			} 
			$fileExt = 'gif';
			break;
		case 2: 
			$originalImage = imagecreatefromjpeg($imgPath);
			$fileExt = 'jpg';
			break;
		case 3: 
			$originalImage = imagecreatefrompng($imgPath);
			$fileExt = 'png';
			break;
		default:
			if ($verbose) {
				echo "Not a valid image type.";
			}
			return false;
	} 
	// create new image

	$resizedImage = imagecreatetruecolor($newWidth, $newHeight);
	//echo "$srcX, $srcY, $newWidth, $newHeight, $curWidth, $curHeight";
	//echo "<br>$srcX, $srcY, $newWidth, $newHeight, $srcWidth, $srcHeight<br>";
	imagecopyresampled($resizedImage, $originalImage, 0, 0, $srcX, $srcY, $newWidth, $newHeight, $srcWidth, $srcHeight);
	imageinterlace($resizedImage, 1);
	switch ($fileExt) {
		case 'gif':
			imagegif($resizedImage, $destPath, $quality);
			break;
		case 'jpg': 
			imagejpeg($resizedImage, $destPath, $quality);
			break;
		case 'png': 
			imagepng($resizedImage, $destPath, $quality);
			break;
	} 
	// return true if successfull
	return true;
} 

// show_thumb: Updated 6 feb 2007
function show_thumb($file_org, $width, $height, $ratio_type = 'width')
{
	$file_fs_path = str_replace(SITE_WS_PATH, SITE_FS_PATH, $file_org);

	$file_name = str_replace(SITE_WS_PATH."/", "", $file_org);
	$file_name = str_replace("/", "^", $file_name);
	$cache_file = $width."x".$height.'__'.$ratio_type.'__'.filemtime($file_fs_path).'__'.$file_name;
	if(!is_file(SITE_FS_PATH."/".THUMB_CACHE_DIR."/".$cache_file)) {
		make_thumb_gd($file_fs_path, SITE_FS_PATH."/".THUMB_CACHE_DIR."/".$cache_file, $width, $height, $ratio_type );
	}	
	return SITE_WS_PATH."/".THUMB_CACHE_DIR."/".$cache_file;
}

// ms_parse_keywords: Updated 31 may 2006
// Temporary function. Need to be made more elegant or replace with regular expression
function ms_parse_keywords($keywords)
{
	$arr_keywords = array();
	$dq_end =true;
	$sp_end = true;
	for ($i=0;$i<strlen($keywords);$i++) {
		//echo "<br>cur_token:$cur_token, cur_keyword:$cur_keyword, dq_start:$dq_start, dq_end:$dq_end, sp_start:$sp_start, sp_end:$sp_end,";
		$cur_token = $keywords[$i];
		if($cur_token=='"') {
			if($dq_start) {
				$dq_end = true;
				$dq_start = false;
				$arr_keywords[] = $cur_keyword;
				$cur_keyword = '';
			} else if($dq_end) {
				$dq_end = false;
				$dq_start = true;
				$sp_start = false;
			} else {
				$dq_end = false;
				$dq_start = true;
			}
		} else if($cur_token==' ') {
			if($sp_start || $dq_end) {
				$sp_end = true;
				$sp_start = false;
				$arr_keywords[] = $cur_keyword;
				$cur_keyword = '';
			} else if($sp_end && !$dq_start) {
				$sp_end = false;
				$sp_start = true;
			} else if($dq_start) {
				$cur_keyword .= $cur_token;
			}
		} else {
			$cur_keyword .= $cur_token;
		}
	}

	$arr_keywords[] =$cur_keyword;
	return $arr_keywords;
}


// pagesize_dropdown: Updated 31 may 2006
function pagesize_dropdown($name, $value)
{
	$arr = array(''=>'select','10'=>'10','25'=>'25','50'=>'50','100'=>'100');
	$m = $_GET;
	unset($m['pagesize']);
	return $this->array_dropdown($arr, $value , $name, '  onchange="location.href=\''.$_SERVER['PHP_SELF']. $this->qry_str($m).'&pagesize=\'+this.value" ');
}



// sql_to_assoc_array: Updated 1 aug 2006
function sql_to_assoc_array($sql)
{
	$arr = array();
	$result = mysqli_query($sql) or die(db_error($sql));
	while ($line = mysqli_fetch_array($result)) {
		$line = ms_form_value($line);
		$arr[$line[0]] = $line[1];
	}
	return $arr;
}


// sql_to_index_array: Updated 1 aug 2006
function sql_to_index_array($sql)
{
	$arr = array();
	$result = mysqli_query($sql) or die(db_error($sql));
	while ($line = mysqli_fetch_array($result)) {
		$line = ms_form_value($line);
		$arr[] = $line[0];
	}
	return $arr;
}

// sql_to_array: Updated 1 aug 2006
function sql_to_array($sql)
{
	$arr = array();
	$result = mysqli_query($sql) or die(db_error($sql));
	while ($line = mysqli_fetch_array($result)) {
		$line = ms_form_value($line);
		array_push($arr, $line);
	}
	return $arr;
}

// get_unique_file_name: Updated 2 aug 2006
function get_unique_file_name($file_name)
{
	return str_shuffle(md5(uniqid(rand(), true))) . '.' . file_ext($file_name);
}

function qry_str_to_hidden($str)
{
	$fields='';
	if(substr($str,0,1)=='?') {
		$str = substr($str,1);
	}
	$arr = explode('&', $str);
	foreach($arr as $pair) {
		list($name, $value) = explode('=',$pair);
		if($name!='') {
			$fields.='<input type="hidden" name="'.$name.'" id="'.$name.'" value="'.$value.'" />';
		}
	}
	return $fields;
}

// enum_to_array: Updated 14 sep 2006

function enum_to_array($table, $column)
{
	$result = mysqli_query("show fields from $table") or die("Query failed: " . mysqli_error()); 
	while ($line_raw = mysqli_fetch_assoc($result)) {
		$line = ms_display_value($line_raw);
		if($line['Field']==$column) {
			$Type = $line['Type'];
			$Type = substr($Type,6,-2);
			$arr_tmp = explode("','", $Type);
			foreach($arr_tmp as $val) {
				$arr[$val]=$val;
			}
			return $arr;
		}
	}
}
function uploafilesection($filefieldName, $filepath)
{   
    		$fileName=$_FILES[$filefieldName]['name'];				
			$fileType = $_FILES[$filefieldName]['type'];
			$fileTemp = $_FILES[$filefieldName]['tmp_name'];
			$fileError = $_FILES[$filefieldName]['error'];
			$destFile = date('dMYhms').$fileName;
			
			$destLoc = $filepath."".$destFile;
			move_uploaded_file($_FILES[$filefieldName]['tmp_name'],$destLoc);
			return $destFile;
}
#####################################################################################################


/*function currencyConverter($fromCurrency,$toCurrency,$amount) {
$fromCurrency = urlencode($fromCurrency);
$toCurrency = urlencode($toCurrency);
$url = "https://www.google.com/search?q=".$fromCurrency."+to+".$toCurrency;
$get = file_get_contents($url);
$data = preg_split('/\D\s(.*?)\s=\s/',$get);
$exhangeRate = (float) substr($data[1],0,7);
$convertedAmount = $amount*$exhangeRate;
$data = array( 'exhangeRate' => $exhangeRate, 'convertedAmount' =>$convertedAmount, 'fromCurrency' => strtoupper($fromCurrency), 'toCurrency' => strtoupper($toCurrency));
//echo json_encode(  );
return $data;
}*/


function currencyConverter($from, $to, $amount){
	
	$url = "https://www.google.com/search?q=".$from.$to;
    $request = curl_init();
    $timeOut = 0;
    curl_setopt($request, CURLOPT_URL, $url);
    curl_setopt($request, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($request, CURLOPT_USERAGENT, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36");
    curl_setopt($request, CURLOPT_CONNECTTIMEOUT, $timeOut);
    $response = curl_exec($request);
    curl_close($request);

    preg_match('~<span [^>]* id="knowledge-currency__tgt-amount"[^>]*>(.*?)</span>~si', $response, $finalData);
    $finalData=str_replace(',', '.', $finalData);
    return (float)$finalData[1]*$amount;
	
}
function randomPassword() {
    $alphabet = 'ABCDEFGHIJKLMNPQRSTUVWXYZ123456789';
    $pass = array(); //remember to declare $pass as an array
    $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    for ($i = 0; $i < 8; $i++) {
        $n = rand(0, $alphaLength);
        $pass[] = $alphabet[$n];
    }
    return implode($pass); //turn the array into a string
}


function uniqueKEY() {
    $alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz';
    $pass = array(); //remember to declare $pass as an array
    $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    for ($i = 0; $i < 8; $i++) {
        $n = rand(0, $alphaLength);
        $pass[] = $alphabet[$n];
    }
    return implode($pass); //turn the array into a string
}
#######################################################################################################
function getIDcategory($maincate_id){
		if(is_array($maincate_id)){		
			  $count = count($maincate_id);		
			  $RandVal = rand(0,$count-1);
			  return $main_id = $maincate_id[$RandVal];
	}
	
}
#################################################################### SEO friendly URL ######################################
function seo_friendly_url($string){
    $string = str_replace(array('[\', \']'), '', $string);
    $string = preg_replace('/\[.*\]/U', '', $string);
    $string = preg_replace('/&(amp;)?#?[a-z0-9]+;/i', '-', $string);
    $string = htmlentities($string, ENT_COMPAT, 'utf-8');
    $string = preg_replace('/&([a-z])(acute|uml|circ|grave|ring|cedil|slash|tilde|caron|lig|quot|rsquo);/i', '\\1', $string );
    $string = preg_replace(array('/[^a-z0-9]/i', '/[-]+/') , '-', $string);
    return strtolower(trim($string, '-'));
}
#################################################################### SEO friendly Table name ######################################
function seo_friendly_url_TABLE($string){
    $string = str_replace(array('[\', \']'), '', $string);
    $string = preg_replace('/\[.*\]/U', '', $string);
    $string = preg_replace('/&(amp;)?#?[a-z0-9]+;/i', '_', $string);
    $string = htmlentities($string, ENT_COMPAT, 'utf-8');
    $string = preg_replace('/&([a-z])(acute|uml|circ|grave|ring|cedil|slash|tilde|caron|lig|quot|rsquo);/i', '\\1', $string );
    $string = preg_replace(array('/[^a-z0-9]/i', '/[-]+/') , '_', $string);
    return strtolower(trim($string, '_'));
}

#########################################  SMTP EMAIL  #########################################
function spMail($subjects, $message, $tomail, $ccmail, $bccmail,  $naam, $attach = false){

$userId = 'tpp@wfp.sams.co.in';
$userPass = 'klG84Z+WRKZ)Bl0c';
$setFrom  = 'tpp@wfp.sams.co.in';

$setName  = "SAMS";
$mail = new PHPMailer();
$mail->IsSMTP();
$mail->SMTPAuth = true;
// $mail->SMTPDebug = SMTP::DEBUG_SERVER;
// $mail->SMTPDebug = 2; //Alternative to above constant
//$mail->SMTPSecure = "ssl"; 
//$mail->Host = "mail.drbidsams.com"; 
$mail->Port =  587; 
$mail->Host = "sams.datameter.net"; 
//$mail->Port =  495;


$mail->SMTPOptions = array(
    'ssl' => array(
        'verify_peer' => false,
        'verify_peer_name' => false,
        'allow_self_signed' => true
    )
);
$mail->isHTML(true);// Set email format to HTML
$mail->MsgHTML('HTML code');// Message body
$mail->SMTPSecure = false;
$mail->SMTPAutoTLS = false;




$mail->Username   = $userId;   
$mail->Password   = $userPass;

$mail->Subject = $subjects;
$mail->MsgHTML($message);
//send to mail id and added name
//send to mail id and added name
//foreach($tomail as $tosignature=>$tomailid){
//echo $tomailid.'==='.$tosignature;

$mail->SetFrom($setFrom,$setName);
$mail->AddAddress($tomail, $naam);

//$mail->AddReplyTo('tpp-nen-ai@sams.co.in', 'nen-ai');



//} 
///echo "in"; die;
// for multiple ccmail id with added name
if(!empty($ccmail)){
	foreach($ccmail as $ccsignature => $ccmailid){
	//$mail->AddCC($ccmailid, $ccsignature);
	$mail->AddCC($ccmailid);
 }
}
// For BCC mail id
if(!empty($bccmail)){
	foreach($bccmail as $bccsignature  =>  $bccmailid){
	 $mail->AddBCC($bccmailid, $bccsignature);
	}
}
if(!empty($attach)){
	foreach($attach as $fileat){
	$mail->addAttachment($fileat);
	} 
}
$mail->Send();  
}
#####################################################################################################



######################################################

###################################################################
function check_table_exist_or_not($tblName){
                $table_name           = DB.$tblName;					
				$arrayval             = self::showTable($table_name);	
				return $arrayval;	
}


################################# get count feilds ##########################
function getCountData($tblname,$flds,$condtion){
                       $table_name           =  DB.$tblname;	
				$where                =  $flds."=:".$flds;	
				$bind                 =  array(":".$flds.""=>$condtion);		
				$rowCount             =  self::selectCount($table_name,$where,$bind);
				$num                  =  $rowCount[0]['count(*)'];
				return $num;	
}

############################### file upload ###############################################	

function uploadFiles($postFileName,$postFileSize,$postfileTemp,$folderPath){
	
	if($postFileName!=''){	
	
			$allowedExts = array("gif", "jpeg", "jpg", "png","pdf","txt","doc","docx","xls","xlsx");
			$extension = end(explode(".", $postFileName));
			$fileName=$postFileName;
			if (in_array($extension, $allowedExts)  && $postFileSize < 1000000){
			  $destFile = date('dMYhms').rand(10,100000).$fileName;			
			  $destLoc = '../uploads/'.$folderPath.'/'.$destFile;			
			  move_uploaded_file($postfileTemp,$destLoc);
            }
			return $destFile;
	}

}

############################### file upload ###############################################	

function uploadFilesExactPath($postFileName,$postFileSize,$postfileTemp,$folderPath){
	
	if($postFileName!=''){	
	
			$allowedExts = array("gif", "jpeg", "jpg", "png","pdf","txt","doc","docx","zip","xlsx");
			$extension = end(explode(".", $postFileName));
			$fileName=str_replace(' ','_',$postFileName);
			 
			if (in_array($extension, $allowedExts)  && $postFileSize < 1000000){
			  $destFile = date('dMYhms').rand(10,100000).$fileName;			
			  $destLoc = $folderPath.'/'.$destFile;			
			  move_uploaded_file($postfileTemp,$destLoc);
            }
			return $destFile;
	}

}
############################### file upload  uploadFilesSingContractImg #################

function uploadFilesSingContractImg($postFileName,$postFileSize,$postfileTemp,$folderPath){
	
	if($postFileName!=''){	
	
			$allowedExts = array( "jpeg", "jpg", "png");
			$extension = end(explode(".", $postFileName));
			$fileName=$postFileName;
			if (in_array($extension, $allowedExts)  && $postFileSize < 1000000){
			  $destFile = date('dMYhms').rand(10,100000).$fileName;			
			  $destLoc = '../uploads/'.$folderPath.'/'.$destFile;			
			  move_uploaded_file($postfileTemp,$destLoc);
            }
			return $destFile;
	}

}

####################  Admin Backend orderBy  #######################################################################################

function fununiversalOrderBy($tblName,$getdata,$colName,$condition, $orderBy, $orderType){

                $table_name           =  DB.$tblName;	
				$where                =  $colName."=:".$colName ." order by ".$orderBy." ".$orderType;	
				$bind                 =  array(":".$colName=>$condition);		
				$rowData              =  self::select($table_name,$where,$bind,$getdata);											
				$row  				  =  $rowData[0];
				return $row[$getdata];	
}
#######################################################################################

function fununiversalOrderBy2Cond($tblName,$getdata,$colName,$condition,$colName2,$condition2, $orderBy, $orderType){

                $table_name           =  DB.$tblName;	
			   $where                =  $colName."=:".$colName.' AND '.$colName2.$condition2."  order by ".$orderBy." ".$orderType;	
				$bind                 =  array(":".$colName=>$condition);		
				$rowData              =  self::select($table_name,$where,$bind,$getdata);											
				$row  				  =  $rowData[0];
				return $row[$getdata];	
}

#######################################################################################

function funu($tblName,$getdata,$colName,$condition,$colName2,$condition2, $orderBy, $orderType){

                $table_name           =  DB.$tblName;	
			$where           =  $colName."=:".$colName.' AND '.$colName2.' IN ('.$condition2.')'." order by ".$orderBy." ".$orderType;	
				$bind                 =  array(":".$colName=>$condition);		
				$rowData              =  self::select($table_name,$where,$bind,$getdata);											
				$row  				  =  $rowData[0];
				return $row[$getdata];	
}

#######################################################################################

function funu2($tblName,$getdata,$colName,$condition,$colName2,$condition2, $orderBy, $orderType){

                $table_name           =  DB.$tblName;	
			$where           =  $colName."=:".$colName.' AND '.$colName2."=:".$colName2."  order by ".$orderBy." ".$orderType;	
				$bind                 =  array(":".$colName=>$condition, ":".$colName2=>$condition2);		
				$rowData              =  self::select($table_name,$where,$bind,$getdata);											
				$row  				  =  $rowData[0];
				return $row[$getdata];	
}

#########################invoice ######################################################

function funu2Invoice($tblName,$getdata,$colName,$condition,$colName2,$condition2, $orderBy, $orderType){

                $table_name           =  DB.$tblName;	
			$where           =  $colName."=:".$colName.' AND '.$colName2."=:".$colName2." AND mpdrActivities!='Leave'  order by ".$orderBy." ".$orderType;	
				$bind                 =  array(":".$colName=>$condition, ":".$colName2=>$condition2);		
				$rowData              =  self::select($table_name,$where,$bind,$getdata);											
				$row  				  =  $rowData[0];
				return $row[$getdata];	
}
####################  Admin Backend #######################################################################################

function fununiversal($tblName,$getdata,$colName,$condition){

	$table_name           =  DB.$tblName;	
	$where                =  $colName."=:".$colName;	
	$bind                 =  array(":".$colName=>$condition);	
	
	$rowData              =  self::select($table_name,$where,$bind,$getdata);											
	$row  				  =  $rowData[0];
	return $row[$getdata];	
}
####################  insurance Backend #######################################################################################

function fununincuniversal($tblName,$getdata,$colName,$condition,$colName2,$condition2){

                 $table_name           =  DB.$tblName;	
				  $where                =  $colName."=:".$colName.' AND '.$colName2."=:".$colName2;	
				$bind                 =  array(":".$colName=>$condition,":".$colName2=>$condition2);
				
				//print_r($bind);
					
				$rowData              =  self::select($table_name,$where,$bind,$getdata);											
				$row  				  =  $rowData[0];
				return $row[$getdata];	
}
########################## count request ############
function fununiversalCountandCondition($tblName,$colName,$condition,$colName2,$condition2){

	$table_name           =  DB.$tblName;	
	$where                =  $colName."=:".$colName ." AND ". $colName2."=:".$colName2;	
	$bind                 =  array(":".$colName=>$condition, ":".$colName2=>$condition2);
	
	$rowData              =  self::selectCount($table_name,$where,$bind);											
	$row  				  =  $rowData[0]['count(*)'];
    return $row;	

}
########################## count request ############
function fununiversalCount($tblName,$colName,$condition){

		$table_name           =  DB.$tblName;	
		$where                =  $colName."=:".$colName;	
		$bind                 =  array(":".$colName=>$condition);		
		$rowData              =  self::selectCount($table_name,$where,$bind);											
		$row  		   =  $rowData[0]['count(*)'];
		return $row;	

}
#####################    Auto calling chk #####################
function reGn(){
	           $genAUTO1 = '0123456789';  
                 $gAuto1 =  substr(str_shuffle($genAUTO1),0,5);
		     return self::autoGEN($gAuto1);		     
}
function autoGEN($abc){
      $table_name7           =  DB."emp_login";	
      $where7                =  "emp_loginID=:emp_loginID ";	
      $bind7                 =  array(":emp_loginID"=>$abc);		
      $rowDataCount77        =  self::selectCount($table_name7,$where7,$bind7);
	$autoCount             =  $rowDataCount77[0]['count(*)'];	
	
	if($autoCount==0){
		return $abc;
	}else{		     
	   return self::reGn();
	}
	
}
#########################  ReportingManager list ##################
function getReportingManagerList(){   

      $table_nameRM           =  DB."emp_login";	
      $whereRM                =  "emp_reporting_manager_id=:emp_reporting_manager_id AND emp_role='Reporting_Manager' ";	
      $bindRM                 =  array(":emp_reporting_manager_id"=>0);		
      return $rowRM                  =  self::select($table_nameRM,$whereRM,$bindRM,"*");	
	
}
#########################  state list ##################
function getStateList(){   

      $table_nameST           =  DB."state_district";	
      $whereST                =  "status=1 GROUP BY state ";	
      //$bindRM                 =  array(":emp_reporting_manager_id"=>0);		
      return $rowST           =  self::select($table_nameST,$whereST,$bindST='',"id,state");	
	
}

#########################  Distist list ##################
function getDistist($stID){   
$steName = self::fununiversal('state_district','state','id',$stID);

      $table_nameDST           =  DB."state_district";	
      $whereDST                =  "status=1 AND state='".$steName."' ";	
      //$bindRM                 =  array(":emp_reporting_manager_id"=>0);		
      return $rowDST          =  self::select($table_nameDST,$whereDST,$bindDST='',"id,district");	
	
}
#########################  Deparment list ##################
function getDeparment(){  

      $table_nameDPT          =  DB."department_designation";	
      $whereDPT                =  "status=1 AND pcat_id = 0 ";	
      //$bindRM                 =  array(":emp_reporting_manager_id"=>0);		
      return $rowDPT           =  self::select($table_nameDPT,$whereDPT,$bindDPT='',"*");

}
#########################  designation list ##################
function getDesgList($deptID){  

      $table_nameDEGD          =  DB."department_designation";	
      $whereDEGD                =  "status=1 AND pcat_id ='".$deptID."' ";	
      //$bindRM                 =  array(":emp_reporting_manager_id"=>0);		
      return $rowDEGD           =  self::select($table_nameDEGD,$whereDEGD,$bindDEGD='',"*");

}
######################### get contract end date 15 10 5 and 1 day ##################
function getContractExpbefore151051($days){  	  
	  
	  $table_nameDEGD    =  DB."stop_ca_email_alert";	
      $whereDEGD         =  "status=1";	     	
      $rowDEGD           =  self::select($table_nameDEGD,$whereDEGD,$bindDEGD='',"*");
	  $rowD              = $rowDEGD[0];
	  
	  if($rowD['status']==0){
		  $qyeryAdd = '';
	  }else{
		    
			foreach($rowDEGD as $k=>$eid){
				$empArr[] =  $eid['emp_id'];
				$asd = implode("','",$empArr);
			}
			$qyeryAdd = " AND LO.emp_loginID NOT IN ('".$asd."')";
	  }
	  
  $tableCNT          =  DB."emp_posting_info  AS PO, ".DB."emp_login  AS LO ";	
  $wheCNT            =  "PO.contractEnddate='".date('Y-m-d', strtotime(' +'.$days.' day'))."' AND PO.contract_issue_status=1 AND PO.send_contractEmail > 0 AND LO.id=PO.emp_id AND LO.status=1 $qyeryAdd  ";	
 // echo '<br>';
  
      //$bindRM                 =  array(":emp_reporting_manager_id"=>0);		
      return $rowCNT          =  self::select($tableCNT,$wheCNT,$binCNT='',"PO.contractStartDate,PO.contractEnddate,PO.emp_id");		  
	  
	  
}
###################    ASC order genrate uid #################
function uidASCorder(){

$table_name_GENID       =  DB."emp_login";	
$where_GENID            =  "1";	
$rowData_GENID          =  self::selectCount($table_name_GENID ,$where_GENID ,$bind_GENID='',"id");
$row_GENID              =  $rowData_GENID[0]['count(id)'];

if($row_GENID==0){
	$newGenID = USERID_PREFIX.'10001';	
}else{
	
$table_name_GID           =  DB."emp_login";	
$where_GID                =  "1 ";	
//$bind_GID                 =  array(":id"=>base64_decode($_REQUEST['id']));		
//$rowData_GID              =  self::select($table_name_GID,$where_GID,$bind_GID='',"MAX(SUBSTR(emp_loginID,9)) AS maxid");

$rowData_GID              =  self::select($table_name_GID,$where_GID,$bind_GID='',"MAX(CAST(SUBSTRING(emp_loginID FROM 11) AS UNSIGNED))  AS maxid");


$row_GID                  =  $rowData_GID[0];

//$exp=explode(USERID_PREFIX,$row_GID['maxid']);

$newGe  = $row_GID['maxid'] + 1;
$newGenID = USERID_PREFIX.$newGe;	
 }
 return $newGenID;
}


################################# get count feilds ##########################
function getCountTravel($tblname,$flds,$condtion,$sdate,$edate){
                $table_name           =  DB.$tblname;	
				if($sdate==''){
				$where                =  $flds."='".$condtion."' AND startdate between '".date('Y-m-01')."' AND '".date('Y-m-t')."' AND save=1 group by emp_id";
				}else{
				$where                =  $flds."='".$condtion."' AND startdate between '".$sdate."' AND '".$edate."' AND save=1 group by emp_id";	
				}									
				//$bind                 =  array(":".$flds.""=>$condtion);		
				$rowCount             =  self::selectCount($table_name,$where,$bind='');
				$num                  =  $rowCount[0]['count(*)'];
				return $num;	
}
################################# get count feilds ##########################
function getApprovedCountTravel($tblname,$flds,$condtion,$sdate,$edate){
                $table_name           =  DB.$tblname;	
				if($sdate==''){
				$where                =  $flds."='".$condtion."' AND startdate between '".date('Y-m-01')."' AND '".date('Y-m-t')."' AND save=1 AND approval_status='Approved' group by emp_id";
				}else{
				$where                =  $flds."='".$condtion."' AND startdate between '".$sdate."' AND '".$edate."' AND save=1 AND approval_status='Approved' group by emp_id";	
				}									
				//$bind                 =  array(":".$flds.""=>$condtion);		
				$rowCount             =  self::selectCount($table_name,$where,$bind='');
				$num                  =  $rowCount[0]['count(*)'];
				if($num>0){
				return $num;
				}else{
				return 0;	
				}
}
#####################################################

function totclaimCostandcount($empid,$timetravel,$cond){
$table_name           =  DB."claim_travel";	
$where                =  "claim_month_year = '".$timetravel."' AND save='1' AND emp_id='".$empid."' ";	
//$bind               =  array(":dist_name"=>$dist);		
$rowData              =  self::select($table_name,$where,$bind='',"*");	
$rowCountCom          =  self::selectCount($table_name,$where,$bind='');
$numCOM               =  $rowCountCom[0]['count(*)'];

	foreach($rowData as $key=>$val){
		$claimed_cost =  $claimed_cost + $val['claimed_cost'];
	}
	
	if($cond=='claimed_cost'){
	return $claimed_cost;	
	}else{
		return $numCOM ;
	}
}
########################
function editConOutRep($invoiceLIST,$type){
	
	$ad = explode('<br>',trim($invoiceLIST));
	
	//print_r($invoiceLIST);
	
	 foreach($ad as $iKey=>$iVal){
		 if($iVal!=''){
		 $inPut.= '<input name="invNoArr[]" id="invNoArr[]" value="'.$iVal.'"class="form-control invID"><input name="intype[]" id="intype[]" value="'.$type.'" type="hidden" class="form-control invID"><br><input name="invAmtArr[]" id="invAmtArr[]" value="" class="form-control invAmt" placeholder="Paid (INR)"><br>';
		 }
	 }
	return $inPut;
}


########################

function approvedAmmount($empid,$timetravel,$cond){
$table_name           =  DB."claim_travel";	
$where                =  "claim_month_year = '".$timetravel."' AND save='1' AND emp_id='".$empid."' ";	
//$bind               =  array(":dist_name"=>$dist);		
$rowData              =  self::select($table_name,$where,$bind='',"*");	
$rowCountCom          =  self::selectCount($table_name,$where,$bind='');
$numCOM               =  $rowCountCom[0]['count(*)'];

	foreach($rowData as $key=>$val){
		$claimed_cost =  $claimed_cost + $val['approved_claimed_cost'];
	}
	
	if($cond=='approved_claimed_cost'){
	return $claimed_cost;	
	}else{
		return $numCOM ;
	}
		
}

############################## reporting Manager CSV Bulk
	
	function get_csv_reportingManager($filename, $delim =","){	
		$f = fopen ($filename,"r");
		$currentdate = date("Y-m-d");
		//return $size = filesize($filename)+1;				
		while ($data = fgetcsv($f, @$size, $delim)) {
		if(@$row==0)
		{    $idSart = 0;  
		     $i=@$row+1;
		     @$row++;
		     continue;
		}
		    // $uidEXP = explode(USERID_PREFIX,self::uidASCorder());
		    // $a = $uidEXP[1];
		    // $a= $a+$idSart;	 		
								 	 	 	 
		$dump[$row]['parent_id']               = 0;	
		$dump[$row]['emp_pwd']                 = 'ChangeMe';	
		$dump[$row]['emp_role']                = 'Reporting_Manager';
		$dump[$row]['send_loginEmail']         = '1';
		$dump[$row]['lastchangepassworddate']  = date("Y-m-d", strtotime($currentdate ." -16 day") );
		$dump[$row]['status']                  = '1';
		$dump[$row]['cdate']                   = date("Y-m-d");
		//$dump[$row]['emp_id']                 = USERID_PREFIX.$a;
		$dump[$row]['emp_name']              = $data[0];				
		$dump[$row]['emp_email']             = $data[1];
		$dump[$row]['emp_mobile']            = $data[2];
		$dump[$row]['postingDeparment']      = $data[3];
		$dump[$row]['postingDesignation']    = $data[4];
		$dump[$row]['dutyLocation']          = $data[5];
		
		$dump[$row]['ion']          = $data[6];
		$dump[$row]['emp_id']       = $data[7];
		
		$row++;
		$i=$row+1;
		$idSart++;
		$isi=$idSart+1;
		}
		fclose ($f);
		return $dump;
}

##############################
	
	function get_csv_Employee($filename, $delim =","){	
		$f = fopen ($filename,"r");
		//return $size = filesize($filename)+1;
		$currentdate = date("Y-m-d");				
		while ($data = fgetcsv($f, @$size, $delim)) {
		if(@$row==0)
		{    $idSart = 0;
		     
		     			
		     $i=@$row+1;
		     @$row++;
		     continue;
		}
		
		     $uidEXP = explode(USERID_PREFIX,self::uidASCorder());
		      $a = $uidEXP[1];
		      $a= $a+$idSart;	 		
								 	 	 	 
		
		//$dump[$row]['emp_pwd']                 = 'ChangeMe';			
		//$dump[$row]['send_loginEmail']         = '1';
		
		//$dump[$row]['status']                  = '1';
		//$dump[$row]['cdate']                   = date("Y-m-d");				
			
		$dump[$row]['emp_loginID']           = USERID_PREFIX.$a;
	
		
			
		$dump[$row]['emp_name']              = $data[0];				
		$dump[$row]['emp_email']             = $data[1];
		$dump[$row]['emp_mobile']            = $data[2];
		$dump[$row]['emp_role']              = $data[3];
		
		
		$dump[$row]['emp_reporting_manager_email_id'] = $data[4];
		$dump[$row]['salary']                         = $data[5];
		$dump[$row]['totSalContPeriod']               = $data[6];
		$dump[$row]['salaryType']                     = $data[7];
		
		$dump[$row]['contracthour']                   = $data[8];
		
		
		$dump[$row]['postingState']                   = $data[9];
		$dump[$row]['postingDistrict']                = $data[10];
		$dump[$row]['postingCity']                    = $data[11];			
		
		$dump[$row]['postingDeparment']               = $data[12];
		$dump[$row]['postingDesignation']             = $data[13];	
					
		$dump[$row]['contractStartDate']              = $data[14];
		$dump[$row]['contractEnddate']                = $data[15];
				
		$dump[$row]['contract_template']              = $data[16];
		$dump[$row]['contract_issue_status']          = $data[17];
		$dump[$row]['contract_issue_date']            = $data[18];	
		
		$dump[$row]['contract_sign_deadline_date']     = $data[19];
	    $dump[$row]['indicative_job_description']      = addslashes($data[20]);	
		
		$dump[$row]['ion']                             = $data[22];
		$dump[$row]['type_of_deputation']              = $data[22];			
		
		$dump[$row]['currHouseNo']            = $data[23];
		$dump[$row]['currMohalla']            = $data[24];
		$dump[$row]['currLandMark']           = $data[25];
		$dump[$row]['currPincode']            = $data[26];
		$dump[$row]['currPostoffice']         = $data[27];
		$dump[$row]['currDistrict']           = $data[28];
		$dump[$row]['currState']              = $data[29];		
		
		$dump[$row]['paHouseNo']              = $data[30];
		$dump[$row]['paMohalla']              = $data[31];
		$dump[$row]['paLandMark']             = $data[32];
		$dump[$row]['paPincode']              = $data[33];	
		$dump[$row]['paPostoffice']           = $data[34];
		$dump[$row]['paDistrict']             = $data[35];
		$dump[$row]['paState']                = $data[36];	
		
		$dump[$row]['associate_email']        = $data[37];
		// Temp
		//$dump[$row]['emp_loginID']            = $data[38];
		
		$dump[$row]['consultantWorkingDays']  = $data[38];
			
		$row++;
		$i=$row+1;
		$idSart++;
		$isi=$idSart+1;
		}
		fclose ($f);
		return $dump;
}
##############################################################
function approvedLeaveCount($empid,$year,$monthArr,$ltype){
	
	if($monthArr==2){
		$startDate = $year.'-04-01';
		$endDate = $year.'-09-30';
		
	}elseif($monthArr==3){
		$startDate = $year.'-10-01';
		$endDate = $year + 1 .'-03-31';
	}elseif($monthArr==1){
		$startDate = $year.'-04-01';
		$endDate = $year + 1 .'-03-31';
	}
	
	 $table_name4           = DB."apply_leave";	
	 $where4            = "emp_id='".$empid."'";  
	 
	 $where4.= " AND startDate between '".$startDate."' AND '".$endDate."' ";
	
	
	 $where4.= " AND leaveSubject ='".$ltype."' AND emp_cancel_leave_status=0  AND leave_Approved =1 ";
	 
	
	 
	  //echo 'mani'.$where4;   AND emp_cancel_leave_reason IS NULL
	  
	  $rowDataLD4            =  self::select($table_name4,$where4,$bind4='','*');	
	
	$totLeave=0;  
foreach($rowDataLD4 as $kl=>$kvl){
		 $datediff = strtotime($kvl['endDate']) - strtotime($kvl['startDate']);
         $getDays =  round($datediff / (60 * 60 * 24))+1;
	   $totLeave+=$getDays;	   
}

if($totLeave== NULL || $totLeave==0){
     return '0';
}else{
	return $totLeave;
}
	
}
######################
#####################
function checkApplySearchLeave_NEWReapply($empID,$year,$monthArr,$ltype,$id){	
	
	
	if($monthArr==2){
		$startDate = $year.'-04-01';
		$endDate = $year.'-09-30';
		
	}elseif($monthArr==3){
		$startDate = $year.'-10-01';
		$endDate = $year + 1 .'-03-31';
	}elseif($monthArr==1){
		$startDate = $year.'-04-01';
		$endDate = $year + 1 .'-03-31';
	}
	
		
	 $table_name4           = DB."apply_leave";	
	 $where4                = "emp_id='".$empID."'"; 	 
	 
	 $where4.= " AND startDate between '".$startDate."' AND '".$endDate."' ";
	 
	 $where4.= " AND leaveSubject ='".$ltype."' AND leave_Approved=1 AND  emp_cancel_leave_status=0 AND id!='".$id."'  ";
		
		
	 $rowDataLD4            =  self::select($table_name4,$where4,$bind4='','*');	  


$totLeave=0;  
foreach($rowDataLD4 as $kl=>$kvl){
		 $datediff = strtotime($kvl['endDate']) - strtotime($kvl['startDate']);
         $getDays =  round($datediff / (60 * 60 * 24))+1;
	   $totLeave+=$getDays;	   
}

if($totLeave== NULL || $totLeave==0){
     return '0';
}else{
	return $totLeave;
}

	
}
#####################
function checkApplySearchLeave_NEW($empID,$year,$monthArr,$ltype){	
	
	
	if($monthArr==2){
		$startDate = $year.'-04-01';
		$endDate = $year.'-09-30';
		
	}elseif($monthArr==3){
		$startDate = $year.'-10-01';
		$endDate = $year + 1 .'-03-31';
	}elseif($monthArr==1){
		$startDate = $year.'-04-01';
		$endDate = $year + 1 .'-03-31';
	}
	
		
	 $table_name4           = DB."apply_leave";	
	 $where4                = "emp_id='".$empID."'"; 	 
	 
	 $where4.= " AND startDate between '".$startDate."' AND '".$endDate."' ";
	 
	 $where4.= " AND leaveSubject ='".$ltype."' AND leave_Approved=1 AND  emp_cancel_leave_status=0  ";
		
		
	 $rowDataLD4            =  self::select($table_name4,$where4,$bind4='','*');	  


$totLeave=0;  
foreach($rowDataLD4 as $kl=>$kvl){
		 $datediff = strtotime($kvl['endDate']) - strtotime($kvl['startDate']);
         $getDays =  round($datediff / (60 * 60 * 24))+1;
	   $totLeave+=$getDays;	   
}

if($totLeave== NULL || $totLeave==0){
     return '0';
}else{
	return $totLeave;
}

	
}
##################### toady leave ################
function levaeToday($rmID=''){

$leaveCurrentDate = date('Y-m-d');	
$table_name55  = DB."apply_leave";	

$where55 = " (startDate BETWEEN '".$leaveCurrentDate."' AND '".$leaveCurrentDate."' OR endDate BETWEEN '".$leaveCurrentDate."' AND '".$leaveCurrentDate."') AND  emp_cancel_leave_status = 0  AND leave_Approved='1'   ";

if($rmID!=''){
	$where55.= "  AND linkOfficer='".$rmID."'   ";
}
 
$rowDataLD55     =  self::selectCount($table_name55,$where55,$bind55='');

return $rowDataLD55[0]['count(*)'];	
}


##################### toady leave ################
function levaeTodayState($stateID,$leveSUB='',$rmID=''){


	$table_name           =  DB."emp_posting_info, ".DB."emp_login";	
	$where                =  DB."emp_posting_info.postingState='".$stateID."' AND ".DB."emp_posting_info.contract_issue_status > 0 AND ".DB."emp_login.status=1 AND ".DB."emp_login.id = ".DB."emp_posting_info.emp_id    ";


//$bind               =  array(":emp_reporting_manager_id"=>$_SESSION['idRM']);		
$rowData              =  self::select($table_name,$where,$bind='',"*");	
	
	foreach($rowData as $k=>$lval){
		$em[]=$lval['emp_id'];
		
		$empID = implode(",",$em);
	}
	

$leaveCurrentDate = date('Y-m-d');	
$table_name55  = DB."apply_leave";	

$where55 = " (startDate BETWEEN '".$leaveCurrentDate."' AND '".$leaveCurrentDate."' OR endDate BETWEEN '".$leaveCurrentDate."' AND '".$leaveCurrentDate."') AND  emp_cancel_leave_status = 0  AND leave_Approved='1' AND emp_id IN(".$empID.")  ";

 
$rowDataLD55     =  self::selectCount($table_name55,$where55,$bind55='');

return $rowDataLD55[0]['count(*)'];	

	
}
####################my team #############################

function getMyTeam($rmID=''){
$table_name           =  DB."emp_login";	
	if($rmID!=''){
	$where                =  "emp_reporting_manager_id='".$rmID."' ";	
	}else{
	$where                =  "emp_reporting_manager_id > 0";		
	}
return $rowData       =  self::select($table_name,$where,$bind='',"*");	
	
}
######################### MPDR SUNDAY #######################################

function getMonthSundays($startDt, $endDt, $weekNum)
{
	
    $startDt = strtotime($startDt);
    $endDt = strtotime($endDt);
    $dateSun = array();
    do
    {
        if(date("w", $startDt) != $weekNum)
        {
            $startDt += (24 * 3600); // add 1 day
        }
    } while(date("w", $startDt) != $weekNum);
    while($startDt <= $endDt)
    {
        $dateSun[] = date('d-m-Y', $startDt);
        $startDt += (7 * 24 * 3600); // add 7 days
    }
    return($dateSun);
	
}


function addSundayInMPDRtbl($month,$year,$emp_id){
	
	$month_number = date("m",strtotime($month));
	$stDate = $year.'-'.$month_number.'-1';
	$enDate = date('Y-m-t',strtotime($stDate));
      $dateSun = self::getMonthSundays($stDate, $enDate, 0); // 0 sun,1mon,2 tue,3wed...
	
	$tableName = 'mpdr_'.$month.'_'.$year;
	
foreach($dateSun as $index => $date){
	$sun = date('j-m-Y',strtotime($date));  
	$asx = explode('-',$sun); 
	$fldNameAtt =  $asx[0].'_'.strtolower(date('F', mktime(0, 0, 0, $asx[1], 10))).'_'.$asx[2]; 
	//echo '<br>';
	
	$getSundayDataIfExist = self::fununiversal($tableName,$fldNameAtt,'emp_id',$emp_id);
	
	if($getSundayDataIfExist==''){	
		$update_table_name                             =  'jdsk_sams_'.$tableName;	
		$update[$fldNameAtt]                           = 'Sunday';
		$update[$asx[0].'_approvedBy']                 = 'Auto Approved';
		$update[$asx[0].'_approvedDateTime']           = date('Y-m-d H:i:s');				
		$where                    = "emp_id='".$emp_id."' ";
		self::update($update_table_name, $update, $where, $bind='');		
	}
	      $update_table_name2                             =  'jdsk_sams_'.$tableName;		
		$update2['invoice_gen_date']                    = date('Y-m-d');		
		$where2                    = "emp_id='".$emp_id."' ";
		self::update($update_table_name2, $update2, $where2, $bind2='');		
  }	
}
#-----------------Saturday add
function addSaturdayInMPDRtbl($month,$year,$emp_id){
	
	$month_number = date("m",strtotime($month));
	$stDate = $year.'-'.$month_number.'-1';
	$enDate = date('Y-m-t',strtotime($stDate));
      $dateSun = self::getMonthSundays($stDate, $enDate, 6); // 0 sun,1mon,2 tue,3wed...
	
	$tableName = 'mpdr_'.$month.'_'.$year;
	
foreach($dateSun as $index => $date){
	$sun = date('j-m-Y',strtotime($date));  
	$asx = explode('-',$sun); 
	$fldNameAtt =  $asx[0].'_'.strtolower(date('F', mktime(0, 0, 0, $asx[1], 10))).'_'.$asx[2]; 
	//echo '<br>';
	
	$getSundayDataIfExist = self::fununiversal($tableName,$fldNameAtt,'emp_id',$emp_id);
	
	if($getSundayDataIfExist==''){	
		$update_table_name                             =  'jdsk_sams_'.$tableName;	
		$update[$fldNameAtt]                           = 'Saturday';
		$update[$asx[0].'_approvedBy']                 = 'Auto Approved';
		$update[$asx[0].'_approvedDateTime']           = date('Y-m-d H:i:s');				
		$where                    = "emp_id='".$emp_id."' ";
		self::update($update_table_name, $update, $where, $bind='');		
	}
	      $update_table_name2                             =  'jdsk_sams_'.$tableName;		
		$update2['invoice_gen_date']                    = date('Y-m-d');		
		$where2                    = "emp_id='".$emp_id."' ";
		self::update($update_table_name2, $update2, $where2, $bind2='');		
  }	
}


########################## countMPDRdays #############################################
function countWorkingMPDRdays($month,$year,$emp_id){
	 $tableName = 'mpdr_'.$month.'_'.$year;
	
	$dt = $year.'-'.$month.'-01';
	$mpdrMontChk = strtotime($year.'-'.$month);
	
	$days = intval(date('t', strtotime($dt)));
	$mpdrC=0;
	
// check the MPDR month is contract start 
  $cotractStartDate = self::fununiversal('emp_posting_info','contractStartDate','emp_id',$emp_id);
  $cotractEndDate = self::fununiversal('emp_posting_info','contractEnddate','emp_id',$emp_id);

//  start count the mpdr contract start date.
$time = strtotime($cotractStartDate);
if(date('Y-m',$mpdrMontChk) == date('Y-m', $time)) {
    $csd = explode('-',$cotractStartDate);	
    //echo 'They the same!';
    $sdd = $csd[2];    
}else{
	//echo "no";
	$sdd=1;
}
///// end count days if contract end day
$timeEndContDa = strtotime($cotractEndDate);
if(date('Y-m',$mpdrMontChk) == date('Y-m', $timeEndContDa)) {
    $csendd = explode('-',$cotractEndDate);	
    //echo 'They the same!';
      $endDays = $csendd[2];    
}else{
	//echo "no";
	$endDays=$days;
}
 
for($strD=ltrim($sdd,0); $strD<=ltrim($endDays,0); $strD++){
//echo $strD.'_'.$month.'_'.$year;
$mName = date('m',strtotime($month));
$evdate = date('Y-m-d',strtotime($year.'-'.$mName.'-'.$strD));
	 
	  //$getSundayDataIfExist = self::fununiversal($tableName,$strD.'_'.$month.'_'.$year,'emp_id',$emp_id);
	 
	 $getSundayDataIfExist = self::fununincuniversal($tableName,'mpdrActivities','mpdr_date',$evdate,'emp_id',$emp_id);
		 	
if($getSundayDataIfExist!='' &&  $getSundayDataIfExist!='Sunday' && $getSundayDataIfExist!='Leave'){
		$mpdrC++;
}	
	}	
	return $mpdrC;	
}
#####################Gst state code

function gstStateCode(){
	
$table_name           =  DB."gst_state_code";	
$where                =  " 1 order by id ASC ";	
//$bind               =  array(":dist_name"=>$dist);		
return $rowData              =  self::select($table_name,$where,$bind='',"*");
}

######################################### profile prograss bar
function empProfileProgressBar($emp_id){
 
	$table_name_chkPro           =  DB."emp_personal_info";	
	$where_chkPro                =  "emp_id=:emp_id";	
	$bind_chkPro                 =  array(":emp_id"=>$emp_id);		
	$rowData_chkPro              =  self::select($table_name_chkPro,$where_chkPro,$bind_chkPro,'*');											
	$row_chkPro  		     =  $rowData_chkPro[0];
	
	$fullName = 2 + 2;
	$email=2 + 2;
	$mobile=2 + 2;
	
	$emailISVerfiy = 2;
	
############################   1
	if($row_chkPro['fName']!=''){
		$fName=2;
	}else{
		$fName=0;
	}
	############################   2
	if($row_chkPro['lname']!=''){
		$lname=2;
	}else{
		$lname=0;
	}
	############################   3
	if($row_chkPro['gender']!=''){
		$gender=2;
	}else{
		$gender=0;
	}
	############################   4
	if($row_chkPro['maritalstatus']!=''){
		$maritalstatus=2;
	}else{
		$maritalstatus=0;
	}
	############################   5
	if($row_chkPro['fatherName']!=''){
		$fatherName=2;
	}else{
		$fatherName=0;
	}
	############################   6
	if($row_chkPro['motherName']!=''){
		$motherName=2;
	}else{
		$motherName=0;
	}
	############################   7
	if($row_chkPro['birthPlace']!=''){
		$birthPlace=2;
	}else{
		$birthPlace=0;
	}
	############################   8
	if($row_chkPro['dob']!=''){
		$dob=2;
	}else{
		$dob=0;
	}
	############################   9
	if($row_chkPro['nationality']!=''){
		$nationality=2;
	}else{
		$nationality=0;
	}
	############################   2
	if($row_chkPro['currHouseNo']!=''){
		$currHouseNo=2;
	}else{
		$currHouseNo=0;
	}
		############################   11
	if($row_chkPro['currMohalla']!=''){
		$currMohalla=2;
	}else{
		$currMohalla=0;
	}
		############################   12
	if($row_chkPro['currLandMark']!=''){
		$currLandMark=2;
	}else{
		$currLandMark=0;
	}
		############################   13
	if($row_chkPro['currPincode']!='' && $row_chkPro['currPincode']>0){
		$currPincode=2;
	}else{
		$currPincode=0;
	}
		############################   14
	if($row_chkPro['currPostoffice']!=''){
		$currPostoffice=2;
	}else{
		$currPostoffice=0;
	}
		############################   15
	if($row_chkPro['currDistrict']!=''){
		$currDistrict=2;
	}else{
		$currDistrict=0;
	}
		############################   16
	if($row_chkPro['currState']!=''){
		$currState=2;
	}else{
		$currState=0;
	}
		############################   17
	if($row_chkPro['paHouseNo']!=''){
		$paHouseNo=2;
	}else{
		$paHouseNo=0;
	}
		############################   18
	if($row_chkPro['paMohalla']!=''){
		$paMohalla=2;
	}else{
		$paMohalla=0;
	}
		############################   19
	if($row_chkPro['paLandMark']!=''){
		$paLandMark=2;
	}else{
		$paLandMark=0;
	}
		############################   20
	if($row_chkPro['paPincode']!='' && $row_chkPro['paPincode']>0){
		$paPincode=2;
	}else{
		$paPincode=0;
	}
		############################   21
	if($row_chkPro['paPostoffice']!=''){
		$paPostoffice=2;
	}else{
		$paPostoffice=0;
	}
		############################   22
	if($row_chkPro['paDistrict']!=''){
		$paDistrict=2;
	}else{
		$paDistrict=0;
	}
		############################   23
	if($row_chkPro['paState']!=''){
		$paState=2;
	}else{
		$paState=0;
	}
		############################   24
	if($row_chkPro['emergencyContactNo']!=''){
		$emergencyContactNo=2;
	}else{
		$emergencyContactNo=0;
	}
		############################   25
	if($row_chkPro['emergencyContactPersonName']!=''){
		$emergencyContactPersonName=2;
	}else{
		$emergencyContactPersonName=0;
	}
		############################   26
	if($row_chkPro['upload_profile_Image']!=''){
		$upload_profile_Image=2;
	}else{
		$upload_profile_Image=0;
	}
		############################   27
	if($row_chkPro['epf_bankACNo']!=''){
		$epf_bankACNo=2;
	}else{
		$epf_bankACNo=0;
	}
		############################   28
	if($row_chkPro['epf_BankIFSCode']!=''){
		$epf_BankIFSCode=2;
	}else{
		$epf_BankIFSCode=0;
	}
		############################   29
	if($row_chkPro['epf_bankName']!=''){
		$epf_bankName=2;
	}else{
		$epf_bankName=0;
	}
		############################   30
	if($row_chkPro['bank_address']!=''){
		$bank_address=2;
	}else{
		$bank_address=0;
	}
		############################   31
	if($row_chkPro['epf_AADHARNumber']!=''){
		$epf_AADHARNumber=2;
	}else{
		$epf_AADHARNumber=0;
	}
		############################   32
	if($row_chkPro['epf_PAN']!=''){
		$epf_PAN=2;
	}else{
		$epf_PAN=0;
	}
		############################   33
	if($row_chkPro['epf_PANon_name']!=''){
		$epf_PANon_name=2;
	}else{
		$epf_PANon_name=0;
	}
		############################   34
	if($row_chkPro['gstNo_yes_no']!=''){
		$gstNo_yes_no=2;
	}else{
		$gstNo_yes_no=0;
	}
		############################   35
	if($row_chkPro['upload_pancard']!=''){
		$upload_pancard=2;
	}else{
		$upload_pancard=0;
	}
		############################   36
	if($row_chkPro['upload_addharcard']!=''){
		$upload_addharcard=2;
	}else{
		$upload_addharcard=0;
	}
		############################   37
	if($row_chkPro['upload_passbook']!=''){
		$upload_passbook=2;
	}else{
		$upload_passbook=0;
	}
		############################   38
	if($row_chkPro['upload_cv']!=''){
		$upload_cv=2;
	}else{
		$upload_cv=0;
	}
		############################   39
	if($row_chkPro['briefProfessionalProfile']!=''){
		$briefProfessionalProfile=2;
	}else{
		$briefProfessionalProfile=0;
	}
		############################   40
	if($row_chkPro['academicQualificationAwards']!=''){
		$academicQualificationAwards=2;
	}else{
		$academicQualificationAwards=0;
	}
		############################   41
	if($row_chkPro['professionalTraining']!=''){
		$professionalTraining=2;
	}else{
		$professionalTraining=0;
	}
		############################   42
	if($row_chkPro['professionalAssociation']!=''){
		$professionalAssociation=2;
	}else{
		$professionalAssociation=0;
	}
		############################   43
	if($row_chkPro['bloodGroup']!=''){
		$bloodGroup=2;
	}else{
		$bloodGroup=0;
	}
	
	//echo $emailISVerfiy .'---'. $fullName .'---'. $email .'---'. $mobile .'---'. $fName .'---'. $lname .'---'. $gender .'---'. $maritalstatus .'---'. $fatherName .'---'. $motherName .'---'. $birthPlace .'---'. $dob .'---'. $nationality .'---'. $bloodGroup .'---'. $currHouseNo .'---'. $currMohalla	 .'---'. $currLandMark	 .'---'. $currPincode	 .'---'. $currPostoffice	 .'---'. $currDistrict	 .'---'. $currState	 .'---'. $paHouseNo	 .'---'. $paMohalla	 .'---'. $paLandMark	 .'---'. $paPincode	 .'---'. $paPostoffice	 .'---'. $paDistrict	 .'---'. $paState .'---'. $emergencyContactNo .'---'. $emergencyContactPersonName .'---'. $upload_profile_Image .'---'. $epf_bankACNo .'---'. $epf_BankIFSCode .'---'. $epf_bankName .'---'. $bank_address .'---'. $epf_AADHARNumber .'---'. $epf_PAN	 .'---'. $epf_PANon_name .'---'. $gstNo_yes_no .'---'. $upload_pancard .'---'. $upload_addharcard .'---'. $upload_passbook .'---'. $upload_cv .'---'. $briefProfessionalProfile .'---'. $academicQualificationAwards .'---'. $professionalTraining .'---'. $professionalAssociation;
	//echo '<br><br><br>';
	
	
	return $totProfile = $emailISVerfiy + $fullName + $email + $mobile + $fName + $lname + $gender + $maritalstatus + $fatherName + $motherName + $birthPlace + $dob + $nationality + $bloodGroup + $currHouseNo + $currMohalla	 + $currLandMark	 + $currPincode	 + $currPostoffice	 + $currDistrict	 + $currState	 + $paHouseNo	 + $paMohalla	 + $paLandMark	 + $paPincode	 + $paPostoffice	 + $paDistrict	 + $paState + $emergencyContactNo + $emergencyContactPersonName + $upload_profile_Image + $epf_bankACNo + $epf_BankIFSCode + $epf_bankName + $bank_address + $epf_AADHARNumber + $epf_PAN	 + $epf_PANon_name + $gstNo_yes_no + $upload_pancard + $upload_addharcard + $upload_passbook + $upload_cv + $briefProfessionalProfile + $academicQualificationAwards + $professionalTraining + $professionalAssociation;
}	
##########################  emp Exper ProgressBar

function empExperienceProgressBar($emp_id){
 
	$table_name_EXP           =  DB."emp_exp_details";	
	$where_EXP                =  "emp_id=:emp_id";	
	$bind_EXP                 =  array(":emp_id"=>$emp_id);		
	$rowData_EXP              =  self::select($table_name_EXP,$where_EXP,$bind_EXP,'*');											
	$row_EXP  		        =  $rowData_EXP[0];
	
	 ############################   1
	if($row_EXP['expCompanyName']!=''){
		$expCompanyName=20;
	}else{
		$expCompanyName=0;
	}	
	############################   2
	if($row_EXP['expDesignation']!=''){
		$expDesignation=20;
	}else{
		$expDesignation=0;
	}
	############################   3
	if($row_EXP['expStartYear']!=''){
		$expStartYear=20;
	}else{
		$expStartYear=0;
	}
	
		############################   4
	if($row_EXP['expEndYear']!=''){
		$expEndYear=20;
	}else{
		$expEndYear=0;
	}
		############################   5
	if($row_EXP['expLetter']!=''){
		$expLetter=20;
	}else{
		$expLetter=0;
	}
	
	
	return $expTot = $expCompanyName + $expDesignation + $expStartYear + $expEndYear + $expLetter;
	
	
}
	
########################## empEducatioProgressBar

function empEducatioProgressBar($emp_id){
 
	$table_name_EDU           =  DB."emp_education_info";	
	$where_EDU                =  "emp_id=:emp_id";	
	$bind_EDU                 =  array(":emp_id"=>$emp_id);		
	$rowData_EDU              =  self::select($table_name_EDU,$where_EDU,$bind_EDU,'*');											
	$row_EDU  		        =  $rowData_EDU[0];
	 ############################   1
	if($row_EDU['collegeName_high']!=''){
		$collegeName_high=10;
	}else{
		$collegeName_high=0;
	}	
	############################   2
	if($row_EDU['speciDegree_high']!=''){
		$speciDegree_high=10;
	}else{
		$speciDegree_high=0;
	}
	############################   3
	if($row_EDU['yearfrom_high']!=''){
		$yearfrom_high=10;
	}else{
		$yearfrom_high=0;
	}
	############################   4
	if($row_EDU['yearto_high']!=''){
		$yearto_high=10;
	}else{
		$yearto_high=0;
	}
	############################  5
	if($row_EDU['marks_high']!=''){
		$marks_high=10;
	}else{
		$marks_high=0;
	}
	############################  6
	if($row_EDU['collegeName_inter']!=''){
		$collegeName_inter=10;
	}else{
		$collegeName_inter=0;
	}
	############################   7
	if($row_EDU['speciDegree_inter']!=''){
		$speciDegree_inter=10;
	}else{
		$speciDegree_inter=0;
	}
	############################   8
	if($row_EDU['yearfrom_inter']!=''){
		$yearfrom_inter=10;
	}else{
		$yearfrom_inter=0;
	}
	############################   9
	if($row_EDU['yearto_inter']!=''){
		$yearto_inter=10;
	}else{
		$yearto_inter=0;
	}
	
	############################   10
	if($row_EDU['marks_inter']!=''){
		$marks_inter=10;
	}else{
		$marks_inter=0;
	}
	
	return $eduTot = $collegeName_high + $speciDegree_high + $yearfrom_high + $yearto_high + $marks_high + $collegeName_inter + $speciDegree_inter + $yearfrom_inter + $yearto_inter + $marks_inter;
	
}


#################### MPDR % dashoard
function dashboardMPDRper($empID){
	
	       $monthYearNameMPDR =  strtolower(date('F_Y'));		
		 $genTBLMPDR = 'mpdr_'.$monthYearNameMPDR;			
		 $tbLEx =   self::check_table_exist_or_not($genTBLMPDR);
	      
		   //$lastDayOfMonth = date('Y-m-t');
		   //$sdateOfMonth = date('Y-m-01');
		   
	         //$dateSun = self::getMonthSundays($sdateOfMonth, $lastDayOfMonth, 0); // 0 sun,1mon,2 tue,3wed...
		   //$dateSat = self::getMonthSundays($sdateOfMonth, $lastDayOfMonth, 6); // 0 sun,1mon,2 tue,3wed...
		   
		   //$sundayCount = count($dateSun);
		   //$SaturdayCount = count($dateSat);	   
	
	 if($tbLEx == 1){
		 
		$table_name_DMPDR            =  DB.$genTBLMPDR;	
		$where_DMPDR                =  "emp_id=:emp_id";	
		$bind_DMPDR                 =  array(":emp_id"=>$empID);		
		$rowData_DMPDR              =  self::select($table_name_DMPDR,$where_DMPDR,$bind_DMPDR,'*');	
		
		foreach($rowData_DMPDR as $key=>$dVal){
			
			for($i=1; $i <=date('t'); $i++){	    
	               $dyField = $i.'_'.strtolower(date('F')).'_'.date('Y');			 		  
			  // $dy = date('d-m-Y',strtotime($i.'-'.date('m').'-'.date('Y')));
			   //$dayname = date('l', strtotime($dy));
				 if($dVal[$dyField]!=NULL){
				   if($dVal[$dyField]!='Saturday' && $dVal[$dyField]!='Sunday'){				   
					 $workingDay+=1;
				     }	 
				  }
		 } 
		}
		    //$noWorkingday =   $sundayCount  + $SaturdayCount;
		    //$totDayInMonth = date('t');		    
		    //$workingDaysInMonth = $totDayInMonth - $noWorkingday;
		   
			return  $workingDay; 
	 }	
}
################################# get count Travel in this month ##########################
function getCountTravelInThisMonth($empID){                
    
	$table_name           =  DB."create_travel";	
	$where                =  "emp_id='".$empID."' AND startdate between '".date('Y-m-01')."' AND '".date('Y-m-t')."' AND save=1 group by emp_id";
									
	//$bind               =  array(":".$flds.""=>$condtion);		
	$rowCount             =  self::selectCount($table_name,$where,$bind='');
	$num                  =  $rowCount[0]['count(*)'];
	return $num;	
}
########################################
##############################################################
function currentMonthapprovedLeaveCount($empid){
	
$table_name4        = DB."apply_leave";	
$where4            = "emp_id='".$empid."'";  
	 
$where4.= "  AND emp_cancel_leave_status=0 AND leave_Approved =1 AND startDate <= '".date('Y-m-t')."' and endDate >= '".date('Y-m-01')."' ";	
	 //select id,emp_id, datediff( least(endDate, '2024-06-30'),greatest(startDate, '2024-06-01')) FROM `jdsk_sams_apply_leave` t WHERE emp_id='3' AND emp_cancel_leave_status=0 AND leave_Approved =1 AND startDate <= '2024-06-30' and endDate >= '2024-06-01';	 
	  
$rowDataLD4   =  self::select($table_name4,$where4,$bind4='','id,emp_id, datediff( least(endDate, "'.date('Y-m-t').'"),greatest(startDate, "'.date('Y-m-01').'"))+1 AS leaveDays ');		  

foreach($rowDataLD4  as $ky=>$getData){

   $leaveDay+=$getData['leaveDays'];

}
 
return $leaveDay;
	
}
######################
###################### chat board
function getChats($id_1, $id_2){    
    
	$table_name           =  DB."jobs_chat";	
	$where                =  "(from_id='".$id_1."' AND to_id='".$id_2."') OR (from_id='".$id_2."' AND to_id='".$id_1."')   ORDER BY id ASC ";	
	//$bind                 =  array(":from_id"=>$id_1,":from_id"=>$id_2);
			
	$rowData              =  self::select($table_name,$where,$bind='',"*");
	$rowDataCount         =  self::selectCount($table_name,$where,$bind='');
	$rcount               =  $rowDataCount[0]['count(*)']; 
	
    if ($rcount > 0) { 	
		$rowDataARR=$rowData;	
    }else {
    	     $rowDataARR= '';    	
    }    
return $rowDataARR;
}
#----
function checkLastChatRM($rmID,$empID){
	
	//SELECT * FROM `jdsk_sams_jobs_chat` WHERE from_id='3' AND to_id='2' AND id=(SELECT MAX(id) FROM `jdsk_sams_jobs_chat`) ORDER by id DESC limit 1;
	
	$table_name           =  DB."jobs_chat";	
 $where          =  "from_id='".$empID."' AND to_id='".$rmID."' AND id=(SELECT MAX(id) FROM jdsk_sams_jobs_chat) limit 0,1  ";	
	$rowData              =  self::select($table_name,$where,$bind='',"id");
	$ex                   = $rowData[0];
	if($ex['id']==NULL || $ex['id']==''){
		return '';
	}else{
		return '1';
	}
	
}
#----
function checkLastActiveChat($rmID){
	
	//SELECT * FROM `jdsk_sams_jobs_chat` WHERE from_id='3' AND to_id='2' AND id=(SELECT MAX(id) FROM `jdsk_sams_jobs_chat`) ORDER by id DESC limit 1;
	
$table_name           =  DB."jobs_chat";	
$where          =  "from_id!='' AND to_id='".$rmID."' AND id=(SELECT MAX(id) FROM jdsk_sams_jobs_chat) limit 0,1  ";	
	$rowData              =  self::select($table_name,$where,$bind='',"id");
	$ex                   = $rowData[0];
	if($ex['id']==NULL || $ex['id']==''){
		return '';
	}else{
		return '<i class="far fa-comment shake" style="font-size:24px"></i>';
	}
	
}

############## client GST
function clientGST(){
	
	$table_name           =  DB."client_gst";	
	$where                =  "status='1' ";
		
	//$bind                 =  array(":from_id"=>$id_1,":from_id"=>$id_2);
			
	return $rowData              =  self::select($table_name,$where,$bind='',"*");
}

############## enrol dist count state wise
function stateWorkinEmpIncountdist($stateID){

$table_nameST           =  DB."emp_posting_info";	
$whereST                =  "postingState='".$stateID."' ";
	
$rowCountST              =  self::selectCountOrder($table_nameST,$whereST,$bindST='','DISTINCT postingDistrict');

return $rowCountST[0]['count(DISTINCT postingDistrict)'];
}

############## enrol employee count state wise
function stateWorkinEmpInCount($stateID){
	
	$table_nameEMP           =  DB."emp_posting_info, ".DB."emp_login";	
	$whereEMP                =  DB."emp_posting_info.postingState='".$stateID."' AND ".DB."emp_posting_info.contract_issue_status > 0 AND ".DB."emp_login.status=1 AND ".DB."emp_login.id = ".DB."emp_posting_info.emp_id    ";
	
		
$rowCountEMP              =  self::selectCount($table_nameEMP,$whereEMP,$bindEMP='');

	return $rowCountEMP[0]['count(*)'];
}
############## enrol RM count state wise
function stateWorkinRMcountdist($stateID){
	
$table_nameRM           =  DB."emp_posting_info,".DB."emp_login" ;	
//$whereRM                =  "postingState='".$stateID."' AND emp_id = jdsk_sams_emp_login.id;";

$whereRM  = DB."emp_posting_info.postingState='".$stateID."'  AND ".DB."emp_login.status=1 AND ".DB."emp_login.id = ".DB."emp_posting_info.emp_id    ";
	
	
$rowCountRM              =  self::selectCountOrder($table_nameRM,$whereRM,$bindRM='','DISTINCT jdsk_sams_emp_login.emp_reporting_manager_id');
return $rowCountRM[0]['count(DISTINCT jdsk_sams_emp_login.emp_reporting_manager_id)'];
}

#########################  total Invoices (Overall) INR 
function invoicesOverallINR($amountType,$yr='',$mnt=''){
	 
	    $year = base64_decode($yr);
	    $month = base64_decode($mnt);
     
	  $table_nameRM           =  DB."genrate_invoice_for_client";	
      $whereRM                =  "status=1 ";
	  
	  if($year!='' && $month!=''){
		   $yer_mnth = $month.' '.$year;
		   $whereRM.=  " AND invoice_month_year = '".$yer_mnth."' ";
	  }	  
	  
	  
      $rowRM                  =  self::select($table_nameRM,$whereRM,$bindRM,$amountType);	
	  
	  foreach($rowRM as $key=>$tVal){
		  $amount+=$tVal[$amountType];		  
	  }
	  return $amount;  
	  
}
####### indivasual Invoice outstanding ########
function indInvoiceOutstanding($empID,$ty,$fld,$moYr=''){
	$type = base64_decode($ty);
	$vReturn='';
	
	if($type==1){// inv PF
		
	  $table_nameRM           =  DB."employee_monthly_invoices";	
      $whereRM                =  "emp_id='".$empID."'  ";
	  if($moYr!=''){
	     $whereRM.=  " AND month_year='".$moYr."' ";
	   }
	  
	  $rowRM                  =  self::select($table_nameRM,$whereRM,$bindRM='','*');
	 
	 
	   foreach($rowRM as $kope=>$pfee){  
		 if($fld=='invoice_no'){ 
		      $inv = $pfee[$fld];
			  $vReturn  = $inv;		
		  }	
		 if($fld=='approved_amount'){ 
		      $invAMT+= $pfee[$fld];
			  $vReturn  = $invAMT;		
		  }
		  
		  if($fld=='paid_amount'){ 
		       $paidAMT+= $pfee['paid_amount'];			  
			   $vReturn  =	$paidAMT;
		  }	
		  if($fld=='pinding_amount'){ 		       
			   $invPindingAMT+= $pfee['pinding_amount'];
			   $vReturn  = $invPindingAMT;		
		  }	
		 
		 
	   }
		 
	######################  
		
	}else{ // inv OPE
	   $table_nameOPE           =  DB."employee_monthly_invoices_travel";	
       $whereOPE               =  "emp_id='".$empID."'  ";
	   if($moYr!=''){
	     $whereOPE.=  " AND month_year='".$moYr."' ";
	   }
	   $rowOPE                  =  self::select($table_nameOPE,$whereOPE,$bindOPE='','*');
	   
	   foreach($rowOPE as $kope=>$vope){		   
		  if($fld=='invoice_no'){ 
		      $inv.= $vope[$fld].'<br>';
			  $vReturn  = $inv;		
		  }
		  
		  #-----------------------
		  if($fld=='approved_amount'){ 
		      $invAMT+= $vope[$fld];
			  $vReturn  = $invAMT;		
		  }		  
		  #-----------------------
		  if($fld=='paid_amount'){ 
		       $invpaidAMT+= $vope['paid_amount'];			   
			   $vReturn  = $invpaidAMT;		
		  }	
		  #-------
		   if($fld=='pinding_amount'){ 		       
			   $invPindingAMT+= $vope['pinding_amount'];
			   $vReturn  = $invPindingAMT;		
		  }	
		  
	   }		
	}
	 return $vReturn;
	
}
##########################################################################
function pfee($empID,$fld){
	
$table_name     =  DB."employee_monthly_invoices";	
$where          =  "emp_id='".$empID."'   ";	
$rowData        =  self::select($table_name,$where,$bind='',"SUM(".$fld.")");
return $rowData[0]['SUM('.$fld.')'];
}
##########################################################################
function ope($empID,$fld){
	
$table_name     =  DB."employee_monthly_invoices_travel";	
$where          =  "emp_id='".$empID."'   ";	
$rowData        =  self::select($table_name,$where,$bind='',"SUM(".$fld.")");
return $rowData[0]['SUM('.$fld.')'];
}

#############################

function getMonthsInKoya($startDate, $endDate)
{
	
$start = strtotime($startDate);
$end = strtotime($endDate);


$range = array();

$date = strtotime("-1 day", $start);
$dayCount=0;  
while($date < $end)  { 
   $date = strtotime("+1 day", $date);
   $range[] = date('Y-m-d', $date);
   $dayCount++;
} 

//echo $dayCount;


    $years = floor($dayCount / 365);
    $months = floor(($dayCount - ($years * 365))/30.4375);
    $days = floor($dayCount - ($years * 365) - ($months * 30.4375));
	
    //echo 'Days received: ' . $dayCount . ' days <br />';
    //return $years . ' years, ' . $months . ' months, ' . $days . ' days';
	
	/*if($years > 0){
		return $years . ' years, ' . $months . ' months, ' . $days . ' days';
	}elseif($years == 0){
		return  $months . ' months, ' . $days . ' days';
	}*/



if($years > 0){
	$y = $years . ' years';
}else{
	$y='';
}
if($months > 0){
	$m = ' '.$months . ' months';
}else{
  $m='';	
}

if($days > 0){
	$d = ' '.$days . ' days';
}else{
  $d='';	
}
return  $y  . $m . $d;







  
/*// Formulate the Difference between two dates
$diff = abs($date2 - $date1);

// To get the year divide the resultant date into
// total seconds in a year (365*60*60*24)
$years = floor($diff / (365.25*60*60*24));

// To get the month, subtract it with years and
// divide the resultant date into
// total seconds in a month (30*60*60*24)
$months = floor(($diff - ($years * 365.25*60*60*24))	/ (30*60*60*24));

// To get the day, subtract it with years and
// months and divide the resultant date into
// total seconds in a days (60*60*24)
$days = floor(($diff - ($years * 365.25*60*60*24) - ($months * 30*60*60*24)) / (60*60*24));



// Print the result
//printf("%d years, %d months, %d days ", $years, $months,$days);
			
			if($years>0){
				 return $years.' year '. $months.' months '.$days.' days ';
			}else{
				 return $months.' months '.$days.' days ';
			}*/



}
#----
function getMonthsInRange($startDate, $endDate)
{
	
$start = strtotime($startDate);
$end = strtotime($endDate);

/*$months = 0;

while (strtotime('+1 MONTH', $date1) < $date2) {
    $months++;
    $date1 = strtotime('+1 MONTH', $date1);
}return $months. ' month, '. ($date2 - $date1) / (60*60*24). ' days'; // 120 month, 26 days*/
 
$range = array();

$date = strtotime("-1 day", $start);
$dayCount=0;  
while($date < $end)  { 
   $date = strtotime("+1 day", $date);
   $range[] = date('Y-m-d', $date);
   $dayCount++;
} 

$result = array($dayCount);

$sub_struct_month = ($result[0] / 30) ;
$sub_struct_month = floor($sub_struct_month); 
$sub_struct_days = ($result[0] % 30); // the rest of days
$sub_struct = $sub_struct_month." month's ".$sub_struct_days." day's";

return $sub_struct;

}



################# get Salry
function totalSalaryInContractPeriods($salary,$salType,$contractStartDate,$contractEnddate,$contracthour=''){
	
if($salType==1){ 	//monthly
	
$start = strtotime($contractStartDate);
$end = strtotime($contractEnddate);

$range = array();

$date = strtotime("-1 day", $start);
$dayCount='';  
while($date < $end)  { 
   $date = strtotime("+1 day", $date);
   $range[] = date('Y-m-d', $date);
   $dayCount++;
} 


 $totDays = $dayCount; 
 $daysINmonth = round($totDays / 30.42); //https://www.inchcalculator.com/convert/day-to-month/ 
 $monthlySal =  $salary * $daysINmonth;	
 return $monthlySal;
 
}elseif($salType==3){ // hour

   return ($salary * $contracthour * $daysINmonth);
	
}
 
 
 
}
############################
function salaryInContractPeriodsMonthly($salary,$salType,$contractStartDate,$contractEnddate){
	
	//return $salary.'-'.$salType.'-'.$contractStartDate.'-'.$contractEnddate;
	$startDate = $contractStartDate;
	$endDate = $contractEnddate;
    $months = array();
    while (strtotime($startDate) <= strtotime($endDate)) {
        $months[] = array(
            'year' => date('Y', strtotime($startDate)),
            'month' => date('m', strtotime($startDate)),
        );

        // Set date to 1 so that new month is returned as the month changes.
        $startDate = date('01 M Y', strtotime($startDate . '+ 1 month'));
	}
	   $totMonth = count($months); // month count
	   
$tbl='';	
$coStrtd = $contractStartDate;
$worKingDaySal='';
for($i=1;$i<=$totMonth; $i++){	
 
if($i==1){
  $srtD = date('d F Y',strtotime($coStrtd. '+ '.$i.' month'));
  $sartDate = date('Y-m-d',strtotime($coStrtd. '+ '.$i.' month'));
}else{
 $srtD = date('01 F Y',strtotime($coStrtd. '+ '.$i.' month'));
 $sartDate = date('Y-m-01',strtotime($coStrtd. '+ '.$i.' month'));
}
  
  $endMdate = date('t F Y',strtotime($coStrtd. '+ '.$i.' month'));
  
  $enddateOfMonths = date('Y-m-t',strtotime($coStrtd. '+ '.$i.' month'));


$date1 = strtotime($sartDate);
$date2 = strtotime($enddateOfMonths);

$totDays = round(($date2 - $date1) / (60*60*24)+1);
  
	if($salType==1){//monthly
	  $oneDaySalary = $salary/22;	  
		
	}elseif($salType==2){//daily
	   $oneDaySalary = $salary/1;	   
		
	}elseif($salType==3){//weekly
		 $oneDaySalary = $salary/5;	      
	}

   $tbl.='<tr>   
	<td  valign="top">'.$srtD.'</td>
	<td  valign="top">'.$endMdate.'</td>
	<td  valign="top">'.$totDays.'</td>
	<td  valign="top">---</td>
	<td  valign="top">---</td>
   </tr>';
   
  
   
   
}
	   
	   return $tbl;
	
}
#################################################################
function checkEmployeeIsEligibleFullOrPartialPayment($empID){
	
$table_name     =  DB."emp_posting_info";	
$where          =  "emp_id='".$empID."'   ";	
$rowData        =  self::select($table_name,$where,$bind='',"deliverable");
$row            =  $rowData[0];

if($row['deliverable']=='Yes'){ //PartialPayment	
	$ptye = 'PartialPayment';	
}else{ //FullMonthPayment
   $ptye = 'FullMonthPayment';	
}
	return $ptye;	
}

############## get postDeg 
function potingDeg($prtID,$chidName){
	
	$table_name           =  DB."department_designation";	
	$where                =  "pcat_id='".$prtID."' AND  department_designation='".$chidName."' ";
			
	 $rowData       =  self::select($table_name,$where,$bind='',"id");
	 $rt =  $rowData[0];
	 return $rt['id'];
	
}

#########################  associateList list ##################
function associateList(){   

      $table_nameRM           =  DB."associate";	
      $whereRM                =  "associate_status=:associate_status  ";	
      $bindRM                 =  array(":associate_status"=>1);		
      return $rowRM           =  self::select($table_nameRM,$whereRM,$bindRM,"*");	
	
}
#########################  deliverable list via emp ##################
function empDeliverableListActive($emp_id){   

      $table_nameRM           =  DB."deliverable";	
      $whereRM                =  "emp_id=:emp_id AND status=1 ";	
      $bindRM                 =  array(":emp_id"=>$emp_id);		
      return $rowRM           =  self::select($table_nameRM,$whereRM,$bindRM,"*");	
}
#########################  deliverable list via emp ##################
function empDeliverableList($emp_id){   

      $table_nameRM           =  DB."deliverable";	
      $whereRM                =  "emp_id=:emp_id  ";	
      $bindRM                 =  array(":emp_id"=>$emp_id);		
      return $rowRM           =  self::select($table_nameRM,$whereRM,$bindRM,"*");	
}
#########################  deliverable list comma sep ##################
function deliverableItemList($deliIDS,$emp_id){   

if($deliIDS!=''){
      $table_nameDL           =  DB."deliverable";	
      $whereDL               =  "emp_id='".$emp_id."' AND id IN(".$deliIDS.") ";	
      //$bindRM                 =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',"*");
	  $i=1;
	  $deList='';
	  foreach($rowDL as $kope=>$vope){
		 $deList.=  $i.'. '.$vope['deliverable_text'].'<br>';
		  $i++;
	  }
	  return $deList;
  }else{
	  return '';
  }
}
#########################  emp program array ##################
function programListCommSep($emp_id){
	
      $tabl           =  DB."program_multi";	
      $wh                =  "emp_id='".$emp_id."' ";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($tabl,$wh,$bindDL='',"*");
	  foreach($rowDL as $kO=>$pV){
		  $adr[] = $pV['id'];
		  $im = implode(',',$adr);
	  }	  	 
	  return $im;
}
#########################  emp program array ##################
function programION($id,$fld){
	
      $tabl              =  DB."program_multi";	
      $wh                =  "id IN(".$id.") ";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($tabl,$wh,$bindDL='',$fld);
	  foreach($rowDL as $kO=>$pV){
		  if($fld=='program_multi'){
			   $prN = explode('-CBD',$pV[$fld]);
	           $adr[] = $prN[0];
		  }else{
			  $adr[] = $pV[$fld];
		  }
		  
		  
		  
		  $im = implode(',',$adr);
	  }	  	 
	  return $im;
}
#########################  emp program List ##################
function programListIFinvoiced($emp_id,$prgID){
	
      $tabl           =  DB."program_multi";	
      $wh                =  "emp_id='".$emp_id."' AND id IN(".$prgID.") ";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($tabl,$wh,$bindDL='',"*");
	  foreach($rowDL as $kO=>$pV){
		  $adr[] = $pV['program_multi'].' '.$pV['program_ion'];
		  $im = implode(',',$adr);
	  }	  	 
	  return 'These program`s '.$im.' in the selected list have already been invoiced.';
}

#########################  emp program List ##################
function programListEmp($emp_id){ 

      $table_nameDL           =  DB."program_multi";	
      $whereDL                =  "emp_id='".$emp_id."' AND status=1  ";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',"*");	 
	  return $rowDL; 
}

#########################  emp program List ##################
function programListEmpTest($emp_id){ 



      $table_nameDL           =  DB."program_multi";	
      $whereDL                =  "emp_id='".$emp_id."'  AND status=1  ";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',"*");	 
	  return $rowDL; 
}

#########################  emp program approved for invoice List ##################
function programListApprovedForINvoice($emp_id,$pr){ 

      $table_nameDL           =  DB."program_multi";	
      $whereDL                =  "emp_id='".$emp_id."' AND id IN(".$pr.")";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',"*");	 
	  return $rowDL; 
}
#########################  emp program chk % ##################
function getprogramPersentage($emp_id,$prID){ 

      $table_nameDL           =  DB."program_multi";	
      $whereDL                =  "emp_id='".$emp_id."' AND id IN (".$prID.") ";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',"*");	
	  $vPer='';
	  $totPertage=0;
	  if(is_array($rowDL) || is_object($rowDL))
{
	  foreach($rowDL as $vPer){
		 $totPertage+=(int)$vPer['program_percentage'];
	  }
	  	  
}
	  return $totPertage;
 
}

######check pro wise MPDR approved or not


###### chek prg previously confirm invoice genrated 	 1      0 not create 
function checkInvoiceGen($emp_id,$prID,$m,$y){
			  	
$tableName = strtolower('mpdr_'.$m.'_'.$y);
if(self::check_table_exist_or_not($tableName)==1){ //chk select month tbl is in database

	$proExp = explode(',',$prID);
         
 foreach($proExp as $kp=>$vP){
		   
	 $table    =  DB.$tableName;	
	 $whr      =  "emp_id='".$emp_id."' AND mpdr_program = '".$vP."' AND emp_rm_send_mpdr_status=1 ";	
	 $ro       =  self::select($table,$whr,$bi='','*');
	 $cRo	   =  $ro[0];  
		  
    if($cRo['invoice_generate']==1){
			  $p1 = explode(',',$cRo['mpdr_program']);
			  $invoicedPrg =  implode(',',$p1);			  
		   }  		   
	  }		
		
	if($p1!=''){
        $newArray = array_diff($proExp, $p1);		
	}else{
		$newArray = $proExp;
	}
		
		$avalibile = implode(',',$newArray);
		return $avalibile.'@'.$invoicedPrg; 
   		 
}else{
		return ' '; //table not exist
	 }
}
#####################################################



#########################  emp program chk % ##################
function programLisTMPDR($emp_id,$prID){ 

      $table_nameDL           =  DB."program_multi";	
      $whereDL                =  "emp_id='".$emp_id."' AND id IN (".$prID.") ";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',"*");	
	  
	  if (is_array($rowDL) || is_object($rowDL))
{
	  foreach($rowDL as $vPer){
		 $lsitMPDRPro[] =  $vPer['program_multi'].'-'.$vPer['program_ion'];
	  }
	    $imp = implode(',',$lsitMPDRPro);
	    
	  	 return $imp; 
}else{
	 return ''; 
}  
	  
}
#########################  emp program chk % ##################
function mpdrTBL($tblName,$emp_id,$mpdr_Date,$prID,$fld){ 



  $table_nameDL      =  DB.$tblName;	
  $whereDL           =  "emp_id='".$emp_id."' AND mpdr_date='".$mpdr_Date."' AND mpdr_program IN('Holidays',".$prID.")";	
 

      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',$fld);
      $iko='';
	  foreach($rowDL as $ck=>$cVal){
		  $art[] = $cVal[$fld];
		  $iko = implode(',',$art);
	  }
	  return $iko;
	  
}

#########################  emp program chk % ##################
function mpdrTBLeave2($tblName,$emp_id,$mpdr_Date,$prID,$fld){ 

if($mpdr_Date==''){
	$mpDate = '';
}else{
	$mpDate = " AND mpdr_date='".$mpdr_Date."' ";
}

  $table_nameDL           =  DB.$tblName;	
  $whereDL                =  "emp_id='".$emp_id."' ".$mpDate." AND mpdr_program LIKE '%".$prID."%'  ";	

      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',$fld);	
      $iko='';
	  foreach($rowDL as $ck=>$cVal){
		  $art[] = $cVal[$fld];
		  $iko = implode(',',$art);
	  }
	  return $iko;
	  
}
#########################  emp program chk % ##################
function mpdrTBLeave($tblName,$emp_id,$mpdr_Date,$prID,$fld){ 

if($mpdr_Date==''){
	$mpDate = '';
}else{
	$mpDate = " AND mpdr_date='".$mpdr_Date."' ";
}

  $table_nameDL           =  DB.$tblName;	
  $whereDL                =  "emp_id='".$emp_id."' ".$mpDate." AND mpdr_program LIKE '%".$prID."%' AND mpdr_program!='Holidays' AND mpdrActivities!='Leave' ";	

      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',$fld);	
      $iko='';
	  foreach($rowDL as $ck=>$cVal){
		  $art[] = $cVal[$fld];
		  $iko = implode(',',$art);
	  }
	  return $iko;
	  
}
#########################  emp program chk % ##################
function prgGetmpdrTBL($tblName,$emp_id,$mpdr_Date,$fld){
  
  $table_nameDL           =  DB.$tblName;	
  $whereDL                =  "emp_id='".$emp_id."' AND mpdr_date='".$mpdr_Date."' ";	

      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',$fld);	
	  foreach($rowDL as $ck=>$cVal){
		  $art[] = $cVal[$fld];
		  $iko = implode(',',$art);
	  }
	  return $iko;
	
}
##############################################################
function new_approvedLeaveCount($empid,$caStart,$caEnd){
	
	
	 $table_name4           = DB."apply_leave";	
	 $where4                = "emp_id='".$empid."'";  
	 
	 $where4.= " AND startDate between '".$caStart."' AND '".$caEnd."' ";	
	 $where4.= "  AND emp_cancel_leave_status=0  AND leave_Approved =1 ";
	// echo 'mani'.$where4; 
	$rowDataLD4            =  self::select($table_name4,$where4,$bind4='','*');	
	
	$totLeave=0;  
foreach($rowDataLD4 as $kl=>$kvl){
		 $datediff = strtotime($kvl['endDate']) - strtotime($kvl['startDate']);
         $getDays =  round($datediff / (60 * 60 * 24))+1;
	   $totLeave+=$getDays;	   
}

if($totLeave== NULL || $totLeave==0){
     return '0';
}else{
	return $totLeave;
}
	
}
#########################
function new_approvedLeaveCount2($empid,$caStart,$caEnd){
	
	
	 $table_name4           = DB."apply_leave";	
	 $where4                = "emp_id='".$empid."'";  
	 
	 $where4.= " AND startDate between '".$caStart."' AND '".$caEnd."' ";	
	 $where4.= "  AND emp_cancel_leave_status=0  AND leave_Approved =1 ";
	// echo 'mani'.$where4; 
	$rowDataLD4            =  self::select($table_name4,$where4,$bind4='','SUM(leaveDays)');	
	
	$totLeave=0; 
	$totLeave = $rowDataLD4[0]['SUM(leaveDays)']; 
	
	


if($totLeave== NULL || $totLeave==0){
     return '0';
}else{
	return $totLeave;
}
	
}

######################
function approvedLeaveForInvoice($empid,$yr,$month){
			 	
$tableName = strtolower('mpdr_'.$month.'_'.$yr);	 
$getCountTBL = self::check_table_exist_or_not($tableName);	 
 if($getCountTBL === 1) {
	 
	   $table_nameDL           =  DB.$tableName;	
      $whereDL                =  "emp_id='".$empid."' AND mpdrActivities='Leave' AND (invoice_no='' OR invoice_no IS NULL)   ";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::selectCount($table_nameDL,$whereDL,$bindDL='');	
	  
	 return $leaveCount =  $rowDL[0]['count(*)'];       	
 }	
}
######################
function approvedLeaveForInvoicePurpose($empid,$yr,$month){
			 	
$tableName = strtolower('mpdr_'.$month.'_'.$yr);	 
$getCountTBL = self::check_table_exist_or_not($tableName);	 
 if($getCountTBL === 1) {
	 
	   $table_nameDL           =  DB.$tableName;	
      $whereDL                =  "emp_id='".$empid."' AND mpdrActivities='Leave' AND (invoice_no='' OR invoice_no='TempInvoice' OR invoice_no IS NULL)   ";	
      //$bindRM               =  array(":emp_id"=>$emp_id);		
      $rowDL                  =  self::selectCount($table_nameDL,$whereDL,$bindDL='');	
	  
	 return $leaveCount =  $rowDL[0]['count(*)'];       	
 }	
}

#######################chk applicable leave deduct
function leaveChkMPDRCut($empid,$yr,$month){
			 	
$tableName = strtolower('mpdr_'.$month.'_'.$yr);	 
$getCountTBL = self::check_table_exist_or_not($tableName);	 
 if($getCountTBL === 1) {
	 
	  $table_nameDL           =  DB.$tableName;	
      $whereDL                =  "emp_id='".$empid."' AND leaveApplicable > 0   ";	
      $rowDL                  =  self::selectCount($table_nameDL,$whereDL,$bindDL='');
	  return  $rowDL[0]['count(*)'];	 
 }
}
#######################chk applicable leave deduct
function leaveAPorNot($empid,$yr,$month,$fld){
			 	
$tableName = strtolower('mpdr_'.$month.'_'.$yr);	 
$getCountTBL = self::check_table_exist_or_not($tableName);	 
 if($getCountTBL === 1) {
	 
	  $table_nameDL           =  DB.$tableName;	
      $whereDL                =  "emp_id='".$empid."'  AND leaveApplicable > 0  ";	
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='',$fld);
	  $rc                     = $rowDL[0];
	  	
	  return  $rc[$fld];
 }
}
#######################chk applicable leave deduct
function delMPDR($genTBL,$empid,$mpdr_Date,$pro){
	 
$getCountTBL = self::check_table_exist_or_not($genTBL);	 
 if($getCountTBL === 1) {
	 
	  $table_nameDL           =  DB.$genTBL;	
      $whereDL                =  "emp_id='".$empid."' AND mpdr_program IN(".$pro.") AND mpdr_date='".$mpdr_Date."' AND emp_send_mpdr=0 AND emp_rm_send_mpdr_status!=1 AND invoice_no IS NULL ";	
      $rowDL                  =  self::selectCount($table_nameDL,$whereDL,$bindDL='');
	 return $rc               = $rowDL[0]['count(*)'];	  	
	  
 }
}
#######################chk applicable leave deduct
function hourCalulateHourlyBasedConsultant($empid,$genTBL){
$getCountTBL = self::check_table_exist_or_not($genTBL);	 
 if($getCountTBL === 1) {
	 
	  $table_nameDL           =  DB.$genTBL;	
      $whereDL                =  "emp_id='".$empid."'  ";	
      $rowDL                  =  self::select($table_nameDL,$whereDL,$bindDL='','SUBSTRING(SEC_TO_TIME( SUM( TIME_TO_SEC(if_consultant_hourly_based ) ) ), 1, 5) AS total_time');
	   $rc               = $rowDL[0];	
	  
	  return $rc['total_time'];
	 
 }

}
############################# invoice amount 
function invoiceAmount($empid,$y,$m,$p){
	
	
$chkPrg =  self::checkInvoiceGen($empid,$p,base64_decode($m),base64_decode($y));
	   
	  if($chkPrg!=''){ 	  
	  $chkPrgStringChoped = explode('@',$chkPrg);	
	  $chkPrgStringChoped[0]; // invoice not genreate
	  $invoicedPrg = $chkPrgStringChoped[1]; // invoice genreated	  
	  
	   if($invoicedPrg!=''){		
	// get program persentage	 
$prgPersentage = self::getprogramPersentage($empid,$chkPrgStringChoped[1]);    
	  }else{		
$prgPersentage = self::getprogramPersentage($empid,$chkPrgStringChoped[0]);	
  
	  }
	   
$employeeRole = self::fununiversal('emp_login','emp_role','id',$empid);		   
	   
	  
 if($prgPersentage > 0 || $employeeRole=='Consultant_B'){
	 
	 $genTBL = strtolower('mpdr_'.base64_decode($_REQUEST['m']).'_'.base64_decode($_REQUEST['y']));	
	 $monthlySalInVar = self::fununiversal('emp_posting_info','monthlySalInVar','emp_id',$empid);




if($employeeRole=='Consultant_B'){

$getTotSalary_withouTGen_paymentAD = self::fununincuniversal($genTBL,'approvedInvoiceAmt','emp_id',$empid,'mpdr_program',$p);

}elseif($monthlySalInVar=='Yes'  && $employeeRole!='Consultant_B'){
	
  $t7           =  DB."emp_salary_in_varabiles";	
  $w7           =  "emp_id='".$empid."' AND month='".base64_decode($_REQUEST['m'])."' AND year='".base64_decode($_REQUEST['y'])."'  "; 
  $ro7      =  self::select($t7,$w7,$b7,"salary");	
  $mvisal =	$ro7[0];
	
	$getTotSalary_withouTGen_paymentAD = $mvisal['salary'];
	
}elseif($monthlySalInVar=='No' || $monthlySalInVar==NULL){
	
$getTotSalary_withouTGen_paymentAD = self::fununiversal('emp_posting_info','salary','emp_id',$empid);

}


####################### After Payment advice genrate INVOICE AMT FIXED ########### 1 mens pyadvoce genreate ho gayi hai

$genPA = self::funu2($genTBL,'genratePaymentAdvice','emp_id',$empid,'mpdr_program',$p,'id','DESC');
if($genPA==0){
	
	$getTotSalary = $getTotSalary_withouTGen_paymentAD;
	
}else{
	
	 $getTotSalary = self::funu2($genTBL,'approvedInvoiceAmt','emp_id',$empid,'mpdr_program',$p,'id','DESC');		
}

##################################################################################
	 
$getSalaryType = self::fununiversal('emp_posting_info','salaryType','emp_id',$empid);
	 
######------------

if($getSalaryType==3){
	
$totCAHour = self::fununiversal('emp_posting_info','contracthour','emp_id',$empid);
		
$table_name4           = DB.$genTBL;	
$where4                = "emp_id='".$empid."'"; 		
$rowDataLD4            =  self::select($table_name4,$where4,$bind4='','SUBSTRING(SEC_TO_TIME( SUM( TIME_TO_SEC(if_consultant_hourly_based ) ) ), 1, 5) AS total_time');

$rcTime =  $rowDataLD4[0];
$horuCount = $rcTime['total_time'];
$timeINexp = explode(':',$horuCount);
$minutes = ($timeINexp[0] * 60)+$timeINexp[1];	
$oneMinSal = $getTotSalary/60;
		 
	$givenSal= $minutes * $oneMinSal;
	
}else{
	$givenSal =  $getTotSalary;
}
	 
	 
//$invoicedAmt = ($prgPersentage / 100) * $givenSal;	

	// PA genreate ho gay hai 
if($genPA==0){		 
	 if($employeeRole!='Consultant_B'){
       $invoicedAmt = ($prgPersentage / 100) * $givenSal;
	 }else{
		$invoicedAmt =  $givenSal; 
	 }
}else{
$invoicedAmt =  $givenSal;	
}


	 
 }
	  	  
$ta2           =  DB.$genTBL;	
$wh2           =  "emp_id='".$empid."'  AND leaveApplicable > 0 AND leaveDay > 0 AND mpdr_program = '".$p."' ";	
$ro2           =  self::select($ta2,$wh2,$bi2='','*');
$rc2           =  $ro2[0];
$mt = explode(',',$rc2['emp_send_mpdr_program_group']);	  
   
   if($p==$mt[0]){
	 // echo $rc2['leaveApplicable'].' Rest/Off days adjusted with the fee.';
	  
	$salary =  self::fununiversal('emp_posting_info','salary','emp_id',$empid);
	
		$consultantWorkingDays =  self::fununiversal('emp_posting_info','consultantWorkingDays','emp_id',$empid);
		
		if($consultantWorkingDays=='Monthly'){
			$getDays = date('t',strtotime(base64_decode($y).'-'.base64_decode($m)));
		}else{
			$getDays =  $consultantWorkingDays;
		}
		 
		// $onedaySal = $salary / $getDays;		
		  $onedaySalTot = $salary / 20;		 
		  $onedaySal = $rc2['leaveDay'] * $onedaySalTot;
    }	  
	  
	  $stot = $invoicedAmt - $onedaySal;
	  
######
$gstYESNO = self::fununiversal('emp_personal_info','gstNo_yes_no','emp_id',$empid);

// $gstNo;
 $gstStateCode = self::fununiversal('gst_state_code','state','state_code',self::fununiversal('emp_personal_info','gstNo_state_code','emp_id',$empid));

$cgstTot='0.00';
$sgstTot='0.00';
$igstTot='0.00';
$cgst='@';
$sgst='@';
$igst='@';
$sign='%';
$signIGST='%';

if($gstStateCode == 'Delhi' && $gstYESNO=='Yes'){ 
 $cgst = CGST;
 $sgst = SGST;
 $sign = '%'; 

            $cgstAMT = $stot*CGST/100;
		    $cgstTot =  number_format($cgstAMT,2).' ';
		
		   $sgstAMT = $stot*SGST/100;
	       $sgstTot = number_format($sgstAMT,2).' ';
		   
}elseif($gstStateCode!= 'Delhi' && $gstYESNO=='Yes'){
	   
	       $igst = IGST;
           $signIGST = '%';	
	      $igstAMT = $stot*IGST/100;
	      $igstTot =  number_format($igstAMT,2).' ';
}	  
	  
	  $taxAdd = $cgstAMT+$sgstAMT+$igstAMT;
	  
	  
	  $totSal = $stot+$taxAdd; 
	 $salRound = round($totSal);
	return $salRound;	
	
	  }	 
	
}
#####################################################
############################# invoice amount 
function invoiceAmountPartA($empid,$yr,$mo,$p){
	
	
	$m = base64_decode($mo);
	$y = base64_decode($yr);
	
 $chkPrg =  self::checkInvoiceGen($empid,$p,$m,$y);
 if($chkPrg!=''){ 	  
	  $chkPrgStringChoped = explode('@',$chkPrg);
	  $chkPrgStringChoped[0]; // invoice not genreate
	  $invoicedPrg = $chkPrgStringChoped[1]; // invoice genreated	
	  
if($invoicedPrg!=''){		
	    // get program persentage	 
       $prgPersentage = self::getprogramPersentage($empid,$chkPrgStringChoped[1]);    
	  }else{		
       $prgPersentage = self::getprogramPersentage($empid,$chkPrgStringChoped[0]);	  
}


	  $employeeRole = self::fununiversal('emp_login','emp_role','id',$empid);
	  
	   if($prgPersentage > 0){	 
	    $genTBL = strtolower('mpdr_'.$m.'_'.$y);
		
		$thisMonthStartDate = date('Y-m-d',strtotime($y.'-'.$m.'-01'));
        $thisMonthEndDate = date('Y-m-20',strtotime($y.'-'.$m.'-20'));
		
############# Consultant_B
if($employeeRole=='Consultant_B'){	
$getTotSalary_withouTGen_paymentAD = self::fununincuniversalMPDRCycle($genTBL,'approvedInvoiceAmt','emp_id',$empid,'mpdr_program',$p,$thisMonthStartDate,$thisMonthEndDate);
}
#############################  Nen Ai 
elseif($employeeRole=='Consultant'){	
$getTotSalary_withouTGen_paymentAD = self::fununiversal('emp_posting_info','salary','emp_id',$empid);
}


####################### After Payment advice genrate INVOICE AMT FIXED ########### 1 mens pyadvoce genreate ho gayi hai
$genPA = self::checkMPDRCycleTable($genTBL,$empid,$m,$y,'genratePaymentAdvice');

if($genPA==0 || $genPA==NULL){	
	$getTotSalary = $getTotSalary_withouTGen_paymentAD;
}else{	
	$getTotSalary = self::checkMPDRCycleTable($genTBL,$empid,$m,$y,'approvedInvoiceAmt');		
}

##################################################################################		
 $getSalaryType = self::fununiversal('emp_posting_info','salaryType','emp_id',$empid);

######------------
if($getSalaryType==1){
$invoicedAmt_otp =  $getTotSalary;
}else{	
$invoicedAmt_otp =  $getTotSalary;
}	


	
#############################
$leaveSummary = self::invoiceLeaveModule($empid,$y,$m);
//echo '<pre>';
//print_r($leaveSummary);
$ymGet =  date('Y-n',strtotime($y.'-'.$m));
$ymGetPreviousMonth =  date('Y-m-d',strtotime($y.'-'.$m.'-01'));
$preMonth = date('Y-n', strtotime('-1 month',strtotime($ymGetPreviousMonth)));
############################	

		
$m = date('m',strtotime($m));
$ym_1 = date('Y-m',strtotime($y.'-'.$m));
$getPreviousMonthAndYear_1 =  date("m", strtotime("$ym_1 -1 month"));

     //$lvStartD = $y.'-'.$getPreviousMonthAndYear_1.'-20';
	 //$lvEndD = $y.'-'.$m.'-21';	
	 
	 
	 
	  
$year  = (int) $y; // e.g. 2026
$month = (int) $m;                            // selected month (1–12)

// End Date
$lvEndD = $year . '-' . str_pad($month, 2, '0', STR_PAD_LEFT) . '-20';

// Start Date
if ($month == 1) {
    $startYear  = $year - 1;
    $startMonth = 12;
} else {
    $startYear  = $year;
    $startMonth = $month - 1;
}

$lvStartD = $startYear . '-' . str_pad($startMonth, 2, '0', STR_PAD_LEFT) . '-21';
$lvEndD = $y.'-'.$m.'-20';
	 
	 
	 
	 
	 
	 	  
$tableLeave  =  DB."apply_leave ";	
$wheLeave = "leave_Approved=1 
    AND emp_id='".$empid."' 
    AND (  
        (startDate BETWEEN '".$lvStartD."' AND '".$lvEndD."')       
        OR (endDate BETWEEN '".$lvStartD."' AND '".$lvEndD."')       
        OR (startDate < '".$lvStartD."' AND endDate > '".$lvEndD."')
    ) AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL)";	
$rowLeave    =  self::select($tableLeave,$wheLeave,$binLeave='','SUM(leaveDays)');
$toLv =  $rowLeave[0]['SUM(leaveDays)'];

########################		
$extraLeave=0;
$thisMonthAvaLeaveABC = $leaveSummary[$ymGet]['totalAvailable'];
$extraLeave_ON = $toLv - $leaveSummary[$ymGet]['totalAvailable'];

if ($extraLeave_ON > 0) {
    $extraLeave =  $extraLeave_ON;
} else {
    $extraLeave =  0;
}

###############
if($genPA==0  || $genPA==NULL){	 


$contractStartDate = self::fununiversal('emp_posting_info','contractStartDate','emp_id',$empid);
$contractEndDate = self::fununiversal('emp_posting_info','contractEndDate','emp_id',$empid);


$sundayCy = self::getSundaysInCycle($m,$y,$contractStartDate,$contractEndDate);

$sundaysDatesNocount = count($sundayCy);




$conWorkDaysTotSimp =  self::workingMPDRdaysCount($m,$y,$empid);
$daysForSalary = self::daysCountinCycle($m,$y);


$saturdayDateArr = self::getOffSaturdayDates($m,$y,$empid);

$lastFillDateMPDR = self::lastFilledMPDRdate($empid,$m,$y); 


$firstFillDateMPDR = self::firstFilledMPDRdate($empid,$m,$y);  
//print_r($sundayCy);

  $realSatCount = self::getBetweenCount($firstFillDateMPDR,$lastFillDateMPDR, $saturdayDateArr); 
  $realSunCount = self::getBetweenCount($firstFillDateMPDR,$lastFillDateMPDR, $sundayCy);



$totalApplicableSatSun = $realSatCount + $realSunCount;

 
$getEKdinSal =  $invoicedAmt_otp / $daysForSalary;
//echo '<br>'; 
$leaveAmtDect = $getEKdinSal * $extraLeave;

	 //echo '<br>'; 
	 $augOnly = date('Y-m',strtotime($m.'-'.$y));	
	if($augOnly=='2025-08'){
		$augstOnly = 11;
	}else{
		$augstOnly = 0;
	}
	
			
	//echo $getEKdinSal.'====='.$conWorkDaysTotSimp.'====='.$sundaysDatesNocount.'====='. $augstOnly; 
		
	$workDays = $conWorkDaysTotSimp + $totalApplicableSatSun + self::satsun($empid,$firstFillDateMPDR);	
	
	if($workDays > $daysForSalary ){
		 $extDays =   $workDays - $daysForSalary; 
		 $payableSaldays = $workDays - $extDays;
	}else{
		$payableSaldays = $workDays;
	}	
	//echo $invoicedAmt_otp.'---'.$daysForSalary;
	//echo '<br>';	
	//echo $payableSaldays.'--'.$getEKdinSal.'--'.$conWorkDaysTotSimp.'--'.$sundaysDatesNocount.'--'.$augstOnly;
	//$invoicedAmt  = $getEKdinSal * ($conWorkDaysTotSimp + $sundaysDatesNocount + $augstOnly);
	$invoicedAmt  = $getEKdinSal * ($payableSaldays + $augstOnly);
	
	
	
	
	
	 	 
  }else{	
	$invoicedAmt = self::checkMPDRCycleTable($genTBL,$empid,$m,$y,'approvedInvoiceAmt');
}	
   } 	
	   return $invoicedAmt;  
 }	
}



#####################################################
function invoiceAmountPartAGST($empid,$yr,$mo,$p){
	
	 $invoiceInAmtVal =  self::invoiceAmountPartA($empid,$yr,$mo,$p);
	 $m = base64_decode($mo);
	 $y = base64_decode($yr);
	 
	 
$daysForSalary = self::daysCountinCycle($m,$y); 
$getEKdinSal =  $invoiceInAmtVal / $daysForSalary;

############################

$m = date('m',strtotime($m));
$ym_1 = date('Y-m',strtotime($y.'-'.$m));
$getPreviousMonthAndYear_1 =  date("m", strtotime("$ym_1 -1 month"));

     //$lvStartD = $y.'-'.$getPreviousMonthAndYear_1.'-20';
	 //$lvEndD = $y.'-'.$m.'-21';	
	 
	 //$lvStartD = base64_decode($_REQUEST['y']).'-'.$getPreviousMonthAndYear_1.'-21';
	  
$year  = (int) $y; // e.g. 2026
$month = (int) $m;                            // selected month (1–12)

// End Date
$lvEndD = $year . '-' . str_pad($month, 2, '0', STR_PAD_LEFT) . '-20';

// Start Date
if ($month == 1) {
    $startYear  = $year - 1;
    $startMonth = 12;
} else {
    $startYear  = $year;
    $startMonth = $month - 1;
}

$lvStartD = $startYear . '-' . str_pad($startMonth, 2, '0', STR_PAD_LEFT) . '-21';
$lvEndD = $y.'-'.$m.'-20';
	 
	 
	 
	 	  
$tableLeave  =  DB."apply_leave ";	
$wheLeave = "leave_Approved=1 
    AND emp_id='".$empid."' 
    AND (  
        (startDate BETWEEN '".$lvStartD."' AND '".$lvEndD."')       
        OR (endDate BETWEEN '".$lvStartD."' AND '".$lvEndD."')       
        OR (startDate < '".$lvStartD."' AND endDate > '".$lvEndD."')
    ) AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL)";	
$rowLeave    =  self::select($tableLeave,$wheLeave,$binLeave='','SUM(leaveDays)');
$toLv =  $rowLeave[0]['SUM(leaveDays)'];

########################
$extraLeave=0;
$thisMonthAvaLeaveABC = $leaveSummary[$ymGet]['totalAvailable'];
$extraLeave_ON = $toLv - $leaveSummary[$ymGet]['totalAvailable'];

if ($extraLeave_ON > 0) {
    $extraLeave =  $extraLeave_ON;
} else {
    $extraLeave =  0;
}
###############	 
	  
	 
	 
$thisMonthStartDate = date('Y-m-d',strtotime($y.'-'.$m.'-01'));
$thisMonthEndDate = date('Y-m-20',strtotime($y.'-'.$m.'-20'));	 
	 
$ta2           =  DB.$genTBL;	
$wh2           =  "emp_id='".$empid."' AND mpdr_program = '".$p."'  AND mpdrActivities!='Leave' AND mpdr_date between '".$thisMonthStartDate."' AND  '".$thisMonthEndDate."' ";	
$ro2           =  self::select($ta2,$wh2,$bi2='','*');
$lev2          = $ro2[0]; 

if($genPA==0 || $genPA==NULL){
	$salDeducted = 0;
if($extraLeave > 0){
	
	if($lev2['invoice_generate'] == 0 ){
		 
		$salDeducted = $getEKdinSal *	$extraLeave;
	}elseif($lev2['invoice_generate'] == 1 ){
		 
		if($lev2['leaveDay'] > 0 ){
		$extraLeave = $lev2['leaveDay'];		 	
		$salDeducted =  $getEKdinSal * $extraLeave;	
	    }else{				
		//echo $leaveApply.' Rest/Off days adjusted with the fee.';		
		$salDeducted =  0;
	   }	
    }
}

}else{
	/// jab invious genrate ho jaye gi tab
	    $leaveApply = $lev2['leaveDay'];			 
		$salDeducted = $lev2['other_deductions'];

} 
	  $stot = $invoiceInAmtVal - $salDeducted;
	  
	  $gstYESNO = self::fununiversal('emp_personal_info','gstNo_yes_no','emp_id',$empid);

// $gstNo;
 $gstStateCode = self::fununiversal('gst_state_code','state','state_code',self::fununiversal('emp_personal_info','gstNo_state_code','emp_id',$empid));

$cgstTot='0.00';
$sgstTot='0.00';
$igstTot='0.00';
$cgst='@';
$sgst='@';
$igst='@';
$sign='%';
$signIGST='%';

if($gstStateCode == 'Delhi' && $gstYESNO=='Yes'){ 
 $cgst = CGST;
 $sgst = SGST;
 $sign = '%'; 

            $cgstAMT = $stot*CGST/100;
		    $cgstTot =  number_format($cgstAMT,2).' ';
		
		   $sgstAMT = $stot*SGST/100;
	       $sgstTot = number_format($sgstAMT,2).' ';
		   
}elseif($gstStateCode!= 'Delhi' && $gstYESNO=='Yes'){
	   
	       $igst = IGST;
           $signIGST = '%';	
	      $igstAMT = $stot*IGST/100;
	      $igstTot =  number_format($igstAMT,2).' ';
}	  
	  
	  $taxAdd = $cgstAMT+$sgstAMT+$igstAMT;
	  
	  
	  
	return $taxAdd;	
	  
	 
	 
	
}

############################# invoice amount 
function invoiceAmountPartAGST_old($empid,$y,$m,$p){
	
	
$chkPrg =  self::checkInvoiceGen($empid,$p,base64_decode($m),base64_decode($y));
	   
	  if($chkPrg!=''){ 	  
	  $chkPrgStringChoped = explode('@',$chkPrg);	
	  $chkPrgStringChoped[0]; // invoice not genreate
	  $invoicedPrg = $chkPrgStringChoped[1]; // invoice genreated	  
	  
	   if($invoicedPrg!=''){		
	// get program persentage	 
$prgPersentage = self::getprogramPersentage($empid,$chkPrgStringChoped[1]);    
	  }else{		
$prgPersentage = self::getprogramPersentage($empid,$chkPrgStringChoped[0]);	
  
	  }
	   
	  
 $employeeRole = self::fununiversal('emp_login','emp_role','id',$empid);		   
	   
	  
 if($prgPersentage > 0 || $employeeRole=='Consultant_B'){
	 
	 $genTBL = strtolower('mpdr_'.base64_decode($_REQUEST['m']).'_'.base64_decode($_REQUEST['y']));	
	 $monthlySalInVar = self::fununiversal('emp_posting_info','monthlySalInVar','emp_id',$empid);




if($employeeRole=='Consultant_B'){

$getTotSalary_withouTGen_paymentAD = self::fununincuniversal($genTBL,'approvedInvoiceAmt','emp_id',$empid,'mpdr_program',$p);

}elseif($monthlySalInVar=='Yes'  && $employeeRole!='Consultant_B'){
	
  $t7           =  DB."emp_salary_in_varabiles";	
  $w7           =  "emp_id='".$empid."' AND month='".base64_decode($_REQUEST['m'])."' AND year='".base64_decode($_REQUEST['y'])."'  "; 
  $ro7      =  self::select($t7,$w7,$b7,"salary");	
  $mvisal =	$ro7[0];
	
	$getTotSalary_withouTGen_paymentAD = $mvisal['salary'];
	
}elseif($monthlySalInVar=='No' || $monthlySalInVar==NULL){
	
$getTotSalary_withouTGen_paymentAD = self::fununiversal('emp_posting_info','salary','emp_id',$empid);

}


####################### After Payment advice genrate INVOICE AMT FIXED ########### 1 mens pyadvoce genreate ho gayi hai

$genPA = self::funu2($genTBL,'genratePaymentAdvice','emp_id',$empid,'mpdr_program',$p,'id','DESC');
if($genPA==0){
	
	$getTotSalary = $getTotSalary_withouTGen_paymentAD;
	
}else{
	
	 $getTotSalary = self::funu2($genTBL,'approvedInvoiceAmt','emp_id',$empid,'mpdr_program',$p,'id','DESC');		
}

##################################################################################
	 
$getSalaryType = self::fununiversal('emp_posting_info','salaryType','emp_id',$empid);
	 
######------------

if($getSalaryType==3){
	
$totCAHour = self::fununiversal('emp_posting_info','contracthour','emp_id',$empid);
		
$table_name4           = DB.$genTBL;	
$where4                = "emp_id='".$empid."'"; 		
$rowDataLD4            =  self::select($table_name4,$where4,$bind4='','SUBSTRING(SEC_TO_TIME( SUM( TIME_TO_SEC(if_consultant_hourly_based ) ) ), 1, 5) AS total_time');

$rcTime =  $rowDataLD4[0];
$horuCount = $rcTime['total_time'];
$timeINexp = explode(':',$horuCount);
$minutes = ($timeINexp[0] * 60)+$timeINexp[1];	
$oneMinSal = $getTotSalary/60;
		 
	$givenSal= $minutes * $oneMinSal;
	
}else{
	$givenSal =  $getTotSalary;
}
	 
	 
//$invoicedAmt = ($prgPersentage / 100) * $givenSal;	

	// PA genreate ho gay hai 
if($genPA==0){		 
	 if($_SESSION['role']!='Consultant_B'){
       $invoicedAmt_otp = ($prgPersentage / 100) * $givenSal;
	 }else{
		$invoicedAmt_otp =  $givenSal; 
	 }
}else{
$invoicedAmt_otp =  $givenSal;	
} 

$leaveSummaryABC = self::invoiceLeaveModule($empid,base64_decode($y),base64_decode($m));
$ymGetABC =  date('Y-n',strtotime(base64_decode($y).'-'.base64_decode($m)));
$thisMonthAvaLeaveABC =  $leaveSummaryABC[$ymGetABC]['totalAvailable'];


if($genPA==0){	
//$conWorkDaysTotSimp =  self::fununiversalCount($genTBL,'emp_id',$empid);


$contractStartDate = self::fununiversal('emp_posting_info','contractStartDate','emp_id',$empid);
$contractEndDate = self::fununiversal('emp_posting_info','contractEndDate','emp_id',$empid);



$sundayInMonth = self::sundayCountInMonth(date('m',strtotime(base64_decode($m))),base64_decode($y),$contractStartDate,$contractEndDate);


$sundaysDatesNocount = self::getSundaysInContractRange(date('m',strtotime(base64_decode($m))),base64_decode($y),$contractStartDate,$contractEndDate);


$conWorkDaysTotSimp =  self::workingMPDRdaysCount($genTBL,'emp_id',$empid,$sundaysDatesNocount);




$dY = base64_decode($y);
$dM = date('m',strtotime(base64_decode($m)));
$dDate = $dY.'-'.$dM.'-01';

$lastDayInMonth = date('t',strtotime($dDate));
$daysForSalary  = $lastDayInMonth;

  
    //$getEKdinSal = $invoicedAmt_otp / $daysForSalary;
    //$invoicedAmt =  $getEKdinSal * ($conWorkDaysTotSimp + $sundayInMonth);  
	
	
	$extraLeave=0;
  $extraLeave = self::leaveCycle($empid,$thisMonthAvaLeaveABC,$dY,$dM);  
  
  
     $getEKdinSal =  $invoicedAmt_otp / $daysForSalary;	 
	 $leaveAmtDect = $getEKdinSal * $extraLeave;	
	 $invoicedAmt  = $invoicedAmt_otp - $leaveAmtDect;
	
	
	
	
  
}else{
	$invoicedAmt =  self::fununincuniversal($genTBL,'approvedInvoiceAmt','emp_id',$empid,'mpdr_program',$p);
}




	 
 }
	  	  
$ta2           =  DB.$genTBL;	
$wh2           =  "emp_id='".$empid."'  AND leaveApplicable > 0 AND leaveDay > 0 AND mpdr_program = '".$p."' ";	
$ro2           =  self::select($ta2,$wh2,$bi2='','*');
$rc2           =  $ro2[0];
$mt = explode(',',$rc2['emp_send_mpdr_program_group']);	  
   
   if($p==$mt[0]){
	   if($rc2['leaveDay'] > 0 ){
		   
		   
$contractStartDate = self::fununiversal('emp_posting_info','contractStartDate','emp_id',$empid);
$contractEndDate = self::fununiversal('emp_posting_info','contractEndDate','emp_id',$empid);


$sundayInMonth =  self::sundayCountInMonth(date('m',strtotime(base64_decode($m))),base64_decode($y),$contractStartDate,$contractEndDate);

$dY = base64_decode($y);
$dM = date('m',strtotime(base64_decode($m)));
$dDate = $dY.'-'.$dM.'-01';

$lastDayInMonth = date('t',strtotime($dDate));
$daysForSalary  = $lastDayInMonth;

  
    $getEKdinSal = $invoicedAmt_otp / $daysForSalary;		   
		   
		      
		   
		   $salDeducted =  $getEKdinSal * $rc2['leaveDay'];	
	   }else{
		   $salDeducted = '';	
	   }
	   
   }
   
   
  /* echo $invoicedAmt;
   echo '<br>';
   echo $salDeducted;
   	echo '<br>';*/  
	  
	  $stot = $invoicedAmt - $salDeducted;
	  
######
$gstYESNO = self::fununiversal('emp_personal_info','gstNo_yes_no','emp_id',$empid);

// $gstNo;
 $gstStateCode = self::fununiversal('gst_state_code','state','state_code',self::fununiversal('emp_personal_info','gstNo_state_code','emp_id',$empid));

$cgstTot='0.00';
$sgstTot='0.00';
$igstTot='0.00';
$cgst='@';
$sgst='@';
$igst='@';
$sign='%';
$signIGST='%';

if($gstStateCode == 'Delhi' && $gstYESNO=='Yes'){ 
 $cgst = CGST;
 $sgst = SGST;
 $sign = '%'; 

            $cgstAMT = $stot*CGST/100;
		    $cgstTot =  number_format($cgstAMT,2).' ';
		
		   $sgstAMT = $stot*SGST/100;
	       $sgstTot = number_format($sgstAMT,2).' ';
		   
}elseif($gstStateCode!= 'Delhi' && $gstYESNO=='Yes'){
	   
	       $igst = IGST;
           $signIGST = '%';	
	      $igstAMT = $stot*IGST/100;
	      $igstTot =  number_format($igstAMT,2).' ';
}	  
	  
	  $taxAdd = $cgstAMT+$sgstAMT+$igstAMT;
	  
	  
	  
	return $taxAdd;	
	
	  }	 
	
}

######################3
############################# invoice amount 
function invoiceAmountPartALeave($empid,$y,$m,$p){
  
$genTBL = strtolower('mpdr_'.base64_decode($m).'_'.base64_decode($y)); 
$onedaySal='';

$thisMonthStartDate = date('Y-m-d',strtotime(base64_decode($y).'-'.base64_decode($m).'-01'));
$thisMonthEndDate = date('Y-m-20',strtotime(base64_decode($y).'-'.base64_decode($m).'-20'));
	  	  
$ta2           =  DB.$genTBL;	
$wh2           =  "emp_id='".$empid."'  AND leaveApplicable > 0 AND leaveDay > 0 AND mpdr_date between '".$thisMonthStartDate."' AND  '".$thisMonthEndDate."' ";	
$ro2           =  self::select($ta2,$wh2,$bi2='','*');
$rc2           =  $ro2[0];






$mt = $rc2['mpdr_program'];	  
  
   if($p==$mt){
	 // echo $rc2['leaveApplicable'].' Rest/Off days adjusted with the fee.';	  
   $salary =  self::fununiversal('emp_posting_info','salary','emp_id',$empid);
	
		
$dY = base64_decode($_REQUEST['y']);
$dM = date('m',strtotime(base64_decode($_REQUEST['m'])));
$dDate = $dY.'-'.$dM.'-01';

$lastDayInMonth = date('t',strtotime($dDate));		
		 
		 
		 $onedaySal = $salary / $lastDayInMonth;
		 
		 $leaveDAT = $rc2['leaveDay'];
		 $stotDATA = $onedaySal * $leaveDAT;
		 
    }	  
	  
	 
	  
 	return $stotDATA;		
	
}
##########################################
function associate_stateWorkinEmpIncountdist($asoID,$stateID){

 $table_nameST           =  DB."emp_posting_info AS PO,".DB."emp_login AS LOG ";	
 $whereST                =  "PO.postingState='".$stateID."' AND LOG.associate_id='".$asoID."' AND LOG.id=PO.emp_id  ";
	
$rowCountST = self::selectCountOrder($table_nameST,$whereST,$bindST='','PO.postingDistrict');

return $rowCountST[0]['count(PO.postingDistrict)'];
}
############## enrol employee count state wise
function associate_stateWorkinEmpInCount($asoID,$stateID){
	
	$table_nameEMP           =  DB."emp_posting_info  AS PO, ".DB."emp_login  AS LOG";	
	$whereEMP                =  "PO.postingState='".$stateID."' AND PO.contract_issue_status > 0 AND LOG.status=1 AND LOG.id = PO.emp_id  AND LOG.associate_id='".$asoID."'  ";
	
		
$rowCountEMP              =  self::selectCount($table_nameEMP,$whereEMP,$bindEMP='');

	return $rowCountEMP[0]['count(*)'];
}
############## enrol RM count state wise
function associate_stateWorkinRMcountdist($asoID,$stateID){
	
 $table_nameRM           =  DB."emp_posting_info AS PO,".DB."emp_login AS LOG " ;	
 $whereRM  = "PO.postingState='".$stateID."'  AND LOG.status=1 AND LOG.id = PO.emp_id  AND LOG.associate_id='".$asoID."'  ";	
	
$rowCountRM              =  self::selectCountOrder($table_nameRM,$whereRM,$bindRM='','DISTINCT LOG.emp_reporting_manager_id');
return $rowCountRM[0]['count(DISTINCT LOG.emp_reporting_manager_id)'];
}
###################################
function associate_levaeTodayState($asoID,$stateID,$leveSUB='',$rmID=''){


	$table_name           =  DB."emp_posting_info, ".DB."emp_login";	
	$where                =  DB."emp_posting_info.postingState='".$stateID."' AND ".DB."emp_posting_info.contract_issue_status > 0 AND ".DB."emp_login.status=1 AND ".DB."emp_login.id = ".DB."emp_posting_info.emp_id  AND ".DB."emp_login.associate_id='".$asoID."'   ";


//$bind               =  array(":emp_reporting_manager_id"=>$_SESSION['idRM']);		
$rowData              =  self::select($table_name,$where,$bind='',"*");	
	
	foreach($rowData as $k=>$lval){
		$em[]=$lval['emp_id'];
		
		$empID = implode(",",$em);
	}
	

$leaveCurrentDate = date('Y-m-d');	
$table_name55  = DB."apply_leave";	

$where55 = " (startDate BETWEEN '".$leaveCurrentDate."' AND '".$leaveCurrentDate."' OR endDate BETWEEN '".$leaveCurrentDate."' AND '".$leaveCurrentDate."') AND  emp_cancel_leave_status = 0  AND leave_Approved='1' AND emp_id IN(".$empID.")  ";

 
$rowDataLD55     =  self::selectCount($table_name55,$where55,$bind55='');

return $rowDataLD55[0]['count(*)'];	

	
}

################################# consulatnt B
function consultantB_deli($empID){
	
	$table_name           =  DB."deliverable";	
	$where                =  "emp_id='".$empID."' AND status=1 ";
$rowData              =  self::select($table_name,$where,$bind='',"*");	
	
	foreach($rowData as $k=>$lval){
		$em[]=$lval['id'];
		
		$deid = implode(",",$em);
	}
	return $deid;
}
########################################################
function getRMMpdrTbl($empId,$y,$m,$fld){
$genTBL = strtolower('mpdr_'.$m.'_'.$y); 	
$getCountTBL = self::check_table_exist_or_not($genTBL);	 
 
 if($getCountTBL === 1) {
	 
$table_name           =  DB.$genTBL;	
$where                =  "emp_id='".$empId."'  ";
$rowData              =  self::select($table_name,$where,$bind='',"rm_id");	
$rm                   =  $rowData[0];

if($rm['rm_id'] > 0){// jab rm invoice approve karega tab hi us ki id mile gi
	return self::fununiversal('emp_login',$fld,'id',$rm['rm_id']);
}else{
	
$table_name           =  DB."emp_login";	
$where                =  "id='".$empId."'  ";
$rowData              =  self::select($table_name,$where,$bind='',"emp_reporting_manager_id");	
$rm                   = $rowData[0]; 
return self::fununiversal('emp_login',$fld,'id',$rm['emp_reporting_manager_id']);	
} 
		 
 }else{// tble not genreate
	 
$table_name           =  DB."emp_login";	
$where                =  "id='".$empId."'  ";
$rowData              =  self::select($table_name,$where,$bind='',"emp_reporting_manager_id");	
$rm                   = $rowData[0]; 
return self::fununiversal('emp_login',$fld,'id',$rm['emp_reporting_manager_id']);
 }
	
}

##################RM deg get MPDR ########################
function getRMDeginationMpdrTbl($empId,$y,$m){
$genTBL = strtolower('mpdr_'.$m.'_'.$y); 	
$getCountTBL = self::check_table_exist_or_not($genTBL);	 
 
 if($getCountTBL === 1) {
	 
$table_name           =  DB.$genTBL;	
$where                =  "emp_id='".$empId."'  ";
$rowData              =  self::select($table_name,$where,$bind='',"rm_id");	
$rm                   =  $rowData[0];

if($rm['rm_id'] > 0){// jab rm invoice approve karega tab hi us ki id mile gi
	return stripslashes(self::fununiversal('department_designation','department_designation','id',self::fununiversal('reportingmanagerprofile','postingDesignation','rm_id',$rm['rm_id'])));
}else{
	
$table_name           =  DB."emp_login";	
$where                =  "id='".$empId."'  ";
$rowData              =  self::select($table_name,$where,$bind='',"emp_reporting_manager_id");	
$rm                   = $rowData[0]; 
return stripslashes(self::fununiversal('department_designation','department_designation','id',self::fununiversal('reportingmanagerprofile','postingDesignation','rm_id',$rm['emp_reporting_manager_id'])));	
} 
		 
 }else{// tble not genreate
	 
$table_name           =  DB."emp_login";	
$where                =  "id='".$empId."'  ";
$rowData              =  self::select($table_name,$where,$bind='',"emp_reporting_manager_id");	
$rm                   = $rowData[0]; 

return stripslashes(self::fununiversal('department_designation','department_designation','id',self::fununiversal('reportingmanagerprofile','postingDesignation','rm_id',$rm['emp_reporting_manager_id'])));

 }	
}
#################################################################
function getRMMpdrTblSignature($empId,$y,$m){
$genTBL = strtolower('mpdr_'.$m.'_'.$y); 	
$getCountTBL = self::check_table_exist_or_not($genTBL);	 
 
 if($getCountTBL === 1) {
	 
$table_name           =  DB.$genTBL;	
$where                =  "emp_id='".$empId."'  ";
$rowData              =  self::select($table_name,$where,$bind='',"rm_id");	
$rm                   =  $rowData[0];

if($rm['rm_id'] > 0){// jab rm invoice approve karega tab hi us ki id mile gi	 
return	self::fununiversal('reportingmanagerprofile','rm_sign','rm_id',$rm['rm_id']);
}else{
	
$table_name           =  DB."emp_login";	
$where                =  "id='".$empId."'  ";
$rowData              =  self::select($table_name,$where,$bind='',"emp_reporting_manager_id");	
$rm                   = $rowData[0]; 
return self::fununiversal('reportingmanagerprofile','rm_sign','rm_id',$rm['emp_reporting_manager_id']);
} 
		 
 }else{// tble not genreate
	 
$table_name           =  DB."emp_login";	
$where                =  "id='".$empId."'  ";
$rowData              =  self::select($table_name,$where,$bind='',"emp_reporting_manager_id");	
$rm                   = $rowData[0]; 

return self::fununiversal('reportingmanagerprofile','rm_sign','rm_id',$rm['emp_reporting_manager_id']);
 }
	
}
#################################################

function remBmonthAmt($empID,$templateID,$ca_eca,$fld=''){

	if($ca_eca=='ca'){	
		$table_name           =  DB."emp_posting_info";	
		$where                =  "emp_id='".$empID."' AND partB='".$templateID."'  ";
		$rowData              =  self::select($table_name,$where,$bind='',$fld);	
		$rm                   = $rowData[0]; 
		return $rm[$fld];
	}else{
		$table_name           =  DB."extension_contract";	
		$where                =  "emp_id='".$empID."' AND reimbursementPart='".$templateID."'  ";
		$rowData              =  self::select($table_name,$where,$bind='',$fld);	
		$rm                   = $rowData[0]; 
		return $rm[$fld];	
	}	
}
#################################################

function remBmonthAmtTotal($empID){
$t_remb_ci           =  DB."reimbursement";	
$w_remb_ci           =  "emp_id='".$empID."' ";	
//$b_remb_ci           =  array(":emp_id"=>$empID);		
$r_remb_ci           =  self::select($t_remb_ci,$w_remb_ci,$b_remb_ci='',"*");

$t1Amt = 0;
$t2Amt = 0;
$t3Amt = 0;
foreach($r_remb_ci as $rK=>$rVal){
	if($rVal['template']==1  && $rVal['ca_eca']=='ca'){ // CA)
		$tmp1 = 2500 * $rVal['t1_1'];
		$tmp2 = 2000 * $rVal['t1_2'];
		$tmp3 = 1500 * $rVal['t1_3'];
		$tmp4 = 1200 * $rVal['t1_4'];
		$tmp5 = 7650 * $rVal['t1_5'];		
		$tmp6 = 6500 * $rVal['t1_6'];
		$tmp7 = 5300 * $rVal['t1_7'];
		$tmp8 = 3500 * $rVal['t1_8'];
		
		$tmp9 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'bb9') * $rVal['t1_9'];
		$tmp10 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'bb10') * $rVal['t1_10'];
		$tmp11 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'bb11') * $rVal['t1_11'];
		$tmp12 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'bb12') * $rVal['t1_12'];
		$tmp13 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'bb13') * $rVal['t1_13'];		
		
		 $monthWISEamt+= $tmp1 + $tmp2 + $tmp3 + $tmp4 + $tmp5 + $tmp6 + $tmp7 + $tmp8 + $tmp9 + $tmp10 + $tmp11 + $tmp12 + $tmp13;
		
	}else{ //eca
	$tmp1 = self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t1_rate')  * $rVal['t1_1'];
	$tmp2 = self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t2_rate') * $rVal['t1_2'];
	$tmp3 = self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t3_rate') * $rVal['t1_3'];
	$tmp4 = self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t4_rate') * $rVal['t1_4'];
	$tmp5 = self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t5_rate') * $rVal['t1_5'];		
	$tmp6 = self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t6_rate') * $rVal['t1_6'];
	$tmp7 = self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t7_rate') * $rVal['t1_7'];
	$tmp8 = self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t8_rate') * $rVal['t1_8'];
	
$tmp9 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t9_rate') * $rVal['t1_9'];
$tmp10 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t10_rate') * $rVal['t1_10'];
$tmp11 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t11_rate') * $rVal['t1_11'];
$tmp12 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t12_rate') * $rVal['t1_12'];
$tmp13 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t13_rate') * $rVal['t1_13'];		
	
		 $monthWISEamt+= $tmp1 + $tmp2 + $tmp3 + $tmp4 + $tmp5 + $tmp6 + $tmp7 + $tmp8 + $tmp9 + $tmp10 + $tmp11 + $tmp12 + $tmp13;
	}
			
	if($rVal['template']==2 && $rVal['ca_eca']=='ca'){ // CA)
		 $monthWISEamt+= $rVal['t2_1'];
	}else{
		$monthWISEamt+= $rVal['t2_1'];
	}

	if($rVal['template']==3 && $rVal['ca_eca']=='ca'){ // CA
		$tmp_3_1 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'partB_template3_amt_1') * $rVal['t3_1'];
		$tmp_3_2 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'partB_template3_amt_2') * $rVal['t3_2'];
		$tmp_3_3 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'partB_template3_amt_3') * $rVal['t3_3'];
		$tmp_3_4 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'partB_template3_amt_4') * $rVal['t3_4'];
		$tmp_3_5 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'partB_template3_amt_5') * $rVal['t3_5'];
		$tmp_3_6 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'partB_template3_amt_6') * $rVal['t3_6'];		
		 $monthWISEamt+= $tmp_3_1 + $tmp_3_2 + $tmp_3_3 + $tmp_3_4 + $tmp_3_5 + $tmp_3_6;		
	
	}else{   ///eca
	
		 $tmp_3_1 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t3_amt_1') * $rVal['t3_1'];
		$tmp_3_2 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t3_amt_2') * $rVal['t3_2'];
		$tmp_3_3 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t3_amt_3') * $rVal['t3_3'];
		$tmp_3_4 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t3_amt_4') * $rVal['t3_4'];
		$tmp_3_5 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t3_amt_5') * $rVal['t3_5'];
		$tmp_3_6 =  self::remBmonthAmt($rVal["emp_id"],$rVal['template'],$rVal['ca_eca'],'t3_amt_6') * $rVal['t3_6'];		
		 $monthWISEamt+= $tmp_3_1 + $tmp_3_2 + $tmp_3_3 + $tmp_3_4 + $tmp_3_5 + $tmp_3_6;		
	}	
}
 return $monthWISEamt;
	
}

################# reimbursement get previous value    #######################

function caReimPrevVal($empID,$fld){
$t_remb_ci           =  DB."emp_posting_info";	
echo $w_remb_ci           =  "emp_id='".$empID."' ";	
$r_remb_ci           =  self::select($t_remb_ci,$w_remb_ci,$b_remb_ci='',$fld);
$prvVal              =  $r_remb_ci[0];
return $prvVal[$fld];
}
#--------------
function caReimPrevValECA($empID,$fld){
$t_remb_ci           =  DB."extension_contract";	
echo $w_remb_ci      =  "emp_id='".$empID."' ";	
$r_remb_ci           =  self::select($t_remb_ci,$w_remb_ci,$b_remb_ci='',$fld);
$prvVal              =  $r_remb_ci[0];
return $prvVal[$fld];
}

##########################################################
function wh_log($log_msg) {
    $log_filename = FILEPATH."log";
    if (!file_exists($log_filename))
    {
        // create directory/folder uploads.
        mkdir($log_filename, 0777, true);
    }
#----------	
@unlink($log_filename.'/log_' . date("d-M-Y", strtotime("-15 day")) . '.txt');
#-----		
    $log_file_data = $log_filename.'/log_' . date('d-M-Y') . '.txt';
    file_put_contents($log_file_data, $log_msg . "\n", FILE_APPEND);
}
function wh_log_addEmap($log_msg) {
    $log_filename = FILEPATH."log/addEmp";
    if (!file_exists($log_filename))
    {
        // create directory/folder uploads.
        mkdir($log_filename, 0777, true);
    }
#----------	
@unlink($log_filename.'/log_' . date("d-M-Y", strtotime("-15 day")) . '.txt');
#-----	
	
    $log_file_data = $log_filename.'/log_' . date('d-M-Y') . '.txt';
    file_put_contents($log_file_data, $log_msg . "\r\n", FILE_APPEND);
}
function wh_log_payementInvoice($log_msg) {
    $log_filename = FILEPATH."log/paymentInvoice";
    if (!file_exists($log_filename))
    {
        // create directory/folder uploads.
        mkdir($log_filename, 0777, true);
    }
#----------	
@unlink($log_filename.'/log_' . date("d-M-Y", strtotime("-15 day")) . '.txt');
#-----	
    $log_file_data = $log_filename.'/log_' . date('d-M-Y') . '.txt';
    file_put_contents($log_file_data, $log_msg . "\r\n", FILE_APPEND);
}
##############################################################################
function mpdrtbleDta($y,$m,$empID,$prID,$fld){
	
	$createTableName = 'mpdr_'.base64_decode($m).'_'.base64_decode($y);
    $tableName = strtolower($createTableName);
	$getCountTBL = self::check_table_exist_or_not($tableName);	
    if($getCountTBL === 1) {
		
		$table_name           =  DB.$tableName;		
		$where = "  mpdrActivities!='Leave' AND emp_id='".$empID."' AND mpdr_program='".$prID."' ";	
		$rowData =  self::select($table_name,$where,$bind='',$fld);
		$r       =  $rowData[0];
		return $r[$fld];		
	}
}
################################# Sal record
function contractSalRec($empID){
	
	$table_name           =  DB."consultant_salary_records";	
	$where                =  "emp_id='".$empID."' ";
    $rowData              =  self::select($table_name,$where,$bind='',"tot_sal_ca_periods");	
	
	foreach($rowData as $k=>$lval){
		$emSAL+=$lval['tot_sal_ca_periods'];
	}
	return $emSAL;
}
################################# Sal paid
function paidTillSalary($empID){
	
	$table_name           =  DB."emp_posting_info";	
	$where                =  "emp_id='".$empID."' ";
    $rowData              =  self::select($table_name,$where,$bind='',"*");	
	$cdata                =  $rowData[0];
	
$date1 = strtotime($cdata['contractStartDate']);
$date2 = strtotime($cdata['contractEnddate']);

while ($date1 <= $date2) {
   $mDate = date('Y-m-d', $date1);
   $montDate = date('F_Y', strtotime($mDate));
   $tableName = strtolower('mpdr_'.$montDate);
  
   $getCountTBL = self::check_table_exist_or_not($tableName);	
    if($getCountTBL === 1) {
		$table_name           =  DB.$tableName;		
		$where = "  mpdrActivities!='Leave' AND emp_id='".$empID."' AND genratePaymentAdvice=1 ";	
		$rowData =  self::select($table_name,$where,$bind='','approvedInvoiceAmt');
		$r       =  $rowData[0];
		$totAMT+= $r['approvedInvoiceAmt'];		
	}
  
  $date1 = strtotime('+1 month', $date1);
}	
	return $totAMT;
	
}
#############################################################
function zeroDiv($numerator, $denominator) {	
	
    // Added a check for zero denominator to prevent DivisionByZeroError
    if ($denominator == 0 ) {
        return 0; // Or handle the scenario appropriately based on application logic
    }	
    return ($numerator / $denominator);
}
#################################################################
function jpCalFun($tblName,$fld,$empID,$mpdrDate){
	$table_name           =  $tblName;	
	$where                =  "emp_id='".$empID."'  AND mpdr_date='".$mpdrDate."' ";
    $rowData              =  self::select($table_name,$where,$bind='',$fld);
	$r                    =  $rowData[0];
	return $r[$fld];	
}

################### 
function holiTitle($hdate){
	
	//echo "holidays_date='".$hdate."'";
		
    $table_name           =  DB."emp_holidays";	
	$where                =  "holidays_date='".$hdate."'";
    $rowData              =  self::select($table_name,$where,$bind='',"*");	
	$cdata                =  $rowData[0];
	return $aaa =  trim($cdata['holidays_title']);
 //return "holidays_date='".$hdate."'";

}

##############################
function getCorrectMonthsCount($startDate, $endDate) {
    $start = new DateTime($startDate);
    $end = new DateTime($endDate);

    // Calculate the difference in years, months, and days
    $diff = $start->diff($end);

    // Convert years into months and add remaining months
    $months = ($diff->y * 12) + $diff->m;

    // If the day of end date is greater than or equal to start date, count as full month
    if ($diff->d >= 0) {
        $months += 1;
    }

    return $months.' months';
}

###################################### sunday Count 
//$months = 12;  
//$years=2016;   
function sundayCountInMonth2222($months,$years){ 
                                  
$monthName = date("F", mktime(0, 0, 0, $months));
$fromdt=date('Y-m-01 ',strtotime("First Day Of  $monthName $years")) ;
$todt=date('Y-m-d ',strtotime("Last Day of $monthName $years"));

$num_sundays='';                
for ($i = 0; $i < ((strtotime($todt) - strtotime($fromdt)) / 86400); $i++)
{
    if(date('l',strtotime($fromdt) + ($i * 86400)) == 'Sunday')
    {
            $num_sundays++;
    }    
}
return $num_sundays;
}

######################
function sundayCountInMonth($month, $year, $contractStartDate, $contractEndDate) {
    $startOfMonth = strtotime("$year-$month-01");
    $endOfMonth = strtotime(date('Y-m-t', $startOfMonth)); // Last day of month

    $contractStart = strtotime($contractStartDate);
    $contractEnd = strtotime($contractEndDate);

    // Set start date (maximum of month start or contract start)
    if ($contractStart < $startOfMonth) {
        $currentDate = $startOfMonth;
    } else {
        $currentDate = $contractStart;
    }

    // Set end date (minimum of month end or contract end)
    if ($contractEnd > $endOfMonth) {
        $endDate = $endOfMonth;
    } else {
        $endDate = $contractEnd;
    }

    $sundayCount = 0;

    while ($currentDate <= $endDate) {
        if (date('w', $currentDate) == 0) { // Sunday
            $sundayCount++;
        }
        $currentDate = strtotime('+1 day', $currentDate); // Add 1 day
    }

    return $sundayCount;
}


#####################
	function getSundaysInContractRange($month, $year, $contractStartDate, $contractEndDate) {
    $startOfMonth = strtotime("$year-$month-01");
    $endOfMonth = strtotime(date('Y-m-t', $startOfMonth)); // Last day of month

    $contractStart = strtotime($contractStartDate);
    $contractEnd = strtotime($contractEndDate);

    // Set actual range to check
    $startDate = max($startOfMonth, $contractStart);
    $endDate = min($endOfMonth, $contractEnd);

    $sundays = [];

    $currentDate = $startDate;

    while ($currentDate <= $endDate) {
        if (date('w', $currentDate) == 0) { // Sunday
            $sundays[] = date('Y-m-d', $currentDate);
        }
        $currentDate = strtotime('+1 day', $currentDate);
    }

     $sun = implode("','",$sundays);


    return $sun;
}
#####################

function getSundaysInCycle($month, $year, $contractStartDate, $contractEndDate, $format = 'array') {
    $monthNum = is_numeric($month) ? (int)$month : (int)date('n', strtotime($month));
    $year = (int)$year;

    $cycleStartStr = date('Y-m-d', strtotime(sprintf('%04d-%02d-21', $year, $monthNum) . ' -1 month'));
    $cycleEndStr   = date('Y-m-d', strtotime(sprintf('%04d-%02d-20', $year, $monthNum)));

    $cycleStartTs = strtotime($cycleStartStr);
    $cycleEndTs   = strtotime($cycleEndStr);

    $contractStartTs = strtotime($contractStartDate);
    $contractEndTs   = strtotime($contractEndDate);

    if ($contractStartTs === false || $contractEndTs === false) {
        return ($format === 'array') ? [] : '';
    }

    $startTs = max($cycleStartTs, $contractStartTs);
    $endTs   = min($cycleEndTs, $contractEndTs); // ✅ removed todayTs restriction

    if ($startTs > $endTs) {
        return ($format === 'array') ? [] : '';
    }

    $startTs = strtotime(date('Y-m-d', $startTs));
    $endTs   = strtotime(date('Y-m-d', $endTs));

    $firstSunday = (date('w', $startTs) == 0) ? $startTs : strtotime('next Sunday', $startTs);

    $sundays = [];
    for ($d = $firstSunday; $d <= $endTs; $d = strtotime('+1 week', $d)) {
        $sundays[] = date('Y-m-d', $d);
    }

    if ($format === 'array') {
        return $sundays;
    } elseif ($format === 'in') {
        return count($sundays) ? "'" . implode("','", $sundays) . "'" : '';
    } else {
        return implode(", ", $sundays);
    }
}


	
function getSundaysInCycle123OLD($month, $year, $contractStartDate, $contractEndDate, $format = 'array') {
    // normalize month/year
    $monthNum = is_numeric($month) ? (int)$month : (int)date('n', strtotime($month));
    $year = (int)$year;

    // Cycle: previous month 21st -> current month 20th
    $cycleStartStr = date('Y-m-d', strtotime(sprintf('%04d-%02d-21', $year, $monthNum) . ' -1 month'));
    $cycleEndStr   = date('Y-m-d', strtotime(sprintf('%04d-%02d-20', $year, $monthNum)));

    $cycleStartTs = strtotime($cycleStartStr);
    $cycleEndTs   = strtotime($cycleEndStr);

    // Validate contract dates
    $contractStartTs = strtotime($contractStartDate);
    $contractEndTs   = strtotime($contractEndDate);

    if ($contractStartTs === false || $contractEndTs === false) {
        // invalid contract dates => return empty
        return ($format === 'array') ? [] : '';
    }

    // actual intersection
    $startTs = max($cycleStartTs, $contractStartTs);
    $endTs   = min($cycleEndTs, $contractEndTs);

    if ($startTs > $endTs) {
        return ($format === 'array') ? [] : '';
    }

    // normalize to midnight dates
    $startTs = strtotime(date('Y-m-d', $startTs));
    $endTs   = strtotime(date('Y-m-d', $endTs));

    // find first Sunday on/after $startTs
    if (date('w', $startTs) == 0) {
        $firstSunday = $startTs;
    } else {
        $firstSunday = strtotime('next Sunday', $startTs);
    }

    $sundays = [];
    for ($d = $firstSunday; $d <= $endTs; $d = strtotime('+1 week', $d)) {
        $sundays[] = date('Y-m-d', $d);
    }

    if ($format === 'array') {
        return $sundays;
    } elseif ($format === 'in') {
        return count($sundays) ? "'" . implode("','", $sundays) . "'" : '';
    } else { // default string CSV
        return implode(", ", $sundays);
    }
}
########################## cycle sunday dates 
function isNumber($value) {
    if ($value === '') return false; // empty string को number मत मानो
    for ($i = 0; $i < strlen($value); $i++) {
        if ($value[$i] < '0' || $value[$i] > '9') {
            return false; // कोई non-digit मिला
        }
    }
    return true;
}
###################################################
function getSundaysDates($monthName, $year) {
	
	    $input = trim($monthName);
	  
	    if(self::isNumber($input)) {
		    $abc = 1;
		}else{
			$abc = 0;
		}

	if($abc==0){
	     $month = date('m',strtotime($monthName));
	}else{
		 $month = $monthName;
	}
	
    $sundays = [];

    // Start date (day, month, year)
    $day = 21;
    $m = $month - 1;
    $y = $year;

    // End date = 20 of next month
    $endDay = 20;
    $endMonth = $month;
    $endYear = $year;
    if ($endMonth > 12) {
        $endMonth = 1;
        $endYear++;
    }

    // Convert start and end into timestamps
    $start = mktime(0, 0, 0, $m, $day, $y);
    $end = mktime(0, 0, 0, $endMonth, $endDay, $endYear);

    // Loop each day
    for ($t = $start; $t <= $end; $t += 86400) { // 86400 = 1 day in seconds
        if (date("w", $t) == 0) { // 0 = Sunday
            $sundays[] = date("Y-m-d", $t);
        }
    }

    return $sundays;
	
}
########################################
####################################
function getOffSaturdayDates($monthName, $year, $empID) {
$satOffYesNo = self::fununiversal('emp_posting_info','sat_off_yes_no','emp_id',$empID);
$offSat = [];

if($satOffYesNo == 1){
    $offSat = self::fununiversal('emp_posting_info','no_sat','emp_id',$empID); // e.g. "1,3"
    $offSat = explode(',', $offSat);
}

$month = self::isNumber($monthName) ? $monthName : date('m', strtotime($monthName));

$saturdays = [];

$startDate = self::fununiversal('emp_posting_info','contractStartDate','emp_id',$empID);
$start = strtotime($startDate);
$end   = strtotime(date('Y-m-t', strtotime($year.'-'.$month)));

$saturdayCount = 0;
$currentMonth = date('m', $start);

for($t = $start; $t <= $end; $t = strtotime("+1 day", $t)) {
    $monthNow = date('m', $t);
    if($monthNow != $currentMonth){
        $saturdayCount = 0;
        $currentMonth = $monthNow;
    }

    if(date("w", $t) == 6) {
        $saturdayCount++;
        if(in_array($saturdayCount, $offSat)) {
            $saturdays[] = date("Y-m-d", $t);
        }
    }
}

return $saturdays;
}


#######################################################################
function workingMPDRdaysCount($m,$y,$condition){
	 	
 $yearNameInt =  $y;   
	    if(self::isNumber($m)) {
		    $abc = 1;
		}else{
			$abc = 0;
		}

	if($abc==0){
	     $monthNameSm = $m;
	}else{
		 $monthNameSm = strtolower(date('F', mktime(0, 0, 0, (int)$m, 1))); 
	}
 
 
 $genTBL = 'mpdr_'.$monthNameSm.'_'.$yearNameInt;
  
 $ym_1 = date('Y-m',strtotime($y.'-'.$m));
 $getPreviousMonthAndYear_1 =  date("Y-m", strtotime("$ym_1 -1 month"));

$nmonth_1 = date("F_Y", strtotime($getPreviousMonthAndYear_1));
$genTBLPmonth_1 = strtolower('mpdr_'.$nmonth_1);


$prvMonthDate21 = date('Y-m-d',strtotime($getPreviousMonthAndYear_1.'-21'));
$currMonthDate20 = date('Y-m-d',strtotime($ym_1.'-20'));


// Example: September 2025
$sunDateArr = self::getSundaysDates($m,$y);
///print_r($sunDateArr);
$sunDateComm = implode("','",$sunDateArr);

############## get emp sat days off dates  #####################
$saturdayDateArr = self::getOffSaturdayDates($m,$y,$condition);
//print_r($saturdayDateArr);
$satDateComm = implode("','",$saturdayDateArr);
################################################################


    $table_name = DB .$genTBLPmonth_1." ";					
    $where=" emp_id = '".$condition."'
AND mpdr_date >= '".$prvMonthDate21."' AND mpdr_date NOT IN('".$sunDateComm."') AND mpdr_date NOT IN('".$satDateComm."')   ";				
 		
		 $rowData       =  self::selectCount($table_name,$where,$bind='');											
		 $row  		   =  $rowData[0]['count(*)'];
		
  $table_name2 = DB .$genTBL." ";					
   $where2=" emp_id = '".$condition."'
AND mpdr_date <= '".$currMonthDate20."' AND mpdr_date NOT IN('".$sunDateComm."') AND mpdr_date NOT IN('".$satDateComm."')  ";				
 		
		$rowData2       =  self::selectCount($table_name2,$where2,$bind2='');											
		$row2  		   =  $rowData2[0]['count(*)'];
		
################ agar 2 halfday hai means working day 1 	##############
$table_name     =  DB."apply_leave";	
$where          =  "leave_Approved=1 AND emp_id='".$condition."' AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL) AND halfDayDate between '".$prvMonthDate21."' AND '".$currMonthDate20."' ";	
	
$roCount        =  self::selectCount($table_name,$where,$bind='');	

if($roCount[0]['count(*)'] >=1){	
	$cval = $roCount[0]['count(*)'];	
	$halfDaysCount = $cval * 0.5;	
}else{
	$halfDaysCount =  0;
	
}
#####################################################################
		return ($row + $row2);	

}
####################################

function getBeforeCount($givenDate, $dates) {
    list($gYear, $gMonth, $gDay) = explode("-", $givenDate); // ध्यान दो: format Y-m-d है
    $count = 0;

    foreach ($dates as $d) {
        list($sYear, $sMonth, $sDay) = explode("-", $d);

        // Manual comparison
        if ($sYear < $gYear) {
            $count++;
        } elseif ($sYear == $gYear) {
            if ($sMonth < $gMonth) {
                $count++;
            } elseif ($sMonth == $gMonth && $sDay < $gDay) {
                $count++;
            }
        }
    }
    return $count;
}
##################
function satsun($emp_id,$firstFillDateMPDR){
	 	
	 $contract_start_date =self::fununiversal('emp_posting_info','contractStartDate','emp_id',$emp_id);
	
if (strtotime($contract_start_date) < strtotime($firstFillDateMPDR)) {
    //echo "Yes";
	$oneDayBefore = date("Y-m-d", strtotime("-1 day", strtotime($firstFillDateMPDR)));
	
	 $day = date("l", strtotime($oneDayBefore)); // Get day name (Sunday, Monday, etc.)
	if ($day == "Sunday" || $day == "Saturday") {
        $ex = 1;
    } else {
        $ex = 0;
    }
	
	
} else {
	//echo 'No';
    $ex = 0;
}
    return $ex;
}








function getBetweenCount($startDate, $endDate, $dates) {	
	  //print_r($dates);	 
	  //echo $startDate.'---'. $endDate;
	
	// सुनिश्चित करें कि तारीखें सही फॉर्मेट में हैं (Y-m-d)
    $start = strtotime($startDate);
    $end = strtotime($endDate);
    $count = 0;

    foreach ($dates as $d) {
        $current = strtotime($d);
        if ($current >= $start && $current <= $end) {
            $count++;
        }
    }
	
	$tempDec25 = date('Y-m',strtotime($endDate));
	
	if($tempDec25=='2025-12'){
		$tempDec25Satadd = 1;
	}else{
		$tempDec25Satadd = 0;
	}	
	
    return $count + $tempDec25Satadd;
	
}













###########################################
function lastFilledMPDRdate($emp_id,$m,$y){
	
	   $yearNameInt =  $y;  
	    if(self::isNumber($m)) {
		    $abc = 1;
		}else{
			$abc = 0;
		}

	if($abc==0){
	     $monthNameSm = $m;
	}else{
		 $monthNameSm = strtolower(date('F', mktime(0, 0, 0, (int)$m, 1))); 
	}
 
 
 $genTBL = 'mpdr_'.$monthNameSm.'_'.$yearNameInt;
  
 $ym_1 = date('Y-m',strtotime($y.'-'.$m));
 $getPreviousMonthAndYear_1 =  date("Y-m", strtotime("$ym_1 -1 month"));

$nmonth_1 = date("F_Y", strtotime($getPreviousMonthAndYear_1));
$genTBLPmonth_1 = strtolower('mpdr_'.$nmonth_1);


$prvMonthDate21 = date('Y-m-d',strtotime($getPreviousMonthAndYear_1.'-21'));
$currMonthDate20 = date('Y-m-d',strtotime($ym_1.'-20'));

$sql = '
    SELECT MAX(mpdr_date) AS max_mpdr_date
    FROM (
        SELECT mpdr_date 
        FROM '.DB.$genTBL.' 
        WHERE emp_id = "'.$emp_id.'" 
          AND mpdr_date BETWEEN "'.$prvMonthDate21.'" AND "'.$currMonthDate20.'"

        UNION ALL

        SELECT mpdr_date 
        FROM '.DB.$genTBLPmonth_1.' 
        WHERE emp_id = "'.$emp_id.'" 
          AND mpdr_date BETWEEN "'.$prvMonthDate21.'" AND "'.$currMonthDate20.'"
    ) AS combined
';

//$bind = [":emp_id" => $emp_id];

$rowDL = self::select2($sql, $bind='');  // <-- मान लो select_query raw SQL चलाता है

return $rowDL[0]['max_mpdr_date'];

}
###################first###################
function firstFilledMPDRdate($emp_id,$m,$y){
	
	   $yearNameInt =  $y;  
	    if(self::isNumber($m)) {
		    $abc = 1;
		}else{
			$abc = 0;
		}

	if($abc==0){
	     $monthNameSm = $m;
	}else{
		 $monthNameSm = strtolower(date('F', mktime(0, 0, 0, (int)$m, 1))); 
	}
 
 
 $genTBL = 'mpdr_'.$monthNameSm.'_'.$yearNameInt;
  
 $ym_1 = date('Y-m',strtotime($y.'-'.$m));
 $getPreviousMonthAndYear_1 =  date("Y-m", strtotime("$ym_1 -1 month"));

$nmonth_1 = date("F_Y", strtotime($getPreviousMonthAndYear_1));
$genTBLPmonth_1 = strtolower('mpdr_'.$nmonth_1);


$prvMonthDate21 = date('Y-m-d',strtotime($getPreviousMonthAndYear_1.'-21'));
$currMonthDate20 = date('Y-m-d',strtotime($ym_1.'-20'));

$sql = '
    SELECT MIN(mpdr_date) AS max_mpdr_date
    FROM (
        SELECT mpdr_date 
        FROM '.DB.$genTBL.' 
        WHERE emp_id = "'.$emp_id.'" 
          AND mpdr_date BETWEEN "'.$prvMonthDate21.'" AND "'.$currMonthDate20.'"

        UNION ALL

        SELECT mpdr_date 
        FROM '.DB.$genTBLPmonth_1.' 
        WHERE emp_id = "'.$emp_id.'" 
          AND mpdr_date BETWEEN "'.$prvMonthDate21.'" AND "'.$currMonthDate20.'"
    ) AS combined
';

//$bind = [":emp_id" => $emp_id];

$rowDL = self::select2($sql, $bind='');  // <-- मान लो select_query raw SQL चलाता है

return $rowDL[0]['max_mpdr_date'];

}






#######################################################################
function montlyLeaveCount($empID){
	$yrC = date('Y');
	$yrN = date('Y', strtotime('+1 year'));
	
	$startFinYar = date('Y-m-d',strtotime($yrC.'-04-01'));
	$endFinYar   = date('Y-m-d',strtotime($yrN.'-03-31'));
	

$table_name     =  DB."apply_leave";	
$where          =  "leave_Approved=1 AND emp_id='".$empID."' AND startDate >= '".$startFinYar."' AND endDate <= '".$endFinYar."' GROUP BY emp_id, DATE_FORMAT(startDate, '%Y-%m') ORDER BY emp_id, month  ";	
	
$rowData        =  self::select($table_name,$where,$bind='',"DATE_FORMAT(startDate, '%Y-%m') AS month,
    SUM(leaveDays) AS total_leaves");											
return $rowData;	

}


##############################  carray forward leave #################################
function getMonthlyLeaveEntitlement($contractStartDate, $month, $year) {
    $start = strtotime($contractStartDate);
    $monthStart = strtotime("$year-$month-01");
    $midMonth = strtotime("$year-$month-15");

    if (date('Y-m', $start) == date('Y-m', $monthStart)) {
        return ($start <= $midMonth) ? 2.5 : 1;
    }

    if ($start < $monthStart) {
        return 2.5;
    }

    return 0;
}

function getMonthlyLeaveEntitlement_againChang_1_15($contractStartDate, $month, $year) {
    $start = strtotime($contractStartDate);

    // Current month ka 5th, 20th aur 21st
    $month5th   = strtotime("$year-$month-05");
    $month20th  = strtotime("$year-$month-20");
    $month21st  = strtotime("$year-$month-21");

    // Next month ka 4th
    $nextMonth4th = strtotime(date("Y-m-04", strtotime("+1 month", $month5th)));

    // Case 1: Agar join isi month me hai
    if (date('Y-m', $start) == date('Y-m', $month5th)) {
        if ($start >= $month5th && $start <= $month20th) {
            return 1;   // 5th to 20th
        }
        if ($start >= $month21st && $start <= $nextMonth4th) {
            return 2.5; // 21st to next month 4th
        }
    }

    // Case 2: Agar employee is month ke 5th se pehle join kar chuka hai
    if ($start < $month5th) {
        return 2.5;
    }

    // Case 3: Agar abhi join hi nahi hua
    return 0;
}
############# cycle date
function cycleDate($year, $month, $type = 'array') { 
    // Month ko normalize karo (string ya number dono allow)
    $monthNum = is_numeric($month) ? (int)$month : date('n', strtotime($month));

    // Previous month ki 21st
    $startDate = date("Y-m-d", strtotime("$year-$monthNum-21 -1 month"));
    // Current month ki 20th
    $endDate   = date("Y-m-d", strtotime("$year-$monthNum-20"));

    $dates = [];
    $current = strtotime($startDate);
    $end     = strtotime($endDate);

    while ($current <= $end) {
        $dates[] = date("Y-m-d", $current);
        $current = strtotime("+1 day", $current);
    }

    // Return format
    if ($type == 'array') {	
        return $dates;  // direct array
    } else {	
        return implode("','", $dates); // string
    }
}



################################################################


function calculateLeaveFinancialYear11111($contractStartDate, $financialYearStart, $leavesTakenByMonth = [],$empID) {
    $carryForward = 0;
    $result = [];
	
	//here check ki ish employee ko leave milegi ya nahi Yes to leave milegi no to nanhi milegi leave
	$leveCarryYesNO = self::fununiversal('emp_posting_info','leave_accrued','emp_id',$empID);
	if($leveCarryYesNO==1){$leaveCarrYN = 'yes'; }else{$leaveCarrYN = 'no';}
		
    $months = array_merge(range(4, 12), range(1, 3));
    foreach ($months as $month) {
        $year = ($month >= 4) ? $financialYearStart : $financialYearStart + 1;
        // getMonthlyLeaveEntitlement function ye check karta hai ki agar koi month ki 1 tarikh ko aaya hai to us mont ko 2.5 leave milegi or wo 15 ke baad aaya hai to us month us ko 1 leave milegi. next moth se 2.5 leave mile gi 
        $leaveEntitlement = self::getMonthlyLeaveEntitlement($contractStartDate, $month, $year);
        $leavesTaken = isset($leavesTakenByMonth["$year-$month"]) ? $leavesTakenByMonth["$year-$month"] : 0;

        // Total available = current entitlement + last month's carry forward
        $totalAvailable = $leaveEntitlement + $carryForward;

        // Now calculate unused from available
        $unusedLeave = $totalAvailable - $leavesTaken;
        if ($unusedLeave < 0) $unusedLeave = 0;				

        // Update carry forward for next month
        $carryForward = $unusedLeave;
		
		
if ($leaveCarrYN === 'yes') {
    $carryForward = $unusedLeave;
} else {
    $carryForward = 0;
}
	        $result["$year-$month"] = [
            'month' => date("F Y", mktime(0, 0, 0, $month, 10, $year)),
            'leaveEntitlement' => $leaveEntitlement,
            'leavesTaken' => $leavesTaken,
            'totalAvailable' => $totalAvailable,
            'carryForward' => $carryForward
        ];
    }

    return $result;
}


function calculateLeaveFinancialYear($contractStartDate, $financialYearStart, $leavesTakenByMonth = [], $empID) {
    $carryForward = 0;
    $result = [];

    // check if employee eligible for carry forward
    $leveCarryYesNO = self::fununiversal('emp_posting_info', 'leave_accrued', 'emp_id', $empID);
    $leaveCarrYN = ($leveCarryYesNO == 1) ? 'yes' : 'no';

    // financial year = Apr → Mar (cycles 21–20)
    $months = array_merge(range(4, 12), range(1, 3));

    foreach ($months as $month) {
        $year = ($month >= 4) ? $financialYearStart : $financialYearStart + 1;

        $cycleStart = date("Y-m-d", mktime(0, 0, 0, $month - 1, 21, $year));
        $cycleEnd   = date("Y-m-d", mktime(0, 0, 0, $month, 20, $year));

        // entitlement
        $leaveEntitlement = self::getMonthlyLeaveEntitlement($contractStartDate, $month, $year);

        // leaves taken in cycle
        $leavesTaken = 0;
        foreach ($leavesTakenByMonth as $leaveDate) {
            if ($leaveDate >= $cycleStart && $leaveDate <= $cycleEnd) {
                $leavesTaken++;
            }
        }

        // total available = entitlement + last cycle carry forward
        $totalAvailable = $leaveEntitlement + $carryForward;

        // unused
        $unusedLeave = $totalAvailable - $leavesTaken;
        if ($unusedLeave < 0) $unusedLeave = 0;

        // ✅ update carry forward correctly
        if ($leaveCarrYN === 'yes') {
            $carryForward = $unusedLeave;
        } else {
            $carryForward = 0;
        }

        $result["$year-$month"] = [
            'month' => date("F Y", mktime(0, 0, 0, $month, 10, $year)),
            'leaveEntitlement' => $leaveEntitlement,
            'leavesTaken' => $leavesTaken,
            'totalAvailable' => $totalAvailable,
            'carryForward' => $carryForward
        ];
    }

    return $result;
}



###################################    

############################# Invoice Leave Module #######################
function invoiceLeaveModule($empID,$y,$m){
	$contractStartDate = self::fununiversal('emp_posting_info','contractStartDate','emp_id',$empID);
    
	
	//echo '==='.$financialYearStart = date('Y'); // April 2025 to March 2026
$currentMonth = date('n');
$currentYear  = date('Y');

$financialYearStart = ($currentMonth >= 4)
    ? $currentYear
    : $currentYear - 1;

$formattedLeaves = [];
	
 //$leavesTakenByMonth = []; 
$leavesTakenByMonth =  self::montlyLeaveCount($empID);

foreach ($leavesTakenByMonth as $entry) {
    // example: 2025-04 → 2025-4
    $monthKey = date('Y-n', strtotime($entry['month']));
    $formattedLeaves[$monthKey] = $entry['total_leaves'];
}
return $leaveSummary = self::calculateLeaveFinancialYear($contractStartDate, $financialYearStart, $leavesTakenByMonth,$empID);	


}


############## leave mont wise
function leaveMonthWise($empID,$y,$m){
	
	$dstart = $y.'-'.str_pad($m, 2, '0', STR_PAD_LEFT).'-01';
	
	 $sartDate = date('Y-m-d',strtotime($dstart));
	 $enddate = date('Y-m-t',strtotime($sartDate));
	
	//SELECT emp_id, SUM(leaveDays)  FROM `jdsk_sams_apply_leave` WHERE `emp_id` LIKE '72' AND startDate >= '2025-04-01' AND endDate <= '2025-04-30';
	
$table_name     =  DB."apply_leave";	
$where          =  "leave_Approved=1 AND emp_id='".$empID."' AND startDate >= '".$sartDate."' AND endDate <= '".$enddate."'   ";	
	
$rowData        =  self::select($table_name,$where,$bind='',"SUM(leaveDays) AS total_leaves");
	$row = $rowData[0];
return $row['total_leaves'];	

	
}############## leave mont wise
function leaveMonthDates($empID,$y,$m){
	
	 $dstart = $y.'-'.str_pad($m, 2, '0', STR_PAD_LEFT).'-01';	
	 $sartDate = date('Y-m-d',strtotime($dstart));
	 $enddate = date('Y-m-t',strtotime($sartDate));
	
	//SELECT emp_id, SUM(leaveDays)  FROM `jdsk_sams_apply_leave` WHERE `emp_id` LIKE '72' AND startDate >= '2025-04-01' AND endDate <= '2025-04-30';
	
$table_name     =  DB."apply_leave";	
$where          =  "leave_Approved=1 AND emp_id='".$empID."' AND startDate >= '".$sartDate."' AND endDate <= '".$enddate."'   ";	
	
$rowData        =  self::select($table_name,$where,$bind='',"startDate,endDate,leaveDays");
	
	foreach ($rowData  as $k=>$lv){
		
		$dt[] = $lv['startDate'].' To '.$lv['endDate'].'&nbsp;&nbsp;&nbsp;&nbsp;['.$lv['leaveDays'].']';
		$dtIm = implode('<br>',$dt);
		
	}
		
return $dtIm;
	
}
############################# leave cycle 1 to 20 tak ###########

function leaveCycle($empID,$thisMonthAvaLeaveABC,$dY,$dM){
	
	$startD = date('Y-m-d',strtotime($dY.'-'.$dM.'-01'));
	$endD = date('Y-m-d',strtotime($dY.'-'.$dM.'-20'));
	
	
$table_name     =  DB."apply_leave";	
$where          =  "leave_Approved=1 AND emp_id='".$empID."' AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL) AND (  
        (DAY(startDate) BETWEEN '".$startD."' AND '".$endD."')       
        OR (DAY(endDate) BETWEEN '".$startD."' AND '".$endD."')       
        OR (DAY(startDate) < '".$startD."' AND DAY(endDate) > '".$endD."')
        ) ";		
$rowData        =  self::select($table_name,$where,$bind='',"emp_id,SUM(leaveDays) AS total_leave_days,
       GREATEST(SUM(leaveDays) - ".$thisMonthAvaLeaveABC.", 0) AS extra_leave_days");

$row = $rowData[0]; 

return $row['extra_leave_days'];

}
############################### days count in cycle 
function daysCountinCycle($m,$y){
	
$given_date =  date('Y-m-d',strtotime($y.'-'.$m));
		
$previous_month = date('m', strtotime('-1 month', strtotime($given_date)));
$previous_year  = date('Y', strtotime('-1 month', strtotime($given_date)));


$prMonthDate =  date('Y-m-21',strtotime($previous_year.'-'.$previous_month));
$curMonthDate =date('Y-m-20',strtotime($y.'-'.$m));	
		
$start   = strtotime($prMonthDate);
$end     = strtotime($curMonthDate);

$days = round(($end - $start) / (60 * 60 * 24)) + 1;
return $days;  
	
	//Simon ji ne bol tha
	//$curMonthStartDate = date('Y-m-d',strtotime($y.'-'.$m.'-01'));	
	//return $prevMonthLastDay = date("t", strtotime("-1 month", strtotime($curMonthStartDate)));	
	//return date('t', strtotime($y . '-' . $m));
	
 
// Current month ka 20th
//$ymGet2 = strtotime(date('Y-m-20', strtotime($y . '-' . $m)));

// Current month ka 1st
//$ymGetPreviousMonth = date('Y-m-d', strtotime($y . '-' . $m . '-01'));

// Previous month ka 21st
//$preMonth = strtotime(date('Y-m-21', strtotime('-1 month', strtotime($ymGetPreviousMonth))));

// Difference in seconds
//$diffSeconds = $ymGet2 - $preMonth;

// Convert seconds to days
//$days = $diffSeconds / (60 * 60 * 24);

//echo "Days difference: " . $days;        // Output: 30
//return ($days+1); // Output: 31

}
	
################################### check cycle MPDR table #######################
function checkMPDRCycleTable($genTBL,$empID,$m,$y,$getdata){
	//echo $empID.'====='.$m.'====='.$y.'====='.$getdata;
	
	     $startD = date('Y-m-01', strtotime($y . '-' . $m));
		 $endDate = date('Y-m-20', strtotime($y . '-' . $m));
		 
		 $tab4 = DB.$genTBL;			 
         $whe4  = "emp_id='".$empID."' AND mpdr_date between '".$startD."' AND '".$endDate."' AND mpdrActivities!='Leave' AND mpdr_program!='Holidays' ";
$rowArr=  self::select($tab4,$whe4,$bin4='',$getdata);

$row = $rowArr[0]; 
return  $row[$getdata]; 		 
		 
	
}
#########################################################################################################
function fununincuniversalMPDRCycle($tblName,$getdata,$colName,$condition,$colName2,$condition2,$thisMonthstaDate,$endDate){

                $table_name           =  DB.$tblName;	
				 $where                =  $colName."=:".$colName.' AND '.$colName2."=:".$colName2.'  AND mpdr_date between "'.$thisMonthstaDate.'" AND  "'.$endDate.'" ';	
				$bind                 =  array(":".$colName=>$condition,":".$colName2=>$condition2);
					
				$rowData              =  self::select($table_name,$where,$bind,$getdata);											
				$row  				  =  $rowData[0];
				return $row[$getdata];	
}
#############################################################


function getHalfDayLeave($empID,$getdate,$fld,$givenCondtion){
	
	
$table_name     =  DB."apply_leave";	
$where          =  "leave_Approved=1 AND emp_id='".$empID."' AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL) AND ".$fld." = '".$givenCondtion."' ";	
	
$rowData        =  self::select($table_name,$where,$bind='',$getdate);
$row  			=  $rowData[0];
return $row[$getdate];
	   
	   
}

##################################### 

function getOffSaturdaysManual($startDate, $endDate, $offSaturdays) {
    $offSaturdays = explode(',', $offSaturdays); // e.g. ['1', '3']
    $offDates = [];

    // Convert to timestamps
    $start = strtotime($startDate);
    $end = strtotime($endDate);

    // Loop through all dates from start to end
    for ($current = $start; $current <= $end; $current += 86400) { // 86400 = 1 day in seconds
        $dayOfWeek = date('N', $current); // 6 = Saturday

        if ($dayOfWeek == 6) {
            // Find which Saturday of the month it is
            $day = date('j', $current); // date number (1..31)
            $weekNum = (int)(($day - 1) / 7) + 1;

            if (in_array($weekNum, $offSaturdays)) {
                $offDates[] = date('Y-m-d', $current);
            }
        }
		
	$offDatesIM = implode("','",$offDates);
    }

    return $offDatesIM;
}

##########################################################
function caECAemailalertOnOff($consultantID){
	
    $table_name           =  DB."stop_ca_email_alert";	
	$where                =  "emp_id='".$consultantID."' AND status=1";
    $rowData              =  self::selectCount($table_name,$where,$bind='');	
	
	
	
	
	if($rowData[0]['count(*)']==1){
		$emailAlert = '<a href="caecaemailalert.php?o=0&i='.base64_encode($consultantID).'"><i class="fa fa-toggle-off" aria-hidden="true" style="color:red"> Off</i></a>';
	}else{
		$emailAlert = '<a href="caecaemailalert.php?o=1&i='.base64_encode($consultantID).'"><i class="fa fa-toggle-on" aria-hidden="true"> On</i></a>';
	}
	return $emailAlert;
}

################################################ WJCF ######################################
// Function to get used leaves within contract period
function getUsedLeaves($leaveType, $sessionData) {
    $tAL = DB."apply_leave";
    $wh = "leave_Approved=1 
           AND emp_id='".$sessionData['idEMP']."' 
           AND leaveSubject = '".$leaveType."' 
           AND startDate BETWEEN '".$sessionData['contractStartdate']."' AND '".$sessionData['contractEnddate']."' 
           AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL)";
    
    $rAL = self::select($tAL, $wh, '', "SUM(leaveDays) AS total_leaves");
    
    if($rAL && isset($rAL[0]['total_leaves'])) {
        return $rAL[0]['total_leaves'] ? floatval($rAL[0]['total_leaves']) : 0;
    }
    return 0;
}
	
function getLeaveBalanceDropdown($sessionData) {
    
    // Calculate contract duration in days
    $start = strtotime($sessionData['contractStartdate']);
    $end = strtotime($sessionData['contractEnddate']);
    $datediff = $end - $start;
    $days = round($datediff / (60 * 60 * 24));
    
    // Calculate months based on 30 days per month
    $totalDaysInPeriod = $days;
    $wholeMonths = floor($totalDaysInPeriod / 30);
    $remainingDays = $totalDaysInPeriod % 30;
    
    // Apply rounding rule for days
    if($remainingDays > 15) {
        $totalMonths = $wholeMonths + 1;
    } else {
        $totalMonths = $wholeMonths;
    }
    
    // If contract is less than 1 month, consider as 1 month minimum
    if($totalMonths < 1) {
        $totalMonths = 1;
    }
    
    // Calculate pro-rated leaves based on contract months
    // EL = (15/12) * totalMonths
    $elPerMonth = EL / 12; // 15/12 = 1.25 EL per month
    $EL = round($elPerMonth * $totalMonths);
    
    // CL + SL combined = (12/12) * totalMonths = 1 per month
    $clPerMonth = CL / 12; // 12/12 = 1 CL per month
    $totalCLSL = round($clPerMonth * $totalMonths);
    
    // Get used leaves
    $usedCasualLeave = self::getUsedLeaves('Casual Leave', $sessionData);
    $usedSickLeave = self::getUsedLeaves('Sick Leave', $sessionData);
    $usedEL = self::getUsedLeaves('Earned Leave', $sessionData);
    
    // Total used CL+SL
    $usedCLSL = $usedCasualLeave + $usedSickLeave;
    
    // ADJUSTMENT LOGIC: If CL+SL exceeds quota, adjust from EL
    $extraCLSL = max(0, $usedCLSL - $totalCLSL); // How much extra taken from CL+SL
    
    // Calculate available EL after adjustment
    $remainingEL = $EL - $usedEL - $extraCLSL;
    $displayEL = max(0, round($remainingEL));
    
    // Calculate available CL+SL (if within quota, show remaining; if exceeded, show 0)
    if($usedCLSL <= $totalCLSL) {
        $displayCLSL = round($totalCLSL - $usedCLSL);
    } else {
        $displayCLSL = 0; // Quota exhausted, adjusted from EL
    }
    
    // Return array with leave balances
    return [
        'CL' => [
            'total' => $totalCLSL, 
            'available' => $displayCLSL,
            'used' => $usedCLSL,
            'formula' => '(12/12) × ' . $totalMonths . ' months = ' . $totalCLSL
        ],
        'EL' => [
            'total' => $EL, 
            'available' => $displayEL,
            'used' => $usedEL,
            'formula' => '(15/12) × ' . $totalMonths . ' months = ' . $EL
        ],
        'gender' => $sessionData['staff_gender'],
        'contract_info' => [
            'days' => $days,
            'months_calculated' => $totalMonths,
            'whole_months' => $wholeMonths,
            'remaining_days' => $remainingDays,
            'start_date' => $sessionData['contractStartdate'],
            'end_date' => $sessionData['contractEnddate']
        ]
    ];
}


##########################
function getUsedLeavesAndTotalLeave($sessionData) {
        
        $tAL = DB."apply_leave";
        $wh = "leave_Approved=1 
               AND emp_id='".$sessionData['idEMP']."'                
               AND startDate BETWEEN '".$sessionData['contractStartdate']."' AND '".$sessionData['contractEnddate']."' 
               AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL)";
        
        $rAL = self::select($tAL, $wh, '', "SUM(leaveDays) AS total_leaves");
        
        if($rAL && isset($rAL[0]['total_leaves'])) {
            return $rAL[0]['total_leaves'] ? $rAL[0]['total_leaves'] : 0;
        }
        return 0;
		
		
    }

#################
function nowTotalLeaveCountBaseOnCA($sessionData, $leaveType) {
    
    // Calculate contract duration in days
    $start = strtotime($sessionData['contractStartdate']);
    $end = strtotime($sessionData['contractEnddate']);
    $datediff = $end - $start;
    $days = round($datediff / (60 * 60 * 24));
    
    // Calculate months based on 30 days per month
    $totalDaysInPeriod = $days;
    $wholeMonths = floor($totalDaysInPeriod / 30);
    $remainingDays = $totalDaysInPeriod % 30;
    
    // Apply rounding rule for days:
    if($remainingDays > 15) {
        $totalMonths = $wholeMonths + 1;
    } else {
        $totalMonths = $wholeMonths;
    }
    
    // If contract is less than 1 month, consider as 1 month minimum
    if($totalMonths < 1) {
        $totalMonths = 1;
    }
    
    // FIX: CL और SL का total count एक ही है
    // दोनों मिलकर 12 days per year (प्रो-rata)
    if(strtoupper($leaveType) == 'CASUAL LEAVE' || strtoupper($leaveType) == 'SICK LEAVE') {
        // CL/SL combined = (12/12) * totalMonths
        $clPerMonth = CL / 12; // 12/12 = 1 leave per month
        $leaveCount = round($clPerMonth * $totalMonths);
        $formula = '(12/12) × ' . $totalMonths . ' months = ' . $leaveCount . ' (CL+SL combined)';
    }
    else if(strtoupper($leaveType) == 'EARNED LEAVE') {
        // EL = (15/12) * totalMonths
        $elPerMonth = EL / 12; // 15/12 = 1.25 EL per month
        $leaveCount = round($elPerMonth * $totalMonths);
        $formula = '(15/12) × ' . $totalMonths . ' months = ' . $leaveCount;
    }
    else {
        $leaveCount = 0;
        $formula = 'Unknown leave type';
    }
    
    // Return array with leave count and details
    return [
        'leave_type' => $leaveType,
        'total_leaves' => $leaveCount,
        'contract_months' => $totalMonths,
        'contract_days' => $days,
        'formula' => $formula,
        'contract_info' => [
            'start_date' => $sessionData['contractStartdate'],
            'end_date' => $sessionData['contractEnddate'],
            'whole_months' => $wholeMonths,
            'remaining_days' => $remainingDays
        ]
    ];
}

####################  Attendance Data #######################################<br />
function getDataAttendance($empid,$dateType,$date,$getData){
	
 $tALle = DB."attendance";
        $whe = "emp_id='".$empid."'                
               AND $dateType = '".date('Y-m-d',strtotime($date))."'  ";
        
        $rAL2 = self::select($tALle, $whe, $bind='', $getData);
		$r2 = $rAL2[0];
		return   $r2[$getData];
			
}
##################################
function checkEmployeeAttendance($employee_id) {
    
	 $date = date('Y-m-d');
	
    // 1. Check if it's Sunday
    $timestamp = strtotime($date);
    $dayOfWeek = date('l', $timestamp);
    
    if ($dayOfWeek == 'Sunday') {
        echo "Today is Sunday, a (weekly off) - Date: " . $date.'<br>';
        return;
    }
	
    
    // 2. Check for Approved Leave
    $tAL = DB . "apply_leave";
    $wh = "leave_Approved=1 
           AND emp_id='" . $employee_id . "'                
           AND '" . $date . "' BETWEEN startDate AND endDate 
           AND (emp_cancel_leave_status = 0 OR emp_cancel_leave_reason IS NULL)";
    
    $rAL = self::select($tAL, $wh, '', "*");
    
    if (!empty($rAL)) {
        echo "You are on approved leave today.<br>";
        return;
    }
   
    // 3. Check for National Holidays
    $table_nameCHKL = DB . "emp_holidays";
    $whereCHKL = "holidays_date = '" . $date . "' AND status=1";    
    $rowDataFinal = self::select($table_nameCHKL, $whereCHKL, $bindCHKL='', "holidays_title");
    
    if (!empty($rowDataFinal)) {       
	    $holidayName = $rowDataFinal[0];		
        echo  $holidayName['holidays_title'] . " (National Holiday) on " . $date.'<br>';
        return;
    }
    
    // Agar kuch nahi milta to kuch echo nahi karna
    return;
}

// Function call examples:
// checkEmployeeAttendance('2024-01-26', 'EMP001');
// checkEmployeeAttendance('2024-01-28', 'EMP001'); // Sunday
// checkEmployeeAttendance('2024-12-25', 'EMP001'); // Christmas
#################################################################################
function attendance_duration($empid, $att_date) {
    $table_name = DB . "attendance";
    $where = "emp_id = '" . $empid . "' AND att_check_in_date = '" . $att_date . "' AND (att_check_out_date = '" . $att_date . "' OR att_check_out_date IS NULL)";
    
    $rowCountCom = self::selectCount($table_name, $where, '');
    $numCOM = $rowCountCom[0]['count(*)'];
    
    if($numCOM > 0) {  // $numCOM != '' ki jagah > 0 use karein
        $rowData = self::select($table_name, $where, '', "*");
        $total_seconds = 0;
        
        foreach ($rowData as $attendance) {
            // Check-in time
            $check_in = $attendance['att_check_in_date'] . ' ' . $attendance['att_check_in_time'];
            
            // Check-out time (agar check-out nahi hai toh current time lein)
            if (!empty($attendance['att_check_out_date']) && !empty($attendance['att_check_out_time'])) {
                $check_out = $attendance['att_check_out_date'] . ' ' . $attendance['att_check_out_time'];
            } else {
                // Agar check-out nahi kiya hai toh current time lein
                $check_out = date('Y-m-d H:i:s');
            }
            
            // DateTime objects banayein
            $start = new DateTime($check_in);
            $end = new DateTime($check_out);
            
            // Interval nikaalein
            $interval = $start->diff($end);
            
            // Total seconds mein convert karein
            $seconds = $interval->days * 86400 + $interval->h * 3600 + $interval->i * 60 + $interval->s;
            $total_seconds += $seconds;
        }
        
        // Total duration ko hours aur minutes mein convert karein
        $hours = floor($total_seconds / 3600);
        $minutes = floor(($total_seconds % 3600) / 60);
        $seconds = $total_seconds % 60;
        
        // Format: "X hours Y minutes Z seconds"
        $duration_formatted = $hours . " hours " . $minutes . " minutes " . $seconds . " seconds";
        
        // Ya phir aap sirf hours mein decimal return kar sakte hain
        $duration_decimal = round($total_seconds / 3600, 2);
        
        return [
            'total_seconds' => $total_seconds,
            'formatted' => $duration_formatted,
            'hours_decimal' => $duration_decimal,
            'total_records' => count($rowData)
        ];
    } else {
        // Agar koi record nahi mila toh empty array return karein
        return [
            'total_seconds' => 0,
            'formatted' => '',
            'hours_decimal' => 0,
            'total_records' => 0,
            'message' => 'No attendance records found for this employee on ' . $att_date
        ];
    }
}

//echo "Total Records: " . $result['total_records'] . "<br>";
//echo "Formatted Duration: " . $result['formatted'] . "<br>";
//echo "Decimal Hours: " . $result['hours_decimal'] . " hours<br>";
//echo "Total Seconds: " . $result['total_seconds'] . " seconds";
########################################################################









#####################################################################################################################

###################################################Class Close #####################################################################################
					
					 }                               ######
					 
###############################################Class Close##########################################################################################

class IndianCurrency{

  public function __construct($amount){
    $this->amount=$amount;
    $this->hasPaisa=false;
    $arr=explode(".",$this->amount);
    $this->rupees=$arr[0];
    if(isset($arr[1])&&((int)$arr[1])>0){
      if(strlen($arr[1])>2){
        $arr[1]=substr($arr[1],0,2);
      }
      $this->hasPaisa=true;
      $this->paisa=$arr[1];
    }
  }
  
  public function get_words(){
    $w="";
    $crore=(int)($this->rupees/10000000);
    $this->rupees=$this->rupees%10000000;
    $w.=$this->single_word($crore,"Cror ");
    $lakh=(int)($this->rupees/100000);
    $this->rupees=$this->rupees%100000;
    $w.=$this->single_word($lakh," Lakh ");
    $thousand=(int)($this->rupees/1000);
    $this->rupees=$this->rupees%1000;
    $w.=$this->single_word($thousand," Thousand  ");
    $hundred=(int)($this->rupees/100);
    $w.=$this->single_word($hundred," Hundred ");
    $ten=$this->rupees%100;
    $w.=$this->single_word($ten,"");
    $w.="Rupees ";
  
    if($this->hasPaisa){
      if($this->paisa[0]=="0"){
        $this->paisa=(int)$this->paisa;
      }
      else if(strlen($this->paisa)==1){
        $this->paisa=$this->paisa*10;
      }
      $w.=" and ".$this->single_word($this->paisa," Paisa");
    }
    return $w." Only";
  }

  private function single_word($n,$txt){
    $t="";
    if($n<=19){
      $t=$this->words_array($n);
    }else{
      $a=$n-($n%10);
      $b=$n%10;
      $t=$this->words_array($a)." ".$this->words_array($b);
    }
    if($n==0){
      $txt="";
    }
    return $t."".$txt;
  }

  private function words_array($num){
    $n=[0=>"", 1=>"One", 2=>"Two", 3=>"Three", 4=>"Four", 5=>"Five", 6=>"Six", 7=>"Seven", 8=>"Eight", 9=>"Nine", 10=>"Ten", 11=>"Eleven", 12=>"Twelve", 13=>"Thirteen", 14=>"Fourteen", 15=>"Fifteen", 16=>"Sixteen", 17=>"Seventeen", 18=>"Eighteen", 19=>"Nineteen", 20=>"Twenty", 30=>"Thirty", 40=>"Forty", 50=>"Fifty", 60=>"Sixty", 70=>"Seventy", 80=>"Eighty", 90=>"Ninety", 100=>"Hundred",];
    return $n[$num];
  }
}
?>