<?php
function getCorrectMonthsCount($startDate, $endDate) {
    $start = new DateTime($startDate);
    $end = new DateTime($endDate);

    // Calculate the difference in years, months, and days
    $diff = $start->diff($end);

    // Convert years into months and add remaining months
    $months = ($diff->y * 12) + $diff->m;

    // If the day of end date is greater than or equal to start date, count as full month
    if ($diff->d >= 0) {
        $months += 1;
    }

    return $months;
}

// Example usage
$startDate = '2025-02-15';
$endDate = '2025-05-14';

echo "Total Months: " . getCorrectMonthsCount($startDate, $endDate); // Output: 3
?>
