<?php
function calculateMonthlyLeave($startDate, $endDate, $month, $year, $leavesTaken = 0, $carryForward = 0) {
    // Dates
    $monthStart = strtotime("$year-$month-01");
    $monthEnd = strtotime(date("Y-m-t", $monthStart)); // Last day of the month
    $midMonth = strtotime("$year-$month-15");

    $start = strtotime($startDate);
    $end = strtotime($endDate);

    $leaveThisMonth = 0;

    // If contract is active in this month
    if ($start <= $monthEnd && $end >= $monthStart) {
        // Contract started this month
        if (date('Y-m', $start) == date('Y-m', $monthStart)) {
            $leaveThisMonth = ($start <= $midMonth) ? 2.5 : 1;
        }
        // Contract ends this month
        elseif (date('Y-m', $end) == date('Y-m', $monthStart)) {
            $leaveThisMonth = ($end <= $midMonth) ? 1 : 2.5;
        }
        // Contract is active the full month
        else {
            $leaveThisMonth = 2.5;
        }
    }

    // Carry forward logic
    $unusedLeave = $leaveThisMonth - $leavesTaken;
    if ($unusedLeave < 0) $unusedLeave = 0;

    $carryForward += $unusedLeave;

    return [
        'leaveThisMonth' => $leaveThisMonth,
        'leavesTaken' => $leavesTaken,
        'carryForward' => $carryForward
    ];
}

// Example usage:
$result = calculateMonthlyLeave('2025-04-10', '2025-07-20', 5, 2025, 5, 0);
print_r($result);
?>
