<?php
function getMonthlyLeaveEntitlement($contractStartDate, $month, $year) {
    $start = strtotime($contractStartDate);
    $monthStart = strtotime("$year-$month-01");
    $midMonth = strtotime("$year-$month-15");

    if (date('Y-m', $start) == date('Y-m', $monthStart)) {
        return ($start <= $midMonth) ? 2.5 : 1;
    }

    if ($start < $monthStart) {
        return 2.5;
    }

    return 0;
}

function calculateLeaveFinancialYear($contractStartDate, $financialYearStart, $leavesTakenByMonth = []) {
    $carryForward = 0;
    $result = [];

    $months = array_merge(range(4, 12), range(1, 3));
    foreach ($months as $month) {
        $year = ($month >= 4) ? $financialYearStart : $financialYearStart + 1;

        $leaveEntitlement = getMonthlyLeaveEntitlement($contractStartDate, $month, $year);
        $leavesTaken = isset($leavesTakenByMonth["$year-$month"]) ? $leavesTakenByMonth["$year-$month"] : 0;

        // Total available = current entitlement + last month's carry forward
        $totalAvailable = $leaveEntitlement + $carryForward;

        // Now calculate unused from available
        $unusedLeave = $totalAvailable - $leavesTaken;
        if ($unusedLeave < 0) $unusedLeave = 0;

        // Update carry forward for next month
        $carryForward = $unusedLeave;

        $result["$year-$month"] = [
            'month' => date("F Y", mktime(0, 0, 0, $month, 10, $year)),
            'leaveEntitlement' => $leaveEntitlement,
            'leavesTaken' => $leavesTaken,
            'totalAvailable' => $totalAvailable,
            'carryForward' => $carryForward
        ];
    }

    return $result;
}
// Example: Contract started on 5-April-2025. Took 1 leave in April 2025.
$contractStartDate = '2025-04-05';
$financialYearStart = 2025; // April 2025 to March 2026

$leavesTakenByMonth = [
    '2025-4' => 2.0,  // April 2025
    '2025-5' => 3.0   // May 2025
];

$leaveSummary = calculateLeaveFinancialYear($contractStartDate, $financialYearStart, $leavesTakenByMonth);

// Print sample months
//print_r($leaveSummary['2025-4']); // April 2025
//print_r($leaveSummary['2025-5']); // May 2025

print_r($leaveSummary['2025-5']['totalAvailable']);
echo '<br>';
echo '<pre>';
print_r($leaveSummary); 

?>
